/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.ExtendedLanguageCode;
import com.apple.jingle.locale.ExtensionCode;
import com.apple.jingle.locale.ISO15924Alpha4ScriptCode;
import com.apple.jingle.locale.ISO3166Alpha2RegionCode;
import com.apple.jingle.locale.ISO639Alpha2PrimaryLanguageCode;
import com.apple.jingle.locale.ISO639Alpha3ExtendedLanguageCode;
import com.apple.jingle.locale.ISO639Alpha3PrimaryLanguageCode;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.LanguageTagMatch;
import com.apple.jingle.locale.PrimaryLanguageCode;
import com.apple.jingle.locale.PrivateUseCode;
import com.apple.jingle.locale.RegionCode;
import com.apple.jingle.locale.ScriptCode;
import com.apple.jingle.locale.UNM49RegionCode;
import com.apple.jingle.locale.VariantCode;
import com.apple.jingle.locale.impl.BCP47TagComponents;
import com.apple.jingle.locale.impl.IANALanguageSubtagRegistry;
import com.apple.jingle.locale.impl.LanguageTagImpl;
import com.apple.jingle.locale.impl.RFC5646TagParser;
import com.apple.jingle.locale.impl.matching.BCP47TagComponentBasedMatching;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class BCP47TagImpl
extends LanguageTagImpl
implements BCP47Tag {
    private static final long serialVersionUID = 1L;
    private BCP47TagComponents tagComponents = null;
    private Locale locale = null;

    protected BCP47TagImpl() {
    }

    protected BCP47TagImpl(String wholeTag, PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes, ExtensionCode extensionCode, PrivateUseCode privateUseCode) {
        super(wholeTag);
        this.tagComponents = new BCP47TagComponents(primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode);
        this.setValue(this.tagComponents.createValue());
        this.setPreferredValue(this.tagComponents.createPreferedValue());
        this.setDisplayName(this.tagComponents.createDisplayName());
    }

    protected BCP47TagImpl(String wholeTag) {
        super(wholeTag);
    }

    protected BCP47TagComponents getTagComponents() {
        return this.tagComponents;
    }

    @Override
    public RegionCode getRegionCode() {
        return this.getTagComponents().getRegionCode();
    }

    @Override
    public ISO3166Alpha2RegionCode getISO3166CountryCode() {
        RegionCode regionSubtag = this.getRegionCode();
        return regionSubtag instanceof ISO3166Alpha2RegionCode ? (ISO3166Alpha2RegionCode)regionSubtag : null;
    }

    @Override
    public UNM49RegionCode getUNM49RegionCode() {
        RegionCode regionCode = this.getRegionCode();
        return regionCode instanceof UNM49RegionCode ? (UNM49RegionCode)regionCode : null;
    }

    @Override
    public String getRegionSubtag() {
        RegionCode regionSubtag = this.getRegionCode();
        return regionSubtag != null ? regionSubtag.getValue() : null;
    }

    @Override
    public PrimaryLanguageCode getPrimaryLanguageCode() {
        return this.getTagComponents().getPrimaryLanguageCode();
    }

    @Override
    public ISO639Alpha2PrimaryLanguageCode getISO639Alpha2PrimaryLanguageCode() {
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        return primaryLanguageCode instanceof ISO639Alpha2PrimaryLanguageCode ? (ISO639Alpha2PrimaryLanguageCode)primaryLanguageCode : null;
    }

    @Override
    public ISO639Alpha3PrimaryLanguageCode getISO639Alpha3PrimaryLanguageCode() {
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        return primaryLanguageCode instanceof ISO639Alpha3PrimaryLanguageCode ? (ISO639Alpha3PrimaryLanguageCode)primaryLanguageCode : null;
    }

    @Override
    public String getPrimaryLanguageSubtag() {
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        return primaryLanguageCode != null ? primaryLanguageCode.getValue() : null;
    }

    @Override
    public ExtendedLanguageCode[] getExtendedLanguageCodes() {
        ExtendedLanguageCode[] extendedLanguageCodes = this.getTagComponents().getExtendedLanguageCodes();
        return extendedLanguageCodes;
    }

    @Override
    public String[] getExtendedlanguageSubtags() {
        ExtendedLanguageCode[] extendedLanguageCodes = this.getTagComponents().getExtendedLanguageCodes();
        if (extendedLanguageCodes == null || extendedLanguageCodes.length == 0) {
            return null;
        }
        String[] extendedLanguageSubtags = new String[extendedLanguageCodes.length];
        for (int i = 0; i < extendedLanguageCodes.length; ++i) {
            extendedLanguageSubtags[i] = extendedLanguageCodes[i].getValue();
        }
        return extendedLanguageSubtags;
    }

    @Override
    public ISO639Alpha3ExtendedLanguageCode[] getISO639Alpha3ExtendedLanguageCodes() throws BCP47TagParseException {
        ExtendedLanguageCode[] extendedLanguageCodes = this.getTagComponents().getExtendedLanguageCodes();
        if (extendedLanguageCodes == null || extendedLanguageCodes.length == 0) {
            return null;
        }
        ISO639Alpha3ExtendedLanguageCode[] iso639Alpha3ExtendedLanguageCodes = new ISO639Alpha3ExtendedLanguageCode[extendedLanguageCodes.length];
        for (int i = 0; i < extendedLanguageCodes.length; ++i) {
            if (!(extendedLanguageCodes[i] instanceof ISO639Alpha3ExtendedLanguageCode)) {
                throw new BCP47TagParseException("ExtendedLanguageCode is an instance of [" + extendedLanguageCodes[i].getClass().getName() + "], not [" + ISO639Alpha3ExtendedLanguageCode.class.getName() + "]");
            }
            iso639Alpha3ExtendedLanguageCodes[i] = (ISO639Alpha3ExtendedLanguageCode)extendedLanguageCodes[i];
        }
        return iso639Alpha3ExtendedLanguageCodes;
    }

    @Override
    public ScriptCode getScriptCode() {
        return this.getTagComponents().getScriptCode();
    }

    @Override
    public ISO15924Alpha4ScriptCode getISO15924Alpha4ScriptCode() {
        ScriptCode scriptCode = this.getTagComponents().getScriptCode();
        return scriptCode instanceof ISO15924Alpha4ScriptCode ? (ISO15924Alpha4ScriptCode)scriptCode : null;
    }

    @Override
    public String getScriptSubtag() {
        ScriptCode scriptCode = this.getTagComponents().getScriptCode();
        return scriptCode != null ? scriptCode.getValue() : null;
    }

    public VariantCode[] getVariantCodes() {
        return this.getTagComponents().getVariantCodes();
    }

    @Override
    public String[] getVariantSubtags() {
        VariantCode[] variantCodes = this.getVariantCodes();
        if (variantCodes == null || variantCodes.length == 0) {
            return null;
        }
        String[] variantSubtags = new String[variantCodes.length];
        for (int i = 0; i < variantCodes.length; ++i) {
            variantSubtags[i] = variantCodes[i].getValue();
        }
        return variantSubtags;
    }

    @Override
    public String getExtensionSubtag() {
        ExtensionCode extensionCode = this.getTagComponents().getExtensionCode();
        return extensionCode != null ? extensionCode.getValue() : null;
    }

    @Override
    public String getPrivateUseSubtag() {
        PrivateUseCode privateUseCode = this.getTagComponents().getPrivateUseCode();
        return privateUseCode != null ? privateUseCode.getValue() : null;
    }

    @Override
    public String getRFC4646Tag() {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getRFC4646Tag();
    }

    @Override
    public void setName(String code) {
        throw new UnsupportedOperationException("RFC5656Tag is immutable. Use the RFC5646TagParser to create a new instance");
    }

    @Override
    public String getRFC4646Language() {
        return this.getPrimaryLanguageSubtag();
    }

    @Override
    public String getRFC4646Script() {
        return this.getScriptSubtag();
    }

    @Override
    public String getRFC4646Extension() {
        return this.getExtensionSubtag();
    }

    @Override
    public String getRFC4646Irregular() {
        return null;
    }

    @Override
    public String getRFC4646Variant() {
        return StringUtils.join((Object[])this.getVariantSubtags(), (String)"-");
    }

    @Override
    public String getRFC4646Region() {
        return this.getRegionSubtag();
    }

    @Override
    public String getISO2Country() {
        return this.getISO3166Country2A();
    }

    @Override
    public String getISO3166Country2A() {
        RegionCode regionCode = this.getRegionCode();
        if (regionCode instanceof ISO3166Alpha2RegionCode) {
            return regionCode.getValue();
        }
        return null;
    }

    @Override
    public String getISO3166Country3A() {
        return null;
    }

    @Override
    public String getISO3Country() {
        return this.getISO3166Country3A();
    }

    @Override
    public String getUNRegion() {
        return this.getM39Region3N();
    }

    @Override
    public String getM39Region3N() {
        RegionCode regionCode = this.getRegionCode();
        if (regionCode instanceof UNM49RegionCode) {
            return regionCode.getValue();
        }
        return null;
    }

    @Override
    public String getISO3Language() {
        return this.getISO6392TLanguage3A();
    }

    @Override
    public String getISO6392TLanguage3A() {
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        if (primaryLanguageCode instanceof ISO639Alpha3PrimaryLanguageCode) {
            return this.from3CharCodeToISO6392TCode(primaryLanguageCode);
        }
        if (primaryLanguageCode instanceof ISO639Alpha2PrimaryLanguageCode) {
            return this.from2CharCodeToISO6392TCode(primaryLanguageCode);
        }
        return null;
    }

    private String from2CharCodeToISO6392TCode(PrimaryLanguageCode primaryLanguageCode) {
        try {
            ISO639_2Code iso6392 = ISO639_2Code.getISO6392CodeForBCP47PrimaryLanguageSubtag(primaryLanguageCode.getValue());
            return iso6392.getT();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String from3CharCodeToISO6392TCode(PrimaryLanguageCode primaryLanguageCode) {
        if (ISO639_2Code.containsTCode(primaryLanguageCode.getValue())) {
            return primaryLanguageCode.getValue();
        }
        LanguageTag macrolanguage = primaryLanguageCode.getMacrolanguage();
        if (macrolanguage != null && macrolanguage instanceof BCP47Tag) {
            return ((BCP47Tag)macrolanguage).getISO6392TLanguage3A();
        }
        return "und";
    }

    @Override
    public String getISO6392Language2A() {
        LanguageTag macrolanguage;
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        if (primaryLanguageCode instanceof ISO639Alpha2PrimaryLanguageCode) {
            return primaryLanguageCode.getValue();
        }
        if (primaryLanguageCode instanceof ISO639Alpha3PrimaryLanguageCode && (macrolanguage = primaryLanguageCode.getMacrolanguage()) != null && macrolanguage instanceof BCP47Tag) {
            return ((BCP47Tag)macrolanguage).getISO6392Language2A();
        }
        return null;
    }

    @Override
    public String getISO2Language() {
        return this.getISO6392Language2A();
    }

    @Override
    public String getISO6393Description() {
        IANALanguageSubtagRegistry.RegistryEntry entry;
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        if (primaryLanguageCode instanceof ISO639Alpha3PrimaryLanguageCode && (entry = IANALanguageSubtagRegistry.getInstance().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.language, primaryLanguageCode.getValue())) != null) {
            IANALanguageSubtagRegistry.RegistryEntry.RegistryEntryValue<?> val = entry.getDescription();
            if (val == null) {
                return "";
            }
            Object obj1 = val.getValue();
            if (obj1 instanceof String) {
                return (String)obj1;
            }
        }
        return "";
    }

    @Override
    public String getMacroLanguage() {
        LanguageTag macrolanguage;
        PrimaryLanguageCode primaryLanguageCode = this.getPrimaryLanguageCode();
        if (primaryLanguageCode instanceof ISO639Alpha3PrimaryLanguageCode && (macrolanguage = primaryLanguageCode.getMacrolanguage()) != null && macrolanguage instanceof BCP47Tag) {
            return ((BCP47Tag)macrolanguage).getISO6392TLanguage3A();
        }
        return "";
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.forLanguageTag(this.getValue());
        }
        return this.locale;
    }

    @Override
    public LanguageTag.TagAttribute getTagAttribute() {
        PrimaryLanguageCode.Scope scope = this.getPrimaryLanguageCode().getScope();
        if (scope == null) {
            return LanguageTag.TagAttribute.Valid;
        }
        switch (scope) {
            case Macrolanguage: {
                return LanguageTag.TagAttribute.Macrolanguage;
            }
            case Collection: {
                return LanguageTag.TagAttribute.Collection;
            }
            case Special: {
                return LanguageTag.TagAttribute.Special;
            }
            case PrivateUse: {
                return LanguageTag.TagAttribute.PrivateUse;
            }
        }
        return LanguageTag.TagAttribute.Valid;
    }

    @Override
    public LanguageTagMatch getBestMatch(LanguageTag other) {
        return BCP47TagComponentBasedMatching.getBestMatch(this, other);
    }

    public ExtensionCode getExtensionCode() {
        return this.getTagComponents().getExtensionCode();
    }

    public PrivateUseCode getPrivateUseCode() {
        return this.getTagComponents().getPrivateUseCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BCP47Tag) {
            BCP47Tag otherBCP47Tag = (BCP47Tag)other;
            return this.getPreferredValue().equals(otherBCP47Tag.getPreferredValue());
        }
        return super.equals(other);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readExternal(input);
        try {
            this.initializeTagComponents();
        }
        catch (BCP47TagParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void initializeTagComponents() throws BCP47TagParseException {
        LanguageTag tag = new RFC5646TagParser().parse(this.getValue(), this.shouldValidateOnDeserialization());
        if (tag instanceof BCP47TagImpl) {
            BCP47TagImpl bcpTag = (BCP47TagImpl)tag;
            this.tagComponents = bcpTag.getTagComponents();
        }
    }

    protected boolean shouldValidateOnDeserialization() {
        return true;
    }
}

