/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.locale.Code;
import com.apple.jingle.locale.ExtendedLanguageCode;
import com.apple.jingle.locale.ExtensionCode;
import com.apple.jingle.locale.PrimaryLanguageCode;
import com.apple.jingle.locale.PrivateUseCode;
import com.apple.jingle.locale.RegionCode;
import com.apple.jingle.locale.ScriptCode;
import com.apple.jingle.locale.VariantCode;
import java.io.Serializable;

public class BCP47TagComponents
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PrimaryLanguageCode primaryLanguageCode = null;
    private ExtendedLanguageCode[] extendedLanguageCodes = null;
    private ScriptCode scriptCode = null;
    private VariantCode[] variantCodes = null;
    private RegionCode regionCode = null;
    private ExtensionCode extensionCode = null;
    private PrivateUseCode privateUseCode = null;

    public BCP47TagComponents(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes, ExtensionCode extensionCode, PrivateUseCode privateUseCode) {
        this.primaryLanguageCode = primaryLanguageCode;
        this.extendedLanguageCodes = extendedLanguageCodes;
        this.scriptCode = scriptCode;
        this.regionCode = regionCode;
        this.variantCodes = variantCodes;
        this.extensionCode = extensionCode;
        this.privateUseCode = privateUseCode;
    }

    public PrimaryLanguageCode getPrimaryLanguageCode() {
        return this.primaryLanguageCode;
    }

    public ExtendedLanguageCode[] getExtendedLanguageCodes() {
        return this.extendedLanguageCodes;
    }

    public ScriptCode getScriptCode() {
        return this.scriptCode;
    }

    public VariantCode[] getVariantCodes() {
        return this.variantCodes;
    }

    public RegionCode getRegionCode() {
        return this.regionCode;
    }

    public ExtensionCode getExtensionCode() {
        return this.extensionCode;
    }

    public PrivateUseCode getPrivateUseCode() {
        return this.privateUseCode;
    }

    public String createPreferedValue() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createPreferredPrimaryLanguageCode(stringBuilder);
        this.createPreferredExtendedLanguageCodes(stringBuilder);
        this.createPreferredScriptCode(stringBuilder);
        this.createPreferredRegionCode(stringBuilder);
        this.createPreferredVariantCodes(stringBuilder);
        this.createExtensionSubtag(stringBuilder);
        this.createPrivateUseSubtag(stringBuilder);
        return stringBuilder.toString();
    }

    private void createPrivateUseSubtag(StringBuilder stringBuilder) {
        String privateUseSubtag;
        String string = privateUseSubtag = this.getPrivateUseCode() != null ? this.getPrivateUseCode().getPreferredValue() : null;
        if (privateUseSubtag != null) {
            stringBuilder.append("-");
            stringBuilder.append(privateUseSubtag);
        }
    }

    private void createExtensionSubtag(StringBuilder stringBuilder) {
        String extensionSubtag;
        String string = extensionSubtag = this.getExtensionCode() != null ? this.getExtensionCode().getPreferredValue() : null;
        if (extensionSubtag != null) {
            stringBuilder.append("-");
            stringBuilder.append(extensionSubtag);
        }
    }

    private void createPreferredVariantCodes(StringBuilder stringBuilder) {
        if (this.getVariantCodes() != null) {
            for (VariantCode code : this.getVariantCodes()) {
                stringBuilder.append("-");
                stringBuilder.append(code.getPreferredValue());
            }
        }
    }

    private void createPreferredRegionCode(StringBuilder stringBuilder) {
        if (this.getRegionCode() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.getRegionCode().getPreferredValue());
        }
    }

    private void createPreferredScriptCode(StringBuilder stringBuilder) {
        if (this.getScriptCode() != null) {
            String suppressScript = this.getPrimaryLanguageCode().getSuppressScript();
            String scriptTag = this.getScriptCode().getPreferredValue();
            if (scriptTag != null && !scriptTag.equals(suppressScript)) {
                stringBuilder.append("-");
                stringBuilder.append(scriptTag);
            }
        }
    }

    private void createPreferredExtendedLanguageCodes(StringBuilder stringBuilder) {
        if (this.getExtendedLanguageCodes() != null) {
            for (ExtendedLanguageCode code : this.getExtendedLanguageCodes()) {
                if (code.isReset()) continue;
                stringBuilder.append("-");
                stringBuilder.append(code.getPreferredValue());
            }
        }
    }

    private void createPreferredPrimaryLanguageCode(StringBuilder stringBuilder) {
        stringBuilder.append(this.getPrimaryLanguageCode().getPreferredValue());
    }

    public String createValue() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createPrimaryLanguageCode(stringBuilder);
        this.createExtendedLanguageCodes(stringBuilder);
        this.createScriptCode(stringBuilder);
        this.createRegionCode(stringBuilder);
        this.createVariantCodes(stringBuilder);
        this.createExtensionSubtag(stringBuilder);
        this.createPrivateUseSubtag(stringBuilder);
        return stringBuilder.toString();
    }

    private void createPrimaryLanguageCode(StringBuilder stringBuilder) {
        stringBuilder.append(this.getPrimaryLanguageCode().getValue());
    }

    private void createExtendedLanguageCodes(StringBuilder stringBuilder) {
        if (this.getExtendedLanguageCodes() != null) {
            for (ExtendedLanguageCode code : this.getExtendedLanguageCodes()) {
                stringBuilder.append("-");
                stringBuilder.append(code.getValue());
            }
        }
    }

    private void createScriptCode(StringBuilder stringBuilder) {
        if (this.getScriptCode() != null) {
            String scriptTag = this.getScriptCode().getValue();
            stringBuilder.append("-");
            stringBuilder.append(scriptTag);
        }
    }

    private void createRegionCode(StringBuilder stringBuilder) {
        if (this.getRegionCode() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.getRegionCode().getValue());
        }
    }

    private void createVariantCodes(StringBuilder stringBuilder) {
        if (this.getVariantCodes() != null) {
            for (VariantCode code : this.getVariantCodes()) {
                stringBuilder.append("-");
                stringBuilder.append(code.getValue());
            }
        }
    }

    public String createDisplayName() {
        boolean first;
        StringBuilder stringBuilder = new StringBuilder().append(this.getPrimaryLanguageCode().getDescription());
        boolean commaNeeded = false;
        boolean openParenNeeded = true;
        String open_paren = " (";
        String comma = ", ";
        String close_paren = ")";
        if (this.extendedLanguageCodes != null) {
            stringBuilder.append(" (");
            openParenNeeded = false;
            first = true;
            for (Code code : this.extendedLanguageCodes) {
                if (code.isReset()) continue;
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                if (code.getDescription() != null) {
                    stringBuilder.append(code.getDescription());
                }
                commaNeeded = true;
            }
        }
        if (this.scriptCode != null) {
            if (openParenNeeded) {
                stringBuilder.append(" (");
                openParenNeeded = false;
            } else if (commaNeeded) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.scriptCode.getDescription());
            commaNeeded = true;
        }
        if (this.regionCode != null) {
            if (openParenNeeded) {
                stringBuilder.append(" (");
                openParenNeeded = false;
            } else if (commaNeeded) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.regionCode.getDescription());
            commaNeeded = true;
        }
        if (this.variantCodes != null) {
            if (openParenNeeded) {
                stringBuilder.append(" (");
                openParenNeeded = false;
            } else if (commaNeeded) {
                stringBuilder.append(", ");
            }
            first = true;
            for (Code code : this.variantCodes) {
                if (code.isReset()) continue;
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                if (code.getDescription() != null) {
                    stringBuilder.append(code.getDescription());
                }
                commaNeeded = true;
            }
        }
        if (stringBuilder.indexOf(" (") >= 0) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

