/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale;

import com.apple.jingle.locale.Code;
import com.apple.jingle.locale.LanguageTag;

public interface PrimaryLanguageCode
extends Code {
    public String getSuppressScript();

    public Scope getScope();

    public LanguageTag getMacrolanguage();

    public static enum Scope {
        Macrolanguage("macrolanguage"),
        Collection("collection"),
        Special("special"),
        PrivateUse("private-use");

        private String value;

        private Scope(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Scope fromValue(String value) {
            for (Scope s : Scope.values()) {
                if (!s.value().equals(value)) continue;
                return s;
            }
            return null;
        }

        public boolean isMacrolanguage() {
            return Macrolanguage.equals((Object)this);
        }

        public boolean isSpecial() {
            return Special.equals((Object)this);
        }

        public boolean isCollection() {
            return Collection.equals((Object)this);
        }

        public boolean isPrivateUse() {
            return PrivateUse.equals((Object)this);
        }
    }
}

