/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale;

import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.PrimaryLanguageCode;
import com.apple.jingle.locale.ScriptCode;
import org.apache.log4j.Logger;

public class LocaleUtility {
    private static final Logger log = Logger.getLogger(LocaleUtility.class);
    private static final String LATN_SCRIPT_CODE = "Latn";

    public static String determineScriptForLocaleName(String localeName) {
        try {
            LanguageTag languageTag = BCP47TagSupport.createTag(localeName);
            if (languageTag instanceof BCP47Tag) {
                ScriptCode scriptCode = ((BCP47Tag)languageTag).getScriptCode();
                if (scriptCode != null) {
                    return scriptCode.getValue();
                }
                PrimaryLanguageCode primaryLanguageCode = ((BCP47Tag)languageTag).getPrimaryLanguageCode();
                return primaryLanguageCode.getSuppressScript();
            }
        }
        catch (Exception e) {
            log.error((Object)("error determining script code " + e));
        }
        return null;
    }

    public static boolean isLatnScriptLocale(String localeName) {
        String script = LocaleUtility.determineScriptForLocaleName(localeName);
        return LATN_SCRIPT_CODE.equals(script);
    }

    public static String latinScriptCode() {
        return LATN_SCRIPT_CODE;
    }

    public static boolean isEqualByScript(String localeName1, String localeName2) {
        String script1 = LocaleUtility.determineScriptForLocaleName(localeName1);
        String script2 = LocaleUtility.determineScriptForLocaleName(localeName2);
        if (script1 == null || script2 == null) {
            return false;
        }
        return script1.equals(script2);
    }
}

