/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale;

import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.PrimaryLanguageCode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ISO639_2Code {
    private static final ISO639_2Code[] ISO6392Codes = new ISO639_2Code[]{new ISO639_2Code("aar", "aar", "aa", "Afar"), new ISO639_2Code("abk", "abk", "ab", "Abkhazian"), new ISO639_2Code("ace", "ace", null, "Achinese"), new ISO639_2Code("ach", "ach", null, "Acoli"), new ISO639_2Code("ada", "ada", null, "Adangme"), new ISO639_2Code("ady", "ady", null, "Adyghe; Adygei"), new ISO639_2Code("afa", "afa", null, "Afro-Asiatic (Other)"), new ISO639_2Code("afh", "afh", null, "Afrihili"), new ISO639_2Code("afr", "afr", "af", "Afrikaans"), new ISO639_2Code("ain", "ain", null, "Ainu"), new ISO639_2Code("aka", "aka", "ak", "Akan"), new ISO639_2Code("akk", "akk", null, "Akkadian"), new ISO639_2Code("alb", "sqi", "sq", "Albanian"), new ISO639_2Code("ale", "ale", null, "Aleut"), new ISO639_2Code("alg", "alg", null, "Algonquian languages"), new ISO639_2Code("alt", "alt", null, "Southern Altai"), new ISO639_2Code("amh", "amh", "am", "Amharic"), new ISO639_2Code("ang", "ang", null, "English, Old (ca.450-1100)"), new ISO639_2Code("anp", "anp", null, "Angika"), new ISO639_2Code("apa", "apa", null, "Apache languages"), new ISO639_2Code("ara", "ara", "ar", "Arabic"), new ISO639_2Code("arc", "arc", null, "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)"), new ISO639_2Code("arg", "arg", "an", "Aragonese"), new ISO639_2Code("arm", "hye", "hy", "Armenian"), new ISO639_2Code("arn", "arn", null, "Mapudungun; Mapuche"), new ISO639_2Code("arp", "arp", null, "Arapaho"), new ISO639_2Code("art", "art", null, "Artificial (Other)"), new ISO639_2Code("arw", "arw", null, "Arawak"), new ISO639_2Code("asm", "asm", "as", "Assamese"), new ISO639_2Code("ast", "ast", null, "Asturian; Bable; Leonese; Asturleonese"), new ISO639_2Code("ath", "ath", null, "Athapascan languages"), new ISO639_2Code("aus", "aus", null, "Australian languages"), new ISO639_2Code("ava", "ava", "av", "Avaric"), new ISO639_2Code("ave", "ave", "ae", "Avestan"), new ISO639_2Code("awa", "awa", null, "Awadhi"), new ISO639_2Code("aym", "aym", "ay", "Aymara"), new ISO639_2Code("aze", "aze", "az", "Azerbaijani"), new ISO639_2Code("bad", "bad", null, "Banda languages"), new ISO639_2Code("bai", "bai", null, "Bamileke languages"), new ISO639_2Code("bak", "bak", "ba", "Bashkir"), new ISO639_2Code("bal", "bal", null, "Baluchi"), new ISO639_2Code("bam", "bam", "bm", "Bambara"), new ISO639_2Code("ban", "ban", null, "Balinese"), new ISO639_2Code("baq", "eus", "eu", "Basque"), new ISO639_2Code("bas", "bas", null, "Basa"), new ISO639_2Code("bat", "bat", null, "Baltic (Other)"), new ISO639_2Code("bej", "bej", null, "Beja; Bedawiyet"), new ISO639_2Code("bel", "bel", "be", "Belarusian"), new ISO639_2Code("bem", "bem", null, "Bemba"), new ISO639_2Code("ben", "ben", "bn", "Bengali"), new ISO639_2Code("ber", "ber", null, "Berber (Other)"), new ISO639_2Code("bho", "bho", null, "Bhojpuri"), new ISO639_2Code("bih", "bih", "bh", "Bihari"), new ISO639_2Code("bik", "bik", null, "Bikol"), new ISO639_2Code("bin", "bin", null, "Bini; Edo"), new ISO639_2Code("bis", "bis", "bi", "Bislama"), new ISO639_2Code("bla", "bla", null, "Siksika"), new ISO639_2Code("bnt", "bnt", null, "Bantu (Other)"), new ISO639_2Code("bos", "bos", "bs", "Bosnian"), new ISO639_2Code("bra", "bra", null, "Braj"), new ISO639_2Code("bre", "bre", "br", "Breton"), new ISO639_2Code("btk", "btk", null, "Batak languages"), new ISO639_2Code("bua", "bua", null, "Buriat"), new ISO639_2Code("bug", "bug", null, "Buginese"), new ISO639_2Code("bul", "bul", "bg", "Bulgarian"), new ISO639_2Code("bur", "mya", "my", "Burmese"), new ISO639_2Code("byn", "byn", null, "Blin; Bilin"), new ISO639_2Code("cad", "cad", null, "Caddo"), new ISO639_2Code("cai", "cai", null, "Central American Indian (Other)"), new ISO639_2Code("car", "car", null, "Galibi Carib"), new ISO639_2Code("cat", "cat", "ca", "Catalan; Valencian"), new ISO639_2Code("cau", "cau", null, "Caucasian (Other)"), new ISO639_2Code("ceb", "ceb", null, "Cebuano"), new ISO639_2Code("cel", "cel", null, "Celtic (Other)"), new ISO639_2Code("cha", "cha", "ch", "Chamorro"), new ISO639_2Code("chb", "chb", null, "Chibcha"), new ISO639_2Code("che", "che", "ce", "Chechen"), new ISO639_2Code("chg", "chg", null, "Chagatai"), new ISO639_2Code("chi", "zho", "zh", "Chinese"), new ISO639_2Code("chk", "chk", null, "Chuukese"), new ISO639_2Code("chm", "chm", null, "Mari"), new ISO639_2Code("chn", "chn", null, "Chinook jargon"), new ISO639_2Code("cho", "cho", null, "Choctaw"), new ISO639_2Code("chp", "chp", null, "Chipewyan; Dene Suline"), new ISO639_2Code("chr", "chr", null, "Cherokee"), new ISO639_2Code("chu", "chu", "cu", "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic"), new ISO639_2Code("chv", "chv", "cv", "Chuvash"), new ISO639_2Code("chy", "chy", null, "Cheyenne"), new ISO639_2Code("cmc", "cmc", null, "Chamic languages"), new ISO639_2Code("cop", "cop", null, "Coptic"), new ISO639_2Code("cor", "cor", "kw", "Cornish"), new ISO639_2Code("cos", "cos", "co", "Corsican"), new ISO639_2Code("cpe", "cpe", null, "Creoles and pidgins, English based (Other)"), new ISO639_2Code("cpf", "cpf", null, "Creoles and pidgins, French-based (Other)"), new ISO639_2Code("cpp", "cpp", null, "Creoles and pidgins, Portuguese-based (Other)"), new ISO639_2Code("cre", "cre", "cr", "Cree"), new ISO639_2Code("crh", "crh", null, "Crimean Tatar; Crimean Turkish"), new ISO639_2Code("crp", "crp", null, "Creoles and pidgins (Other)"), new ISO639_2Code("csb", "csb", null, "Kashubian"), new ISO639_2Code("cus", "cus", null, "Cushitic (Other)"), new ISO639_2Code("cze", "ces", "cs", "Czech"), new ISO639_2Code("dak", "dak", null, "Dakota"), new ISO639_2Code("dan", "dan", "da", "Danish"), new ISO639_2Code("dar", "dar", null, "Dargwa"), new ISO639_2Code("day", "day", null, "Land Dayak languages"), new ISO639_2Code("del", "del", null, "Delaware"), new ISO639_2Code("den", "den", null, "Slave (Athapascan)"), new ISO639_2Code("dgr", "dgr", null, "Dogrib"), new ISO639_2Code("din", "din", null, "Dinka"), new ISO639_2Code("div", "div", "dv", "Divehi; Dhivehi; Maldivian"), new ISO639_2Code("doi", "doi", null, "Dogri"), new ISO639_2Code("dra", "dra", null, "Dravidian (Other)"), new ISO639_2Code("dsb", "dsb", null, "Lower Sorbian"), new ISO639_2Code("dua", "dua", null, "Duala"), new ISO639_2Code("dum", "dum", null, "Dutch, Middle (ca.1050-1350)"), new ISO639_2Code("dut", "nld", "nl", "Dutch; Flemish"), new ISO639_2Code("dyu", "dyu", null, "Dyula"), new ISO639_2Code("dzo", "dzo", "dz", "Dzongkha"), new ISO639_2Code("efi", "efi", null, "Efik"), new ISO639_2Code("egy", "egy", null, "Egyptian (Ancient)"), new ISO639_2Code("eka", "eka", null, "Ekajuk"), new ISO639_2Code("elx", "elx", null, "Elamite"), new ISO639_2Code("eng", "eng", "en", "English"), new ISO639_2Code("enm", "enm", null, "English, Middle (1100-1500)"), new ISO639_2Code("epo", "epo", "eo", "Esperanto"), new ISO639_2Code("est", "est", "et", "Estonian"), new ISO639_2Code("ewe", "ewe", "ee", "Ewe"), new ISO639_2Code("ewo", "ewo", null, "Ewondo"), new ISO639_2Code("fan", "fan", null, "Fang"), new ISO639_2Code("fao", "fao", "fo", "Faroese"), new ISO639_2Code("fat", "fat", null, "Fanti"), new ISO639_2Code("fij", "fij", "fj", "Fijian"), new ISO639_2Code("fil", "fil", null, "Filipino; Pilipino"), new ISO639_2Code("fin", "fin", "fi", "Finnish"), new ISO639_2Code("fiu", "fiu", null, "Finno-Ugrian (Other)"), new ISO639_2Code("fon", "fon", null, "Fon"), new ISO639_2Code("fre", "fra", "fr", "French"), new ISO639_2Code("frm", "frm", null, "French, Middle (ca.1400-1600)"), new ISO639_2Code("fro", "fro", null, "French, Old (842-ca.1400)"), new ISO639_2Code("frr", "frr", null, "Northern Frisian"), new ISO639_2Code("frs", "frs", null, "Eastern Frisian"), new ISO639_2Code("fry", "fry", "fy", "Western Frisian"), new ISO639_2Code("ful", "ful", "ff", "Fulah"), new ISO639_2Code("fur", "fur", null, "Friulian"), new ISO639_2Code("gaa", "gaa", null, "Ga"), new ISO639_2Code("gay", "gay", null, "Gayo"), new ISO639_2Code("gba", "gba", null, "Gbaya"), new ISO639_2Code("gem", "gem", null, "Germanic (Other)"), new ISO639_2Code("geo", "kat", "ka", "Georgian"), new ISO639_2Code("ger", "deu", "de", "German"), new ISO639_2Code("gez", "gez", null, "Geez"), new ISO639_2Code("gil", "gil", null, "Gilbertese"), new ISO639_2Code("gla", "gla", "gd", "Gaelic; Scottish Gaelic"), new ISO639_2Code("gle", "gle", "ga", "Irish"), new ISO639_2Code("glg", "glg", "gl", "Galician"), new ISO639_2Code("glv", "glv", "gv", "Manx"), new ISO639_2Code("gmh", "gmh", null, "German, Middle High (ca.1050-1500)"), new ISO639_2Code("goh", "goh", null, "German, Old High (ca.750-1050)"), new ISO639_2Code("gon", "gon", null, "Gondi"), new ISO639_2Code("gor", "gor", null, "Gorontalo"), new ISO639_2Code("got", "got", null, "Gothic"), new ISO639_2Code("grb", "grb", null, "Grebo"), new ISO639_2Code("grc", "grc", null, "Greek, Ancient (to 1453)"), new ISO639_2Code("gre", "ell", "el", "Greek, Modern (1453-)"), new ISO639_2Code("grn", "grn", "gn", "Guarani"), new ISO639_2Code("gsw", "gsw", null, "Swiss German; Alemannic; Alsatian"), new ISO639_2Code("guj", "guj", "gu", "Gujarati"), new ISO639_2Code("gwi", "gwi", null, "Gwich'in"), new ISO639_2Code("hai", "hai", null, "Haida"), new ISO639_2Code("hat", "hat", "ht", "Haitian; Haitian Creole"), new ISO639_2Code("hau", "hau", "ha", "Hausa"), new ISO639_2Code("haw", "haw", null, "Hawaiian"), new ISO639_2Code("heb", "heb", "he", "Hebrew"), new ISO639_2Code("her", "her", "hz", "Herero"), new ISO639_2Code("hil", "hil", null, "Hiligaynon"), new ISO639_2Code("him", "him", null, "Himachali"), new ISO639_2Code("hin", "hin", "hi", "Hindi"), new ISO639_2Code("hit", "hit", null, "Hittite"), new ISO639_2Code("hmn", "hmn", null, "Hmong"), new ISO639_2Code("hmo", "hmo", "ho", "Hiri Motu"), new ISO639_2Code("hsb", "hsb", null, "Upper Sorbian"), new ISO639_2Code("hun", "hun", "hu", "Hungarian"), new ISO639_2Code("hup", "hup", null, "Hupa"), new ISO639_2Code("iba", "iba", null, "Iban"), new ISO639_2Code("ibo", "ibo", "ig", "Igbo"), new ISO639_2Code("ice", "isl", "is", "Icelandic"), new ISO639_2Code("ido", "ido", "io", "Ido"), new ISO639_2Code("iii", "iii", "ii", "Sichuan Yi; Nuosu"), new ISO639_2Code("ijo", "ijo", null, "Ijo languages"), new ISO639_2Code("iku", "iku", "iu", "Inuktitut"), new ISO639_2Code("ile", "ile", "ie", "Interlingue; Occidental"), new ISO639_2Code("ilo", "ilo", null, "Iloko"), new ISO639_2Code("ina", "ina", "ia", "Interlingua (International Auxiliary Language Association)"), new ISO639_2Code("inc", "inc", null, "Indic (Other)"), new ISO639_2Code("ind", "ind", "id", "Indonesian"), new ISO639_2Code("ine", "ine", null, "Indo-European (Other)"), new ISO639_2Code("inh", "inh", null, "Ingush"), new ISO639_2Code("ipk", "ipk", "ik", "Inupiaq"), new ISO639_2Code("ira", "ira", null, "Iranian (Other)"), new ISO639_2Code("iro", "iro", null, "Iroquoian languages"), new ISO639_2Code("ita", "ita", "it", "Italian"), new ISO639_2Code("jav", "jav", "jv", "Javanese"), new ISO639_2Code("jbo", "jbo", null, "Lojban"), new ISO639_2Code("jpn", "jpn", "ja", "Japanese"), new ISO639_2Code("jpr", "jpr", null, "Judeo-Persian"), new ISO639_2Code("jrb", "jrb", null, "Judeo-Arabic"), new ISO639_2Code("kaa", "kaa", null, "Kara-Kalpak"), new ISO639_2Code("kab", "kab", null, "Kabyle"), new ISO639_2Code("kac", "kac", null, "Kachin; Jingpho"), new ISO639_2Code("kal", "kal", "kl", "Kalaallisut; Greenlandic"), new ISO639_2Code("kam", "kam", null, "Kamba"), new ISO639_2Code("kan", "kan", "kn", "Kannada"), new ISO639_2Code("kar", "kar", null, "Karen languages"), new ISO639_2Code("kas", "kas", "ks", "Kashmiri"), new ISO639_2Code("kau", "kau", "kr", "Kanuri"), new ISO639_2Code("kaw", "kaw", null, "Kawi"), new ISO639_2Code("kaz", "kaz", "kk", "Kazakh"), new ISO639_2Code("kbd", "kbd", null, "Kabardian"), new ISO639_2Code("kha", "kha", null, "Khasi"), new ISO639_2Code("khi", "khi", null, "Khoisan (Other)"), new ISO639_2Code("khm", "khm", "km", "Central Khmer"), new ISO639_2Code("kho", "kho", null, "Khotanese"), new ISO639_2Code("kik", "kik", "ki", "Kikuyu; Gikuyu"), new ISO639_2Code("kin", "kin", "rw", "Kinyarwanda"), new ISO639_2Code("kir", "kir", "ky", "Kirghiz; Kyrgyz"), new ISO639_2Code("kmb", "kmb", null, "Kimbundu"), new ISO639_2Code("kok", "kok", null, "Konkani"), new ISO639_2Code("kom", "kom", "kv", "Komi"), new ISO639_2Code("kon", "kon", "kg", "Kongo"), new ISO639_2Code("kor", "kor", "ko", "Korean"), new ISO639_2Code("kos", "kos", null, "Kosraean"), new ISO639_2Code("kpe", "kpe", null, "Kpelle"), new ISO639_2Code("krc", "krc", null, "Karachay-Balkar"), new ISO639_2Code("krl", "krl", null, "Karelian"), new ISO639_2Code("kro", "kro", null, "Kru languages"), new ISO639_2Code("kru", "kru", null, "Kurukh"), new ISO639_2Code("kua", "kua", "kj", "Kuanyama; Kwanyama"), new ISO639_2Code("kum", "kum", null, "Kumyk"), new ISO639_2Code("kur", "kur", "ku", "Kurdish"), new ISO639_2Code("kut", "kut", null, "Kutenai"), new ISO639_2Code("lad", "lad", null, "Ladino"), new ISO639_2Code("lah", "lah", null, "Lahnda"), new ISO639_2Code("lam", "lam", null, "Lamba"), new ISO639_2Code("lao", "lao", "lo", "Lao"), new ISO639_2Code("lat", "lat", "la", "Latin"), new ISO639_2Code("lav", "lav", "lv", "Latvian"), new ISO639_2Code("lez", "lez", null, "Lezghian"), new ISO639_2Code("lim", "lim", "li", "Limburgan; Limburger; Limburgish"), new ISO639_2Code("lin", "lin", "ln", "Lingala"), new ISO639_2Code("lit", "lit", "lt", "Lithuanian"), new ISO639_2Code("lol", "lol", null, "Mongo"), new ISO639_2Code("loz", "loz", null, "Lozi"), new ISO639_2Code("ltz", "ltz", "lb", "Luxembourgish; Letzeburgesch"), new ISO639_2Code("lua", "lua", null, "Luba-Lulua"), new ISO639_2Code("lub", "lub", "lu", "Luba-Katanga"), new ISO639_2Code("lug", "lug", "lg", "Ganda"), new ISO639_2Code("lui", "lui", null, "Luiseno"), new ISO639_2Code("lun", "lun", null, "Lunda"), new ISO639_2Code("luo", "luo", null, "Luo (Kenya and Tanzania)"), new ISO639_2Code("lus", "lus", null, "Lushai"), new ISO639_2Code("mac", "mkd", "mk", "Macedonian"), new ISO639_2Code("mad", "mad", null, "Madurese"), new ISO639_2Code("mag", "mag", null, "Magahi"), new ISO639_2Code("mah", "mah", "mh", "Marshallese"), new ISO639_2Code("mai", "mai", null, "Maithili"), new ISO639_2Code("mak", "mak", null, "Makasar"), new ISO639_2Code("mal", "mal", "ml", "Malayalam"), new ISO639_2Code("man", "man", null, "Mandingo"), new ISO639_2Code("mao", "mri", "mi", "Maori"), new ISO639_2Code("map", "map", null, "Austronesian (Other)"), new ISO639_2Code("mar", "mar", "mr", "Marathi"), new ISO639_2Code("mas", "mas", null, "Masai"), new ISO639_2Code("may", "msa", "ms", "Malay"), new ISO639_2Code("mdf", "mdf", null, "Moksha"), new ISO639_2Code("mdr", "mdr", null, "Mandar"), new ISO639_2Code("men", "men", null, "Mende"), new ISO639_2Code("mga", "mga", null, "Irish, Middle (900-1200)"), new ISO639_2Code("mic", "mic", null, "Mi'kmaq; Micmac"), new ISO639_2Code("min", "min", null, "Minangkabau"), new ISO639_2Code("mis", "mis", null, "Uncoded languages"), new ISO639_2Code("mkh", "mkh", null, "Mon-Khmer (Other)"), new ISO639_2Code("mlg", "mlg", "mg", "Malagasy"), new ISO639_2Code("mlt", "mlt", "mt", "Maltese"), new ISO639_2Code("mnc", "mnc", null, "Manchu"), new ISO639_2Code("mni", "mni", null, "Manipuri"), new ISO639_2Code("mno", "mno", null, "Manobo languages"), new ISO639_2Code("moh", "moh", null, "Mohawk"), new ISO639_2Code("mol", "mol", "mo", "Moldavian"), new ISO639_2Code("mon", "mon", "mn", "Mongolian"), new ISO639_2Code("mos", "mos", null, "Mossi"), new ISO639_2Code("mul", "mul", null, "Multiple languages"), new ISO639_2Code("mun", "mun", null, "Munda languages"), new ISO639_2Code("mus", "mus", null, "Creek"), new ISO639_2Code("mwl", "mwl", null, "Mirandese"), new ISO639_2Code("mwr", "mwr", null, "Marwari"), new ISO639_2Code("myn", "myn", null, "Mayan languages"), new ISO639_2Code("myv", "myv", null, "Erzya"), new ISO639_2Code("nah", "nah", null, "Nahuatl languages"), new ISO639_2Code("nai", "nai", null, "North American Indian"), new ISO639_2Code("nap", "nap", null, "Neapolitan"), new ISO639_2Code("nau", "nau", "na", "Nauru"), new ISO639_2Code("nav", "nav", "nv", "Navajo; Navaho"), new ISO639_2Code("nbl", "nbl", "nr", "Ndebele, South; South Ndebele"), new ISO639_2Code("nde", "nde", "nd", "Ndebele, North; North Ndebele"), new ISO639_2Code("ndo", "ndo", "ng", "Ndonga"), new ISO639_2Code("nds", "nds", null, "Low German; Low Saxon; German, Low; Saxon, Low"), new ISO639_2Code("nep", "nep", "ne", "Nepali"), new ISO639_2Code("new", "new", null, "Nepal Bhasa; Newari"), new ISO639_2Code("nia", "nia", null, "Nias"), new ISO639_2Code("nic", "nic", null, "Niger-Kordofanian (Other)"), new ISO639_2Code("niu", "niu", null, "Niuean"), new ISO639_2Code("nno", "nno", "nn", "Norwegian Nynorsk; Nynorsk, Norwegian"), new ISO639_2Code("nob", "nob", "nb", "Bokm\u00e5l, Norwegian; Norwegian Bokm\u00e5l"), new ISO639_2Code("nog", "nog", null, "Nogai"), new ISO639_2Code("non", "non", null, "Norse, Old"), new ISO639_2Code("nor", "nor", "no", "Norwegian"), new ISO639_2Code("nqo", "nqo", null, "N'Ko"), new ISO639_2Code("nso", "nso", null, "Pedi; Sepedi; Northern Sotho"), new ISO639_2Code("nub", "nub", null, "Nubian languages"), new ISO639_2Code("nwc", "nwc", null, "Classical Newari; Old Newari; Classical Nepal Bhasa"), new ISO639_2Code("nya", "nya", "ny", "Chichewa; Chewa; Nyanja"), new ISO639_2Code("nym", "nym", null, "Nyamwezi"), new ISO639_2Code("nyn", "nyn", null, "Nyankole"), new ISO639_2Code("nyo", "nyo", null, "Nyoro"), new ISO639_2Code("nzi", "nzi", null, "Nzima"), new ISO639_2Code("oci", "oci", "oc", "Occitan (post 1500); Proven\u00e7al"), new ISO639_2Code("oji", "oji", "oj", "Ojibwa"), new ISO639_2Code("ori", "ori", "or", "Oriya"), new ISO639_2Code("orm", "orm", "om", "Oromo"), new ISO639_2Code("osa", "osa", null, "Osage"), new ISO639_2Code("oss", "oss", "os", "Ossetian; Ossetic"), new ISO639_2Code("ota", "ota", null, "Turkish, Ottoman (1500-1928)"), new ISO639_2Code("oto", "oto", null, "Otomian languages"), new ISO639_2Code("paa", "paa", null, "Papuan (Other)"), new ISO639_2Code("pag", "pag", null, "Pangasinan"), new ISO639_2Code("pal", "pal", null, "Pahlavi"), new ISO639_2Code("pam", "pam", null, "Pampanga; Kapampangan"), new ISO639_2Code("pan", "pan", "pa", "Panjabi; Punjabi"), new ISO639_2Code("pap", "pap", null, "Papiamento"), new ISO639_2Code("pau", "pau", null, "Palauan"), new ISO639_2Code("peo", "peo", null, "Persian, Old (ca.600-400 B.C.)"), new ISO639_2Code("per", "fas", "fa", "Persian"), new ISO639_2Code("phi", "phi", null, "Philippine (Other)"), new ISO639_2Code("phn", "phn", null, "Phoenician"), new ISO639_2Code("pli", "pli", "pi", "Pali"), new ISO639_2Code("pol", "pol", "pl", "Polish"), new ISO639_2Code("pon", "pon", null, "Pohnpeian"), new ISO639_2Code("por", "por", "pt", "Portuguese"), new ISO639_2Code("pra", "pra", null, "Prakrit languages"), new ISO639_2Code("pro", "pro", null, "Proven\u00e7al, Old (to 1500)"), new ISO639_2Code("pus", "pus", "ps", "Pushto; Pashto"), new ISO639_2Code("que", "que", "qu", "Quechua"), new ISO639_2Code("raj", "raj", null, "Rajasthani"), new ISO639_2Code("rap", "rap", null, "Rapanui"), new ISO639_2Code("rar", "rar", null, "Rarotongan; Cook Islands Maori"), new ISO639_2Code("roa", "roa", null, "Romance (Other)"), new ISO639_2Code("roh", "roh", "rm", "Romansh"), new ISO639_2Code("rom", "rom", null, "Romany"), new ISO639_2Code("rum", "ron", "ro", "Romanian"), new ISO639_2Code("run", "run", "rn", "Rundi"), new ISO639_2Code("rup", "rup", null, "Aromanian; Arumanian; Macedo-Romanian"), new ISO639_2Code("rus", "rus", "ru", "Russian"), new ISO639_2Code("sad", "sad", null, "Sandawe"), new ISO639_2Code("sag", "sag", "sg", "Sango"), new ISO639_2Code("sah", "sah", null, "Yakut"), new ISO639_2Code("sai", "sai", null, "South American Indian (Other)"), new ISO639_2Code("sal", "sal", null, "Salishan languages"), new ISO639_2Code("sam", "sam", null, "Samaritan Aramaic"), new ISO639_2Code("san", "san", "sa", "Sanskrit"), new ISO639_2Code("sas", "sas", null, "Sasak"), new ISO639_2Code("sat", "sat", null, "Santali"), new ISO639_2Code("srp", "srp", "sr", "Serbian"), new ISO639_2Code("scn", "scn", null, "Sicilian"), new ISO639_2Code("sco", "sco", null, "Scots"), new ISO639_2Code("hrv", "hrv", "hr", "Croatian"), new ISO639_2Code("sel", "sel", null, "Selkup"), new ISO639_2Code("sem", "sem", null, "Semitic (Other)"), new ISO639_2Code("sga", "sga", null, "Irish, Old (to 900)"), new ISO639_2Code("sgn", "sgn", null, "Sign Languages"), new ISO639_2Code("shn", "shn", null, "Shan"), new ISO639_2Code("sid", "sid", null, "Sidamo"), new ISO639_2Code("sin", "sin", "si", "Sinhala; Sinhalese"), new ISO639_2Code("sio", "sio", null, "Siouan languages"), new ISO639_2Code("sit", "sit", null, "Sino-Tibetan (Other)"), new ISO639_2Code("sla", "sla", null, "Slavic (Other)"), new ISO639_2Code("slo", "slk", "sk", "Slovak"), new ISO639_2Code("slv", "slv", "sl", "Slovenian"), new ISO639_2Code("sma", "sma", null, "Southern Sami"), new ISO639_2Code("sme", "sme", "se", "Northern Sami"), new ISO639_2Code("smi", "smi", null, "Sami languages (Other)"), new ISO639_2Code("smj", "smj", null, "Lule Sami"), new ISO639_2Code("smn", "smn", null, "Inari Sami"), new ISO639_2Code("smo", "smo", "sm", "Samoan"), new ISO639_2Code("sms", "sms", null, "Skolt Sami"), new ISO639_2Code("sna", "sna", "sn", "Shona"), new ISO639_2Code("snd", "snd", "sd", "Sindhi"), new ISO639_2Code("snk", "snk", null, "Soninke"), new ISO639_2Code("sog", "sog", null, "Sogdian"), new ISO639_2Code("som", "som", "so", "Somali"), new ISO639_2Code("son", "son", null, "Songhai languages"), new ISO639_2Code("sot", "sot", "st", "Sotho, Southern"), new ISO639_2Code("spa", "spa", "es", "Spanish; Castilian"), new ISO639_2Code("srd", "srd", "sc", "Sardinian"), new ISO639_2Code("srn", "srn", null, "Sranan Tongo"), new ISO639_2Code("srr", "srr", null, "Serer"), new ISO639_2Code("ssa", "ssa", null, "Nilo-Saharan (Other)"), new ISO639_2Code("ssw", "ssw", "ss", "Swati"), new ISO639_2Code("suk", "suk", null, "Sukuma"), new ISO639_2Code("sun", "sun", "su", "Sundanese"), new ISO639_2Code("sus", "sus", null, "Susu"), new ISO639_2Code("sux", "sux", null, "Sumerian"), new ISO639_2Code("swa", "swa", "sw", "Swahili"), new ISO639_2Code("swe", "swe", "sv", "Swedish"), new ISO639_2Code("syc", "syc", null, "Classical Syriac"), new ISO639_2Code("syr", "syr", null, "Syriac"), new ISO639_2Code("tah", "tah", "ty", "Tahitian"), new ISO639_2Code("tai", "tai", null, "Tai (Other)"), new ISO639_2Code("tam", "tam", "ta", "Tamil"), new ISO639_2Code("tat", "tat", "tt", "Tatar"), new ISO639_2Code("tel", "tel", "te", "Telugu"), new ISO639_2Code("tem", "tem", null, "Timne"), new ISO639_2Code("ter", "ter", null, "Tereno"), new ISO639_2Code("tet", "tet", null, "Tetum"), new ISO639_2Code("tgk", "tgk", "tg", "Tajik"), new ISO639_2Code("tgl", "tgl", "tl", "Tagalog"), new ISO639_2Code("tha", "tha", "th", "Thai"), new ISO639_2Code("tib", "bod", "bo", "Tibetan"), new ISO639_2Code("tig", "tig", null, "Tigre"), new ISO639_2Code("tir", "tir", "ti", "Tigrinya"), new ISO639_2Code("tiv", "tiv", null, "Tiv"), new ISO639_2Code("tkl", "tkl", null, "Tokelau"), new ISO639_2Code("tlh", "tlh", null, "Klingon; tlhIngan-Hol"), new ISO639_2Code("tli", "tli", null, "Tlingit"), new ISO639_2Code("tmh", "tmh", null, "Tamashek"), new ISO639_2Code("tog", "tog", null, "Tonga (Nyasa)"), new ISO639_2Code("ton", "ton", "to", "Tonga (Tonga Islands)"), new ISO639_2Code("tpi", "tpi", null, "Tok Pisin"), new ISO639_2Code("tsi", "tsi", null, "Tsimshian"), new ISO639_2Code("tsn", "tsn", "tn", "Tswana"), new ISO639_2Code("tso", "tso", "ts", "Tsonga"), new ISO639_2Code("tuk", "tuk", "tk", "Turkmen"), new ISO639_2Code("tum", "tum", null, "Tumbuka"), new ISO639_2Code("tup", "tup", null, "Tupi languages"), new ISO639_2Code("tur", "tur", "tr", "Turkish"), new ISO639_2Code("tut", "tut", null, "Altaic (Other)"), new ISO639_2Code("tvl", "tvl", null, "Tuvalu"), new ISO639_2Code("twi", "twi", "tw", "Twi"), new ISO639_2Code("tyv", "tyv", null, "Tuvinian"), new ISO639_2Code("udm", "udm", null, "Udmurt"), new ISO639_2Code("uga", "uga", null, "Ugaritic"), new ISO639_2Code("uig", "uig", "ug", "Uighur; Uyghur"), new ISO639_2Code("ukr", "ukr", "uk", "Ukrainian"), new ISO639_2Code("umb", "umb", null, "Umbundu"), new ISO639_2Code("und", "und", null, "Undetermined"), new ISO639_2Code("urd", "urd", "ur", "Urdu"), new ISO639_2Code("uzb", "uzb", "uz", "Uzbek"), new ISO639_2Code("vai", "vai", null, "Vai"), new ISO639_2Code("ven", "ven", "ve", "Venda"), new ISO639_2Code("vie", "vie", "vi", "Vietnamese"), new ISO639_2Code("vol", "vol", "vo", "Volap\u00fck"), new ISO639_2Code("vot", "vot", null, "Votic"), new ISO639_2Code("wak", "wak", null, "Wakashan languages"), new ISO639_2Code("wal", "wal", null, "Walamo"), new ISO639_2Code("war", "war", null, "Waray"), new ISO639_2Code("was", "was", null, "Washo"), new ISO639_2Code("wel", "cym", "cy", "Welsh"), new ISO639_2Code("wen", "wen", null, "Sorbian languages"), new ISO639_2Code("wln", "wln", "wa", "Walloon"), new ISO639_2Code("wol", "wol", "wo", "Wolof"), new ISO639_2Code("xal", "xal", null, "Kalmyk; Oirat"), new ISO639_2Code("xho", "xho", "xh", "Xhosa"), new ISO639_2Code("yao", "yao", null, "Yao"), new ISO639_2Code("yap", "yap", null, "Yapese"), new ISO639_2Code("yid", "yid", "yi", "Yiddish"), new ISO639_2Code("yor", "yor", "yo", "Yoruba"), new ISO639_2Code("ypk", "ypk", null, "Yupik languages"), new ISO639_2Code("zap", "zap", null, "Zapotec"), new ISO639_2Code("zbl", "zbl", null, "Blissymbols; Blissymbolics; Bliss"), new ISO639_2Code("zen", "zen", null, "Zenaga"), new ISO639_2Code("zha", "zha", "za", "Zhuang; Chuang"), new ISO639_2Code("znd", "znd", null, "Zande languages"), new ISO639_2Code("zul", "zul", "zu", "Zulu"), new ISO639_2Code("zun", "zun", null, "Zuni"), new ISO639_2Code("zxx", "zxx", null, "No linguistic content"), new ISO639_2Code("zza", "zza", null, "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki")};
    private String threeCharT;
    private String threeCharB;
    private String twoChar;
    private String description;
    private static final Map<String, String> THREE_CHAR_T_TO_VALID = ISO639_2Code.createISO6392TToValidMap();
    private static final Map<String, String> THREE_CHAR_B_TO_VALID = ISO639_2Code.createISO6392BToValidMap();
    private static final Map<String, ISO639_2Code> BCP47_TO_ISO6392 = ISO639_2Code.createBCP47ToISO6392Map();

    public String getT() {
        return this.threeCharT;
    }

    public String getB() {
        return this.threeCharB;
    }

    public String getTwoChar() {
        return this.twoChar;
    }

    public String getDescription() {
        return this.description;
    }

    private ISO639_2Code(String b, String t, String twoChar, String description) {
        this.threeCharB = b;
        this.threeCharT = t;
        this.twoChar = twoChar;
        this.description = description;
    }

    private static Map<String, String> createISO6392TToValidMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (ISO639_2Code i : ISO6392Codes) {
            String mapping = i.getTwoChar() != null ? i.getTwoChar() : i.getT();
            m.put(i.getT(), mapping);
        }
        return m;
    }

    private static Map<String, ISO639_2Code> createBCP47ToISO6392Map() {
        HashMap<String, ISO639_2Code> m = new HashMap<String, ISO639_2Code>();
        for (ISO639_2Code code : ISO6392Codes) {
            String key = code.getTwoChar();
            if (key == null) continue;
            m.put(key, code);
        }
        return m;
    }

    private static Map<String, String> createISO6392BToValidMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (ISO639_2Code i : ISO6392Codes) {
            String mapping = i.getTwoChar() != null ? i.getTwoChar() : i.getT();
            m.put(i.getB(), mapping);
        }
        return m;
    }

    public static BCP47Tag getBCP47TagForISO639Tag(String iso) throws BCP47TagParseException {
        if (StringUtils.isEmpty((CharSequence)iso)) {
            throw new BCP47TagParseException("No BCP47 mapping for null or empty string");
        }
        String normalized = iso.toLowerCase();
        String bcp47 = THREE_CHAR_T_TO_VALID.get(normalized);
        if (bcp47 != null) {
            return BCP47TagSupport.createBCP47Tag(bcp47);
        }
        bcp47 = THREE_CHAR_B_TO_VALID.get(normalized);
        if (bcp47 != null) {
            return BCP47TagSupport.createBCP47Tag(bcp47);
        }
        throw new BCP47TagParseException("No BCP47 mapping for [" + iso + "]");
    }

    public static ISO639_2Code getISO6392CodeForBCP47PrimaryLanguageSubtag(LanguageTag tag) throws BCP47TagParseException {
        if (tag != null && tag instanceof BCP47Tag) {
            return ISO639_2Code.getISO6392CodeForBCP47PrimaryLanguageSubtag((BCP47Tag)tag);
        }
        return null;
    }

    public static ISO639_2Code getISO6392CodeForBCP47PrimaryLanguageSubtag(BCP47Tag tag) throws BCP47TagParseException {
        PrimaryLanguageCode primaryLanguageCode = tag.getPrimaryLanguageCode();
        return ISO639_2Code.getISO6392CodeForBCP47PrimaryLanguageSubtag(primaryLanguageCode.getValue());
    }

    public static ISO639_2Code getISO6392CodeForBCP47PrimaryLanguageSubtag(String bcpTag) throws BCP47TagParseException {
        ISO639_2Code isoCode = BCP47_TO_ISO6392.get(bcpTag);
        if (isoCode != null) {
            return isoCode;
        }
        throw new BCP47TagParseException("No ISO6392 mapping for [" + bcpTag + "]");
    }

    public static boolean containsTCode(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String normalized = value.toLowerCase();
        for (ISO639_2Code code : ISO6392Codes) {
            if (!code.getT().equals(normalized)) continue;
            return true;
        }
        return false;
    }
}

