/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale;

import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagParser;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.util.Pair;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class BCP47TagSupport {
    private static final boolean TOLERATE_UNDERSCORES_IN_TAGS = true;
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";
    public static final LanguageTag ENGLISH_US;
    public static final LocaleCode ENGLISH;
    private static final Logger logger;
    private static final BCP47TagParser tagParser;
    private static final boolean CACHE_ENABLED = true;
    private static final Map<Pair<String, Boolean>, LanguageTag> cache;

    public static LanguageTag createTag(String tag) throws BCP47TagParseException {
        return BCP47TagSupport.createTag(tag, true);
    }

    public static BCP47Tag createBCP47Tag(String tag) throws BCP47TagParseException {
        LanguageTag languageTag = BCP47TagSupport.createTag(tag);
        if (languageTag instanceof BCP47Tag) {
            return (BCP47Tag)languageTag;
        }
        throw new BCP47TagParseException("[" + tag + "] is not a conforming BCP47 tag");
    }

    public static BCP47Tag createBCP47Tag(Locale locale) throws BCP47TagParseException {
        return locale == null ? null : BCP47TagSupport.createBCP47Tag(locale.toString());
    }

    public static LanguageTag createTag(String tag, boolean validate) throws BCP47TagParseException {
        tag = tag.replaceAll(UNDERSCORE, HYPHEN);
        LanguageTag languageTag = null;
        languageTag = BCP47TagSupport.getFromCache(tag, validate);
        if (languageTag != null) {
            return languageTag;
        }
        languageTag = tagParser.parse(tag, validate);
        BCP47TagSupport.putInCache(tag, validate, languageTag);
        return languageTag;
    }

    private static synchronized void putInCache(String tag, boolean validate, LanguageTag languageTag) {
        Pair<String, Boolean> cacheKey;
        if (languageTag != null && !cache.containsKey(cacheKey = new Pair<String, Boolean>(tag, validate))) {
            cache.put(cacheKey, languageTag);
        }
    }

    private static LanguageTag getFromCache(String tag, boolean validate) {
        Pair<String, Boolean> cacheKey = new Pair<String, Boolean>(tag, validate);
        return cache.get(cacheKey);
    }

    static {
        logger = Logger.getLogger(BCP47TagSupport.class);
        try {
            Properties tagSupport = new Properties();
            tagSupport.load(BCP47TagSupport.class.getResourceAsStream("bcp47-tag-support.properties"));
            String parserImplementationClassname = tagSupport.getProperty("parser.implementation");
            tagParser = (BCP47TagParser)Class.forName(parserImplementationClassname).newInstance();
            cache = Collections.synchronizedMap(new LRUMap());
            ENGLISH_US = BCP47TagSupport.createTag("en-US");
            ENGLISH = BCP47TagSupport.createBCP47Tag("en");
        }
        catch (Exception e) {
            logger.fatal((Object)"Exception during BCP47 Tag Support initialization", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

