/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.BuilderErrorHandler;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtilities {
    private static final Logger logger = Logger.getLogger(XMLUtilities.class);
    public static String[][] AsciiReplacements = new String[][]{{"[\\u0000]", "{{{ Ctrl+@ character / ASCII 00 / Null character\" }}}"}, {"[\\u0001]", "{{{ Ctrl+A character / ASCII 01 / \"Start of Header\" }}}"}, {"[\\u0002]", "{{{ Ctrl+B character / ASCII 02 / \"Start of Text\" }}}"}, {"[\\u0003]", "{{{ Ctrl+C character / ASCII 03 / \"End of Text\" }}}"}, {"[\\u0004]", "{{{ Ctrl+D character / ASCII 04 / \"End of Transmission\" }}}"}, {"[\\u0005]", "{{{ Ctrl+E character / ASCII 05 / \"Enquiry\" }}}"}, {"[\\u0006]", "{{{ Ctrl+F character / ASCII 06 / \"Acknowledgment\" }}}"}, {"[\\u0007]", "{{{ Ctrl+G character / ASCII 07 / \"Bell\" }}}"}, {"[\\u0008]", "{{{ Ctrl+H character / ASCII 08 / \"Backspace\" }}}"}, {"[\\u0009]", null}, {"[\\u000A]", null}, {"[\\u000B]", "{{{ Ctrl+K character / ASCII 11 / \"Vertical Tab\" }}}"}, {"[\\u000C]", "{{{ Ctrl+L character / ASCII 12 / \"Form feed\" }}}"}, {"[\\u000D]", null}, {"[\\u000E]", "{{{ Ctrl+N character / ASCII 14 / \"Shift Out\" }}}"}, {"[\\u000F]", "{{{ Ctrl+O character / ASCII 15 / \"Shift In\" }}}"}, {"[\\u0010]", "{{{ Ctrl+P character / ASCII 16 / \"Data Link Escape\" }}}"}, {"[\\u0011]", "{{{ Ctrl+Q character / ASCII 17 / \"Device Control 1 (oft. XON)\" }}}"}, {"[\\u0012]", "{{{ Ctrl+R character / ASCII 18 / \"Device Control 2\" }}}"}, {"[\\u0013]", "{{{ Ctrl+S character / ASCII 19 / \"Device Control 3 (oft. XOFF)\" }}}"}, {"[\\u0014]", "{{{ Ctrl+T character / ASCII 20 / \"Device Control 4\" }}}"}, {"[\\u0015]", "{{{ Ctrl+U character / ASCII 21 / \"Negative Acknowledgement\" }}}"}, {"[\\u0016]", "{{{ Ctrl+V character / ASCII 22 / \"Synchronous idle\" }}}"}, {"[\\u0017]", "{{{ Ctrl+W character / ASCII 23 / \"End of Transmission Block\" }}}"}, {"[\\u0018]", "{{{ Ctrl+X character / ASCII 24 / \"Cancel\" }}}"}, {"[\\u0019]", "{{{ Ctrl+Y character / ASCII 25 / \"End of Medium\" }}}"}, {"[\\u001A]", "{{{ Ctrl+Z character / ASCII 26 / \"Substitute\" }}}"}, {"[\\u001B]", "{{{ Ctrl+[ character / ASCII 27 / \"Escape\" }}}"}, {"[\\u001C]", "{{{ Ctrl+\\ character / ASCII 28 / \"File Separator\" }}}"}, {"[\\u001D]", "{{{ Ctrl+] character / ASCII 29 / \"Group Separator\" }}}"}, {"[\\u001E]", "{{{ Ctrl+^ character / ASCII 30 / \"Record Separator\" }}}"}, {"[\\u001F]", "{{{ Ctrl+_ character / ASCII 31 / \"Unit Separator\" }}}"}};
    private static final Pattern illegalXmlCharactersPattern = Pattern.compile("[^\\x09\\x0A\\x0D][\\x00-\\x1F\\xD800-\\xDFFF\\xFFFE-\\xFFFF]");
    private static Map<Character, String> XPATH_ESCAPE_CHARSET = new HashMap<Character, String>();

    public static Document createDocument(File file) throws JDOMException, IOException {
        SAXBuilder builder = XMLUtilities.getSafeSAXBuilder();
        if (XMLUtilities.isXMLFile(file)) {
            builder.setErrorHandler((ErrorHandler)new XMLUtilitiesErrorHandler(file));
        }
        Document document = builder.build(file);
        return document;
    }

    public static Document createDocument(File file, String schema) throws JDOMException, IOException {
        SAXBuilder builder = XMLUtilities.getSafeSAXBuilder();
        builder.setValidation(false);
        if (XMLUtilities.isXMLFile(file)) {
            builder.setErrorHandler((ErrorHandler)new XMLUtilitiesErrorHandler(file));
        }
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)schema);
        Document document = builder.build(file);
        return document;
    }

    public static SAXBuilder getSafeSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXMLFile(File file) {
        if (file.exists() && file.length() > 12L) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                char[] readChars = new char[5];
                fileReader.read(readChars);
                String readString = new String(readChars);
                boolean bl = "<?xml".equals(readString);
                return bl;
            }
            catch (Exception e) {
                logger.error((Object)("Exception in reading file: " + file.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot close file: " + file.getAbsolutePath()), (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    private static boolean _isLegalXmlCodePoint(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    private static String getEscapedCharReplacementString(String chars) {
        int val;
        try {
            val = chars.startsWith("x") ? Integer.parseInt(chars.substring(1), 16) : Integer.parseInt(chars);
        }
        catch (Exception p) {
            return "&#" + chars + ";";
        }
        if (val < 0 || val >= AsciiReplacements.length || XMLUtilities._isLegalXmlCodePoint(val)) {
            return "&#" + chars + ";";
        }
        return AsciiReplacements[val][1];
    }

    public static String escapeInvalidXmlEntityReferences(String xml) {
        if (xml == null) {
            return null;
        }
        xml = XMLUtilities.replaceNonprintableCharactersWithTextDescription(xml);
        StringBuilder result = new StringBuilder(xml.length());
        int ampIdx = xml.indexOf("&#");
        while (ampIdx >= 0) {
            result.append(xml.substring(0, ampIdx));
            xml = xml.substring(ampIdx + 2);
            int semicolonIdx = xml.indexOf(";");
            if (semicolonIdx < 0) {
                result.append("&amp;#");
                break;
            }
            String escapedChars = xml.substring(0, semicolonIdx);
            result.append(XMLUtilities.getEscapedCharReplacementString(escapedChars));
            xml = xml.substring(semicolonIdx + 1);
            ampIdx = xml.indexOf("&#");
        }
        result.append(xml);
        return result.toString();
    }

    public static String replaceNonprintableCharactersWithTextDescription(String s) {
        Matcher m = illegalXmlCharactersPattern.matcher(s);
        if (m.find()) {
            for (int i = 0; i < AsciiReplacements.length; ++i) {
                String s0 = AsciiReplacements[i][0];
                String s1 = AsciiReplacements[i][1];
                if (s1 == null) continue;
                s = s.replaceAll(s0, s1);
            }
        }
        return s;
    }

    public static List<Element> getElementChildren(Element element) {
        ArrayList<Element> childrenElements = new ArrayList<Element>();
        List children = element.getChildren();
        for (Object child : children) {
            if (!(child instanceof Element)) continue;
            childrenElements.add((Element)child);
        }
        return childrenElements;
    }

    public static Element getNextSiblingElementWithName(Element element, String siblingName) {
        Element parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        Element sibling = parent.getChild(siblingName);
        return sibling;
    }

    public static String documentToString(Document document) {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getCompactFormat());
        return outputter.outputString(document);
    }

    public static String xpathEscape(String value) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            Character character = Character.valueOf(value.charAt(i));
            String replacement = XPATH_ESCAPE_CHARSET.get(character);
            if (replacement == null) {
                out.append(character);
                continue;
            }
            out.append(replacement);
        }
        return out.toString();
    }

    public static void main(String[] args) {
        String test = "ABC &#x1A; DEF &x GHI &#x10; JKL &#x40; MNO &# PQR &#xFF;";
        System.out.println(XMLUtilities.escapeInvalidXmlEntityReferences(test));
        byte[] byteArr = new byte[]{84, 111, 107, 101, 110, 32, 39, 26, 39, 32, 84, 111, 107, 101, 110, 32, 84, 111, 107, 101, 110, 32, 39, 9, 39, 32};
        System.out.println("\nbyteArr\n" + XMLUtilities.replaceNonprintableCharactersWithTextDescription(new String(byteArr)));
        byte[] byteArr2 = new byte[]{39, 9, 39, 32, 39, 10, 39, 32, 39, 13, 39, 32, 39, 26, 39, 32, 39, 28, 39, 32, 39, 127, 39};
        System.out.println("\nbyteArr2\n" + XMLUtilities.replaceNonprintableCharactersWithTextDescription(new String(byteArr2)));
        int[] intArr = new int[]{39, 9, 39, 32, 39, 10, 39, 32, 39, 13, 39, 32, 39, 26, 39, 32, 39, 28, 39, 32, 39, 127, 39, 32, 39, 128, 39, 32, 39, 1000, 39, 32, 39, 61166, 39};
        System.out.println("\nintArr\n" + XMLUtilities.replaceNonprintableCharactersWithTextDescription(new String(intArr, 0, 35)));
    }

    static {
        XPATH_ESCAPE_CHARSET.put(Character.valueOf('\''), "&apos;");
        XPATH_ESCAPE_CHARSET.put(Character.valueOf('&'), "&amp;");
    }

    public static class XMLUtilitiesErrorHandler
    extends BuilderErrorHandler
    implements ErrorHandler {
        private File xmlFile;

        public XMLUtilitiesErrorHandler(File xmlFile) {
            this.xmlFile = xmlFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getBadCharacterErrorMessage(File xmlFile, int lineNumber, int columnNumber) {
            if (lineNumber > 0 && columnNumber >= 0) {
                BufferedReader reader = null;
                try {
                    String line = null;
                    reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), Charset.forName("UTF-8")));
                    for (int i = lineNumber; i > 0; --i) {
                        line = ((LineNumberReader)reader).readLine();
                    }
                    int lastCodePoint = -1;
                    int lastCodePointIndex = -1;
                    boolean badCharacterFound = false;
                    int codePointCount = line.codePointCount(0, line.length());
                    int i = 0;
                    while (i < codePointCount) {
                        int codePoint = line.codePointAt(i);
                        if (i == columnNumber + 1) {
                            lastCodePoint = codePoint;
                            lastCodePointIndex = i;
                            badCharacterFound = true;
                            break;
                        }
                        if (i > columnNumber + 1) {
                            badCharacterFound = true;
                            break;
                        }
                        lastCodePoint = codePoint;
                        lastCodePointIndex = i;
                        i = line.offsetByCodePoints(i, 1);
                    }
                    if (badCharacterFound) {
                        String errorMessage;
                        String prefix = line.substring(Math.max(0, lastCodePointIndex - 24), lastCodePointIndex);
                        String string = errorMessage = "Bad_Character_Found_in_XML_File:" + xmlFile.getName() + ", Line:" + lineNumber + ", CodePoint Index:" + lastCodePointIndex + ", SAXParseException Column:" + columnNumber + "  CodePoint Hex:U+" + Integer.toHexString(lastCodePoint).toUpperCase() + ", Prefix:" + prefix;
                        return string;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Exception_Getting_Bad_Character_in_File:" + xmlFile.getAbsolutePath()), (Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)("Exception_Closing_File:" + xmlFile.getAbsolutePath()), (Throwable)e);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            String errorMessage = XMLUtilitiesErrorHandler.getBadCharacterErrorMessage(this.xmlFile, exception.getLineNumber(), exception.getColumnNumber());
            if (errorMessage != null) {
                logger.error((Object)errorMessage);
            }
            super.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            String errorMessage = XMLUtilitiesErrorHandler.getBadCharacterErrorMessage(this.xmlFile, exception.getLineNumber(), exception.getColumnNumber());
            if (errorMessage != null) {
                logger.error((Object)errorMessage);
            }
            super.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            super.warning(exception);
        }
    }
}

