/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.util;

import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoExtractor;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import org.apache.log4j.Logger;

public class FileWithEpubData
extends File {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(FileWithEpubData.class);
    private EPUBModel model;
    private EPUBInfo info;
    private File tempDir = null;

    public FileWithEpubData(String parent, String name) throws InitializationException {
        super(parent, name);
        EPUBInfoExtractor extractor = new EPUBInfoExtractor(this);
        try {
            this.tempDir = FileUtilities.createTempDirectory(this.getName() + ".", "unpacked");
            this.model = extractor.getModel(this.tempDir);
            this.info = extractor.extract(this.model);
        }
        catch (Exception e) {
            log.error((Object)"Failure initializing FileWithEpubData: ", (Throwable)e);
            throw new InitializationException("Initialization failure", e);
        }
    }

    public FileWithEpubData(File file) throws InitializationException {
        this(file.getParent(), file.getName());
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    public void cleanup() {
        if (this.tempDir != null) {
            FileUtilities.deleteRecursively(this.tempDir);
        }
    }

    @Override
    public boolean delete() {
        this.cleanup();
        return super.delete();
    }

    public EPUBModel getModel() {
        return this.model;
    }

    public EPUBInfo getInfo() {
        return this.info;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public static class InitializationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InitializationException(String string, Exception e) {
            super(string, e);
        }
    }
}

