/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class FileUtilities {
    private static Pattern containsDoubleEscapedCharacterRexexPattern = Pattern.compile("(%25\\d\\d)");

    public static File createTempDirectory(String prefix, String extension) throws IOException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(prefix, ".dir");
            File tempDir = new File(tempFile.getAbsolutePath() + "." + extension);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new IOException("Problem creating " + tempDir.getAbsolutePath() + ".  If you are using an ext3 filesystem, there may be too many files or directories in your temp folder");
            }
            File file = tempDir;
            return file;
        }
        catch (IOException e) {
            String systemTempDir = System.getProperty("java.io.tmpdir");
            String IOErrorSuggestion = e.getMessage() + ".  Could not create temp directory (prefix=\"" + prefix + "\", extension=\"" + extension + "\") under " + systemTempDir + ".  Please ensure that " + systemTempDir + " exists, that you have write access, and that the disk or folder is not full.";
            throw new IOException(IOErrorSuggestion, e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File outputFile, InputStream stream, byte[] buffer) throws IOException {
        File directory = outputFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            int byteReadCount = stream.read(buffer);
            while (byteReadCount > 0) {
                out.write(buffer, 0, byteReadCount);
                byteReadCount = stream.read(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String string, String encoding) throws IOException {
        try (FileOutputStream metadataStream = new FileOutputStream(file);
             OutputStreamWriter metadataOut = new OutputStreamWriter((OutputStream)metadataStream, encoding);){
            metadataOut.append(string);
            metadataOut.close();
            metadataStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, Document document) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getRawFormat().setExpandEmptyElements(true));
            outputter.output(document, (OutputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File input, File output) throws IOException {
        try (FileInputStream stream = new FileInputStream(input);){
            byte[] buffer = new byte[65536];
            FileUtilities.write(output, stream, buffer);
        }
    }

    public static void deleteRecursively(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    FileUtilities.deleteRecursively(child);
                }
            }
            file.delete();
        }
    }

    public static boolean containsText(File file, String text) throws IOException {
        text = FileUtilities.urlDecode(text);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                if ((line = FileUtilities.urlDecode(line)).contains(text)) {
                    boolean bl = true;
                    return bl;
                }
                line = reader.readLine();
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean containsRegex(File file, String regex, int end) throws IOException {
        Pattern regexp = Pattern.compile(regex);
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String line = in.readLine();
            for (int count = 0; line != null && (end < 0 || end > count); ++count) {
                boolean contains = regexp.matcher(line).find();
                if (contains) {
                    boolean bl = contains;
                    return bl;
                }
                line = in.readLine();
            }
        }
        return false;
    }

    public static String createScrubValue(File thresholdFile, File scrubFile, String scrubAnchor, String thresholdHref) {
        String scrubValue = FileUtilities.createScrubValue(thresholdFile, scrubFile, scrubAnchor);
        if (thresholdHref != null && FileUtilities.containsDoubleEscapedCharacter(thresholdHref) && !FileUtilities.containsDoubleEscapedCharacter(scrubValue)) {
            scrubValue = scrubValue.replaceAll("%(:?\\d\\d)", "%25$1");
        }
        return scrubValue;
    }

    public static boolean containsDoubleEscapedCharacter(String s) {
        return containsDoubleEscapedCharacterRexexPattern.matcher(s).find();
    }

    public static String createScrubValue(File thresholdFile, File scrubFile, String scrubAnchor) {
        if (thresholdFile == null) {
            return null;
        }
        int scrubDepth = 0;
        if (scrubFile != null) {
            scrubDepth = FileUtilities.getDepth(scrubFile);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < scrubDepth; ++i) {
            result.append("../");
        }
        result.append(thresholdFile.getPath());
        if (scrubAnchor != null) {
            result.append("#");
            result.append(scrubAnchor);
        }
        return result.toString();
    }

    public static int getDepth(File file) {
        int result = 0;
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            ++result;
        }
        return result;
    }

    public static String decodeURIPath(String href) {
        return FileUtilities.urlDecode(href);
    }

    public static String cleanURL(String href) {
        if (href == null) {
            return null;
        }
        href = href.replaceAll(" ", "%20").replace("[", "%5B").replace("]", "%5D");
        return href;
    }

    public static void append(File target, File source, int from, int to) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(source));
             FileWriter out = new FileWriter(target, true);){
            int skip;
            String line = in.readLine();
            for (skip = 0; line != null && from > skip; ++skip) {
                line = in.readLine();
            }
            while (line != null && (to < 0 || to >= skip)) {
                ++skip;
                out.append(line);
                line = in.readLine();
            }
        }
    }

    public static void writeReplace(File source, File target, String regex, String replacement) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(source));){
            boolean hasReplacement = regex != null && replacement != null;
            try (FileWriter out = new FileWriter(target, true);){
                String line = in.readLine();
                while (line != null) {
                    if (hasReplacement) {
                        line = line.replaceAll(regex, replacement);
                    }
                    out.append(line).append('\n');
                    line = in.readLine();
                }
            }
        }
    }

    public static String readFileAsString(File source) throws IOException {
        byte[] buffer = new byte[(int)source.length()];
        try (BufferedInputStream f = new BufferedInputStream(new FileInputStream(source));){
            f.read(buffer);
            String string = new String(buffer, "UTF-8");
            return string;
        }
    }

    public static String getFtyp(File source) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int read2;
            byte[] buffer = new byte[12];
            int read = 1;
            for (read2 = 0; read > 0 && read2 < 12; read2 += read) {
                read = in.read(buffer, read2, 12 - read2);
            }
            if (read2 < 12) {
                String string = null;
                return string;
            }
            String ftyp = new String(Arrays.copyOfRange(buffer, 4, 8));
            if (!"ftyp".equals(ftyp)) {
                String string = null;
                return string;
            }
            String string = new String(Arrays.copyOfRange(buffer, 8, 12));
            return string;
        }
    }

    public static String fileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }

    static String urlDecode(String input) {
        return FileUtilities.urlDecode(input, false);
    }

    static String urlDecode(String input, boolean decodePlus) {
        StringBuilder buf = null;
        byte[] utf8bytes = null;
        int length = input.length();
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (decodePlus && ch == '+') {
                buf = FileUtilities.prepareBuffer(buf, input, start, i);
                buf.append(' ');
                start = i + 1;
                continue;
            }
            if (ch != '%') continue;
            int accBytes = 0;
            int end = i;
            while (ch == '%' && i + 2 < length) {
                int v1 = FileUtilities.hex(input.charAt(i + 1));
                int v2 = FileUtilities.hex(input.charAt(i + 2));
                if (v1 < 0 || v2 < 0) break;
                if (utf8bytes == null) {
                    utf8bytes = new byte[length / 3];
                }
                utf8bytes[accBytes++] = (byte)((v1 << 4) + v2);
                if ((i += 3) >= length) break;
                ch = input.charAt(i);
            }
            if (accBytes <= 0) continue;
            buf = FileUtilities.prepareBuffer(buf, input, start, end);
            if (accBytes == 1) {
                buf.append((char)utf8bytes[0]);
            } else {
                try {
                    buf.append(new String(utf8bytes, 0, accBytes, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            start = i--;
        }
        if (buf != null && start < length) {
            buf.append(input, start, length);
        }
        return buf == null ? input : buf.toString();
    }

    private static StringBuilder prepareBuffer(StringBuilder buf, String source, int start, int end) {
        if (buf == null) {
            buf = new StringBuilder(source.length());
        }
        if (end > start) {
            buf.append(source, start, end);
        }
        return buf;
    }

    static int hex(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

