/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class DocumentInputSource
extends InputSource
implements Source {
    private static Logger log = Logger.getLogger(DocumentInputSource.class);
    private File file;
    private FileInputStream fileInputStream;

    public DocumentInputSource(URL url) throws FileNotFoundException, URISyntaxException {
        this(new URI(url.toExternalForm()));
    }

    public DocumentInputSource(URI uri) throws FileNotFoundException {
        this(new File(uri));
    }

    public DocumentInputSource(File file) throws FileNotFoundException {
        this.file = file;
        this.fileInputStream = new FileInputStream(file);
        this.setByteStream(this.fileInputStream);
    }

    public DocumentInputSource(String string) throws IOException {
        super(new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    public DocumentInputSource(String string, String charsetName) throws UnsupportedEncodingException {
        super(new ByteArrayInputStream(string.getBytes(charsetName)));
    }

    public DocumentInputSource(Document document) throws IOException {
        this(new XMLOutputter().outputString(document));
    }

    protected void finalize() throws Throwable {
        if (this.fileInputStream != null) {
            log.warn((Object)("DocumentInputSource FileInputStream for file: " + this.file.getName() + " was not closed"));
        }
        super.finalize();
    }

    public void cleanup() {
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("Cannot close FileInputStream for file: " + this.file.getName()), (Throwable)e);
            }
            this.fileInputStream = null;
        }
    }
}

