/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.util;

import com.apple.itunes.epubtoolkit.util.EPUBUnzipper;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.Enumeration;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class CommonsCompressZipUtil
implements EPUBUnzipper {
    @Override
    public void unzip(File zipFile, File outputDir) throws IOException {
        try (ZipFile file = new ZipFile(zipFile);){
            byte[] buffer = new byte[65536];
            Enumeration entries = file.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    outputFile.mkdirs();
                    continue;
                }
                InputStream entryContent = file.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtilities.write(outputFile, entryContent, buffer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryContent == null) continue;
                    if (throwable != null) {
                        try {
                            entryContent.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    entryContent.close();
                }
            }
        }
    }

    @Override
    public void zip(File inputDir, File outputFile) throws IOException {
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(outputFile);){
            File[] remainingFiles;
            zip.setMethod(0);
            byte[] buffer = new byte[65536];
            this.appendEpubFileTree(inputDir, new File(inputDir, "mimetype"), zip, buffer, 0);
            this.appendEpubFileTree(inputDir, new File(inputDir, "META-INF"), zip, buffer, 0);
            zip.setMethod(8);
            for (File f : remainingFiles = inputDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.equals("mimetype") && !name.equals("META-INF");
                }
            })) {
                this.appendEpubFileTree(inputDir, f, zip, buffer, 8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEpubFileTree(File root, File file, ZipArchiveOutputStream zip, byte[] buffer, int method) throws IOException {
        if (file.isFile()) {
            if (file.getName().endsWith("/rsrc")) {
                return;
            }
            String absolutePath = file.getAbsolutePath();
            String relativePath = absolutePath.substring(root.getAbsolutePath().length() + 1);
            String relativePathNFD = Normalizer.normalize(relativePath, Normalizer.Form.NFD);
            ZipArchiveEntry entry = new ZipArchiveEntry(relativePathNFD);
            if (method == 0) {
                entry.setSize(file.length());
                entry.setCrc(CommonsCompressZipUtil.calculateCRC(file).getValue());
            }
            zip.putArchiveEntry((ArchiveEntry)entry);
            try (FileInputStream inputStream = new FileInputStream(file);){
                int byteReadCount;
                while ((byteReadCount = ((InputStream)inputStream).read(buffer)) > 0) {
                    zip.write(buffer, 0, byteReadCount);
                }
            }
            finally {
                zip.closeArchiveEntry();
            }
            return;
        }
        if (file.isDirectory()) {
            File[] contents;
            for (File item : contents = file.listFiles()) {
                this.appendEpubFileTree(root, item, zip, buffer, method);
            }
        }
    }

    @Override
    public void unzip(InputStream is, File destination) throws IOException {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(is, "UTF-8", true, true);){
            ZipArchiveEntry entry = zis.getNextZipEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    File outputFile = new File(destination, entry.getName());
                    outputFile.getParentFile().mkdirs();
                    byte[] data = new byte[8192];
                    try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(outputFile), 8192);){
                        int count;
                        while ((count = zis.read(data, 0, 8192)) != -1) {
                            ((OutputStream)dest).write(data, 0, count);
                        }
                        ((OutputStream)dest).flush();
                    }
                }
                entry = zis.getNextZipEntry();
            }
        }
    }

    public static CRC32 calculateCRC(File file) throws IOException {
        CRC32 result = new CRC32();
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int readCount = ((InputStream)inputStream).read(buffer);
            while (readCount > 0) {
                result.update(buffer, 0, readCount);
                readCount = ((InputStream)inputStream).read(buffer);
            }
            CRC32 cRC32 = result;
            return cRC32;
        }
    }
}

