/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.io.File;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.xpath.XPath;

public class SearchIndex {
    private Document document;
    private XPathFactory xpathFactory;
    private String path;

    public SearchIndex(EPUBModel model) throws EPUBException {
        Document document;
        OPFDocument opf = model.getOPF();
        OPFManifestItem searchIndexItem = opf.getSearchIndex();
        if (searchIndexItem == null) {
            return;
        }
        this.path = searchIndexItem.getHref();
        String relativePath = FileUtilities.decodeURIPath(this.path);
        File rootFile = model.getOPFFile();
        File baseDir = rootFile.getParentFile();
        File searchIndex = new File(baseDir, relativePath);
        try {
            document = XMLUtilities.createDocument(searchIndex);
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse search index: " + rootFile.getName(), e);
        }
        this.document = document;
        this.xpathFactory = new XPathFactory();
    }

    private Document getDocument() {
        return this.document;
    }

    public String getPath() {
        return this.path;
    }

    public List<Element> getInstances() {
        if (null == this.xpathFactory) {
            return null;
        }
        XPath xpath = this.xpathFactory.createXPath("/index/ts/t/i");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    public List<Element> getTermElements() {
        if (null == this.xpathFactory) {
            return null;
        }
        XPath xpath = this.xpathFactory.createXPath("/index/ts/t");
        List terms = XPathFactory.selectNodes(this.getDocument(), xpath);
        return terms;
    }

    public List<Element> getReftextTerms() {
        if (null == this.xpathFactory) {
            return null;
        }
        XPath xpath = this.xpathFactory.createXPath("/index/rs/r");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    public List<Element> getTermStems() {
        if (null == this.xpathFactory) {
            return null;
        }
        XPath xpath = this.xpathFactory.createXPath("/index/ts");
        List termStems = XPathFactory.selectNodes(this.getDocument(), xpath);
        return termStems;
    }
}

