/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFSpineItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class OPFManifestItem {
    private static final Pattern XML_MEDIA_TYPE_PATTERN = Pattern.compile(".*[/|+]xml", 2);
    private static final Pattern XHTML_MEDIA_TYPE_PATTERN = Pattern.compile("application[/]xhtml[+]xml", 2);
    private static final Pattern CSS_MEDIA_TYPE_PATTERN = Pattern.compile("text[/]css", 2);
    private static final Pattern TEXT_MEDIA_TYPE_PATTERN = Pattern.compile("text", 2);
    private static final Pattern SVG_MEDIA_TYPE_PATTERN = Pattern.compile("image[/]svg[+]xml", 2);
    private static final Pattern VIDEO_MEDIA_TYPE_PATTERN = Pattern.compile("video[/].*", 2);
    private static final Pattern AUDIO_MEDIA_TYPE_PATTERN = Pattern.compile("audio[/].*", 2);
    private static final Pattern JAVASCRIPT_MEDIA_TYPE_PATTERN = Pattern.compile(".*javascript.*", 2);
    private static final String MEDIATYPE_ATTRIBUTE_NAME = "media-type";
    private OPFDocument opf;
    private Element element;

    OPFManifestItem(OPFDocument opf, Element element) {
        this.opf = opf;
        this.element = element;
    }

    public OPFDocument getOPF() {
        return this.opf;
    }

    protected Element getElement() {
        return this.element;
    }

    public boolean isSpineItem() {
        return this.opf.getSpineItem(this.getId()) != null;
    }

    public boolean isVideo() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return VIDEO_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isCSS() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return CSS_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isXHTML() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return XHTML_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isSVG() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return SVG_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isText() {
        if (this.isXHTML()) {
            return true;
        }
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return TEXT_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isImage() {
        String href = this.getHref().toLowerCase();
        boolean isImage = this.getMediaType().toLowerCase().startsWith("image");
        return isImage || href.endsWith(".png") || href.endsWith(".gif") || href.endsWith(".jpg") || href.endsWith(".svg") || href.endsWith(".jpeg");
    }

    public boolean isXML() {
        String mediaType = this.getMediaType();
        return mediaType != null && XML_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public boolean isInWidget() {
        return this.getHref().toLowerCase().contains(".wdgt/");
    }

    public String getId() {
        return this.element.getAttributeValue("id");
    }

    public String getHref() {
        return this.element.getAttributeValue("href");
    }

    public void setHref(String href) {
        this.element.setAttribute("href", href);
    }

    public String getFallback() {
        String fallback = this.element.getAttributeValue("fallback");
        if (fallback == null) {
            fallback = this.element.getAttributeValue("fallback-style");
        }
        return fallback;
    }

    public void setFallback(String fallback) {
        this.element.setAttribute("fallback", fallback);
    }

    public void removeFallback() {
        this.element.removeAttribute("fallback");
    }

    public OPFManifestItem getFallbackItem() {
        String fallbackId = this.getFallback();
        if (fallbackId == null) {
            return null;
        }
        return this.opf.getManifestItem(fallbackId);
    }

    public String getMediaType() {
        return this.element.getAttributeValue(MEDIATYPE_ATTRIBUTE_NAME).toLowerCase();
    }

    public void setMediaType(String value) {
        this.element.setAttribute(MEDIATYPE_ATTRIBUTE_NAME, value);
    }

    public OPFManifestItem getFallbackParent() {
        OPFManifestItem parent = this.opf.getManifestItemWithFallback(this.getId());
        if (parent == null) {
            parent = this.opf.getManifestItemWithFallbackStyle(this.getId());
        }
        return parent;
    }

    public boolean isFallback() {
        return this.getFallbackParent() != null;
    }

    public String toString() {
        return "OPFManifestItem{id=" + this.getId() + ", href=" + this.getHref() + ", media-type=" + this.getMediaType() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPFManifestItem other = (OPFManifestItem)obj;
        return this.getId().equals(other.getId()) && this.opf.equals(other.opf);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.element != null ? this.element.hashCode() : 0);
        return hash;
    }

    public boolean isAudio() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return AUDIO_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }

    public List<String> getProperties() {
        String allProps = this.element.getAttributeValue("properties");
        if (allProps == null) {
            return new ArrayList<String>();
        }
        String[] allPropsArray = allProps.split("\\s+");
        return Arrays.asList(allPropsArray);
    }

    public void setProperties(String value) {
        if (value == null || value.trim().isEmpty()) {
            this.element.removeAttribute("properties");
        } else {
            this.element.setAttribute("properties", value);
        }
    }

    public OPFSpineItem getSpineItem() {
        return this.opf.getSpineItem(this.getId());
    }

    public boolean isScript() {
        String mediaType = this.getMediaType();
        if (mediaType == null) {
            return false;
        }
        return JAVASCRIPT_MEDIA_TYPE_PATTERN.matcher(mediaType).matches();
    }
}

