/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.EPUBGuide;
import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.OPFGuideItem;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class OPFGuide
implements EPUBGuide {
    private Document document;
    private XPathFactory xpathFactory;

    public OPFGuide(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        String uri = namespace.getURI();
        this.xpathFactory = new XPathFactory();
        this.xpathFactory.addNamespace("opf", uri);
        this.xpathFactory.addNamespace("dc", "http://purl.org/dc/elements/1.1/");
    }

    @Override
    public GuideItem getGuideItem(String href) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:guide/opf:reference[@href='" + XMLUtilities.xpathEscape(href) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFGuideItem(element);
    }

    @Override
    public GuideItem getGuideItemByType(String type) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:guide/opf:reference[@type='" + XMLUtilities.xpathEscape(type) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFGuideItem(element);
    }

    @Override
    public GuideItem getBackCoverGuideItem() {
        return this.getGuideItemByType("other.back-cover");
    }

    @Override
    public List<String> getGuideURIs() {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:guide/opf:reference");
        List spineItems = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object object : spineItems) {
            Element item = (Element)object;
            result.add(item.getAttributeValue("href"));
        }
        return result;
    }

    @Override
    public List<GuideItem> getGuideItems() {
        ArrayList<GuideItem> result = new ArrayList<GuideItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:guide/opf:reference");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            result.add(new OPFGuideItem(element));
        }
        return result;
    }

    private Document getDocument() {
        return this.document;
    }

    @Override
    public GuideItem getCoverPageGuideItem() {
        return this.getGuideItemByType("cover");
    }
}

