/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.model.EPUBGuide;
import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.NavDocumentBuilder;
import com.apple.itunes.epubtoolkit.model.OPFGuide;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.OPFSpineItem;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class OPFDocument {
    private static final Logger logger = Logger.getLogger(OPFDocument.class);
    public static final String RDF_URL = "http://vocabulary.itunes.apple.com/rdf/ibooks/vocabulary-extensions-1.0";
    public static final String RENDITION_LAYOUT = "rendition:layout";
    public static final String RENDITION_SPREAD = "rendition:spread";
    public static final String PRE_PAGINATED = "pre-paginated";
    public static final String NONE = "none";
    private Document document;
    private XPathFactory xpathFactory;
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}(-\\d{2}(-\\d{2})?)?");
    private static final Pattern ISBN_PATTERN = Pattern.compile("[^0-9X]*([0-9]{9}[0-9X]|[0-9]{12}[0-9X])[^0-9X]*", 2);
    private EPUBGuide guide;
    private static final String UID_VALUE = "UID";
    private static final String BOOK_ID_VALUE = "BOOKID";
    private static final String ID_ATTRIBUTE = "id";
    static final Pattern URI_PATTERN = Pattern.compile("\\w+?://", 2);

    public OPFDocument(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        String uri = namespace.getURI();
        this.xpathFactory = new XPathFactory();
        this.xpathFactory.addNamespace("opf", uri);
        this.xpathFactory.addNamespace("dc", "http://purl.org/dc/elements/1.1/");
    }

    public void cleanup() {
        List<Attribute> creatorRoleAttributes;
        List<Element> dateElements;
        OPFManifestItem tocItem = this.getTableOfConentsItem();
        if (tocItem != null) {
            if (tocItem.getHref().endsWith(".ncx")) {
                tocItem.setMediaType("application/x-dtbncx+xml");
            }
        } else {
            List<OPFManifestItem> manifestItems = this.getLocalManifestItems();
            for (OPFManifestItem item : manifestItems) {
                String href = item.getHref();
                if (href == null) continue;
                boolean hasNcxExtension = href.endsWith(".ncx");
                boolean hasNcxMimeType = "application/x-dtbncx+xml".equalsIgnoreCase(item.getMediaType());
                if (!hasNcxExtension || !hasNcxMimeType) continue;
                this.setTableOfContentsItem(item);
            }
        }
        if ((dateElements = this.getDateElements()) != null) {
            for (Element dateElement : dateElements) {
                String dateText = dateElement.getTextTrim();
                Matcher matcher = DATE_FORMAT_PATTERN.matcher(dateText);
                if (matcher.matches()) continue;
                dateElement.detach();
            }
        }
        if ((creatorRoleAttributes = this.getCreatorRoleAttributes()) != null) {
            for (Attribute creatorRoleAttribute : creatorRoleAttributes) {
                String value = creatorRoleAttribute.getValue();
                if (!"author".equalsIgnoreCase(value)) continue;
                creatorRoleAttribute.setValue("aut");
            }
        }
        List<Element> spineItemElements = this.getSpineItemElements();
        HashSet<String> spineItemIdentifiers = new HashSet<String>();
        for (Element item : spineItemElements) {
            String idref = item.getAttributeValue("idref");
            if (idref == null) continue;
            boolean containsId = spineItemIdentifiers.contains(idref);
            if (containsId) {
                item.detach();
            }
            spineItemIdentifiers.add(idref);
        }
        this.removeDanglingRefines();
    }

    public String getAppleAssetVersion() {
        String prefix = this.getPrefix(RDF_URL);
        if (prefix == null) {
            return null;
        }
        Element metaElement = this.getMetaElement(prefix + "version");
        if (metaElement == null) {
            return null;
        }
        return metaElement.getText();
    }

    public String getCoverWritingMode() {
        String prefix = this.getPrefix(RDF_URL);
        if (prefix == null) {
            return null;
        }
        Element metaElement = this.getMetaElement(prefix + "cover-writing-mode");
        if (metaElement == null) {
            metaElement = this.getMetaElementByName(prefix + "cover-writing-mode");
            if (metaElement == null) {
                return null;
            }
            return metaElement.getAttributeValue("content");
        }
        return metaElement.getText();
    }

    public String getScrollAxis() {
        String prefix = this.getPrefix(RDF_URL);
        if (prefix == null) {
            return null;
        }
        Element metaElement = this.getMetaElement(prefix + "scroll-axis");
        if (metaElement == null) {
            metaElement = this.getMetaElementByName(prefix + "scroll-axis");
            if (metaElement == null) {
                return null;
            }
            return metaElement.getAttributeValue("content");
        }
        return metaElement.getText();
    }

    public OPFManifestItem getSearchIndex() {
        String id;
        Element metaElement = this.getMetaElementByName("ibooks:searchIndex");
        if (metaElement == null) {
            String prefix = this.getPrefix(RDF_URL);
            if (prefix == null) {
                return null;
            }
            metaElement = this.getMetaElementByName(prefix + "searchIndex");
            if (metaElement == null) {
                return null;
            }
        }
        if ((id = metaElement.getAttributeValue("content")) == null) {
            return null;
        }
        return this.getManifestItem(id);
    }

    public OPFManifestItem getSearchRefText() {
        String id;
        Element metaElement = this.getMetaElementByName("ibooks:searchReferenceText");
        if (metaElement == null) {
            String prefix = this.getPrefix(RDF_URL);
            if (prefix == null) {
                return null;
            }
            metaElement = this.getMetaElementByName(prefix + "searchReferenceText");
            if (metaElement == null) {
                return null;
            }
        }
        if ((id = metaElement.getAttributeValue("content")) == null) {
            return null;
        }
        return this.getManifestItem(id);
    }

    public String getContentVersions() {
        String content;
        Element metaElement = this.getMetaElementByName("ibooks:contentVersions");
        if (metaElement == null) {
            String prefix = this.getPrefix(RDF_URL);
            if (prefix == null) {
                return null;
            }
            metaElement = this.getMetaElementByName(prefix + "contentVersions");
            if (metaElement == null) {
                return null;
            }
        }
        if ((content = metaElement.getAttributeValue("content")) == null && (content = metaElement.getText()) == null) {
            return null;
        }
        return content;
    }

    public String getPrefix(String uri) {
        Element rootElement = this.document.getRootElement();
        Attribute prefix = rootElement.getAttribute("prefix");
        if (prefix == null) {
            return null;
        }
        String[] prefixes = prefix.getValue().split("\\s+");
        for (int i = 1; i < prefixes.length; i += 2) {
            if (!prefixes[i].toLowerCase().startsWith(uri)) continue;
            return prefixes[i - 1];
        }
        return null;
    }

    public void addPrefix(String name, String uri) {
        String value;
        Element rootElement;
        Attribute prefix;
        if (!name.endsWith(":")) {
            name = name + ":";
        }
        if ((prefix = (rootElement = this.document.getRootElement()).getAttribute("prefix")) == null) {
            prefix = new Attribute("prefix", "");
            rootElement.setAttribute(prefix);
            value = "";
        } else {
            value = prefix.getValue() + " ";
        }
        prefix.setValue(value + name + " " + uri);
    }

    public Collection<String> getAuthors() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elements = this.getCreatorAuthorElements();
        for (Element element : elements) {
            result.add(element.getTextNormalize());
        }
        return result;
    }

    public Collection<String> getAllCreatorsAndContributors() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elements = this.getAllCreatorElements();
        for (Element element : elements) {
            result.add(element.getTextNormalize());
        }
        List<Element> elements2 = this.getAllContributorElements();
        for (Element element : elements2) {
            result.add(element.getTextNormalize());
        }
        return result;
    }

    public List<String> getUniqueIdentifiers() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> identifierElements = this.getIdentifierElements();
        for (Element element : identifierElements) {
            String key;
            boolean keyContains;
            String value = element.getTextNormalize();
            if (value == null || !(keyContains = (key = element.getAttributeValue(ID_ATTRIBUTE)) != null && (key.toUpperCase().contains(BOOK_ID_VALUE) || key.toUpperCase().contains(UID_VALUE)))) continue;
            result.add(value);
        }
        return result;
    }

    public Collection<String> getIsbns() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> identifierElements = this.getIdentifierElements();
        for (Element element : identifierElements) {
            Matcher matcher;
            boolean matches;
            String value = element.getTextNormalize();
            if (value == null) continue;
            String key = element.getAttributeValue(ID_ATTRIBUTE);
            boolean keyContains = key != null && key.toUpperCase().contains("ISBN");
            boolean valueContains = value.toUpperCase().contains("ISBN");
            if (!keyContains && !valueContains || !(matches = (matcher = ISBN_PATTERN.matcher(value.replace("-", ""))).matches())) continue;
            String isbn = matcher.group(1);
            result.add(isbn);
        }
        return result;
    }

    public String getDescription() {
        Element descriptionElement = this.getDescriptionElement();
        if (descriptionElement == null) {
            return null;
        }
        return descriptionElement.getText();
    }

    public Collection<String> getDates() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elements = this.getDateElements();
        for (Element element : elements) {
            result.add(element.getTextNormalize());
        }
        return result;
    }

    public Collection<String> getBookProducers() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elements = this.getBookProducerElements();
        for (Element element : elements) {
            result.add(element.getTextNormalize());
        }
        return result;
    }

    public String getRights() {
        Element rightsElement = this.getRightsElement();
        if (rightsElement == null) {
            return null;
        }
        return rightsElement.getText();
    }

    public String getLanguage() {
        Element languageElement = this.getLanguageElement();
        if (languageElement == null) {
            return null;
        }
        return languageElement.getText();
    }

    public String getTitle() {
        Element titleElement = this.getTitleElement();
        if (titleElement == null) {
            return null;
        }
        return titleElement.getText();
    }

    public OPFManifestItem getCoverItem() {
        List<OPFManifestItem> coverItems = this.getManifestItemsByProperty("cover-image");
        if (coverItems != null && !coverItems.isEmpty()) {
            return coverItems.get(0);
        }
        Element element = this.getCoverMetaElement();
        if (element == null) {
            return null;
        }
        String content = element.getAttributeValue("content");
        if (content == null) {
            return null;
        }
        return this.getManifestItem(content);
    }

    public String getCoverItemHrefIfFileDirectlyReferencedInMetadata() {
        Element element = this.getCoverMetaElement();
        if (element == null) {
            return null;
        }
        String content = element.getAttributeValue("content");
        return content;
    }

    public String getModified() {
        Element modElement = this.getMetaElement("dcterms:modified");
        if (modElement == null) {
            return null;
        }
        return modElement.getText();
    }

    public String getIbooksAuthorVersion() {
        Collection<String> bookProducers = this.getBookProducers();
        if (bookProducers != null) {
            Pattern p = Pattern.compile("(?i)iBooks Author [v]?([\\d\\.]*)");
            for (String bkp : bookProducers) {
                Matcher m = p.matcher(bkp);
                if (!m.matches()) continue;
                return m.group(1);
            }
        }
        return null;
    }

    public Element getMetaElement(String property) {
        return this.getMetaElementByAttributeNameAndValue("property", property);
    }

    public void addMetaElement(String property, String value) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata");
        Element metadataElem = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (metadataElem == null) {
            return;
        }
        Element metaElem = new Element("meta", this.document.getRootElement().getNamespace());
        metaElem.setAttribute("property", property);
        metaElem.setText(value);
        metadataElem.addContent((Content)metaElem);
    }

    protected Element getMetaElementByAttributeNameAndValue(String attributeName, String attributeValue) {
        String path = String.format("/opf:package/opf:metadata/opf:meta[@%s='%s' or fn:lower-case(@%s)=fn:lower-case('%s')]", attributeName, attributeValue, attributeName, attributeValue);
        XPath xpath = this.xpathFactory.createXPath(path);
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getMetaElementByName(String name) {
        return this.getMetaElementByAttributeNameAndValue("name", name);
    }

    protected Element getCoverMetaElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/opf:meta[fn:lower-case(@name)='cover']");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getTitleElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:title");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getLanguageElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:language");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getSubjectElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:subject");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getRightsElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:rights");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected Element getDescriptionElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:description");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    protected List<Element> getIdentifierElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:identifier");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getDateElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:date");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getBookProducerElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:contributor[@opf:role='bkp']");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getCreatorAuthorElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:creator[@opf:role='aut']");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getAllCreatorElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:creator");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getAllContributorElements() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:contributor");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Attribute> getCreatorRoleAttributes() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/dc:creator/@opf:role");
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    protected List<Element> getSpineItemElements() {
        ArrayList<Element> result = new ArrayList<Element>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:spine/opf:itemref");
        List spineItems = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object object : spineItems) {
            Element item = (Element)object;
            result.add(item);
        }
        return result;
    }

    public List<String> getSpineIdentifiers() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elementList = this.getSpineItemElements();
        for (Element item : elementList) {
            String idref = item.getAttributeValue("idref");
            if (idref == null) {
                throw new IllegalStateException("Unable to get idref for node: " + item);
            }
            result.add(idref);
        }
        return result;
    }

    public List<String> getXHTMLSpineIdentifiers() throws EPUBException {
        List<String> spine = this.getSpineIdentifiers();
        ArrayList<String> xhtmlSpine = new ArrayList<String>();
        for (String id : spine) {
            OPFManifestItem opfMainfestItem = this.getManifestItem(id);
            if (opfMainfestItem == null) {
                throw new EPUBException("Book manifest file has a <spine><itemref idref=\"" + id + "\"> but no matching <manifest><item id=\"" + id + "\">");
            }
            if (!opfMainfestItem.isXHTML()) continue;
            xhtmlSpine.add(id);
        }
        return xhtmlSpine;
    }

    public OPFManifestItem getTableOfConentsItem() {
        String tocId = this.getTableOfConentsId();
        if (tocId == null) {
            return null;
        }
        OPFManifestItem tocItem = this.getManifestItem(tocId);
        if (tocItem == null) {
            throw new IllegalStateException("Table of contents with id '" + tocId + "' referenced by spine but not present in manifest.");
        }
        return tocItem;
    }

    private void setTableOfContentsItem(OPFManifestItem item) {
        Element spine = this.getSpineElement();
        if (spine == null) {
            return;
        }
        spine.setAttribute("toc", item.getId());
    }

    public Element getSpineElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:spine");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    public String getTableOfConentsId() {
        String toc = this.getXHTMLNavId();
        if (toc == null) {
            toc = this.getNCXNavId();
        }
        return toc;
    }

    public String getXHTMLNavId() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[contains(@properties,'nav')]/@id");
        Attribute tocAttribute = (Attribute)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (tocAttribute == null) {
            return null;
        }
        return tocAttribute.getValue();
    }

    public String getNCXNavId() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:spine/@toc");
        Attribute tocAttribute = (Attribute)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (tocAttribute == null) {
            return null;
        }
        return tocAttribute.getValue();
    }

    public OPFManifestItem getTableOfConentsItem(NavDocumentBuilder.NavType type) {
        String tocId = null;
        switch (type) {
            case NCX: {
                tocId = this.getNCXNavId();
                break;
            }
            case XHTML: {
                tocId = this.getXHTMLNavId();
            }
        }
        if (tocId == null) {
            return null;
        }
        OPFManifestItem tocItem = this.getManifestItem(tocId);
        if (tocItem == null) {
            throw new IllegalStateException("Table of contents with id '" + tocId + "' referenced but not present in manifest.");
        }
        return tocItem;
    }

    public String getVersion() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/@version");
        Attribute versionAttribute = (Attribute)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (versionAttribute == null) {
            return null;
        }
        return versionAttribute.getValue();
    }

    public void detatchVersionElement() {
        Element versionElem = this.getMetaElement("ibooks:version");
        if (versionElem != null) {
            versionElem.detach();
        }
    }

    public OPFManifestItem getPageMap() {
        Element spine = this.getSpineElement();
        String map = spine.getAttributeValue("page-map");
        if (map == null || map.length() < 1) {
            return null;
        }
        return this.getManifestItem(map);
    }

    public String getPageProgressionDirection() {
        Element spine = this.getSpineElement();
        String direction = spine.getAttributeValue("page-progression-direction");
        return direction;
    }

    public List<OPFManifestItem> getAllManifestItems() {
        ArrayList<OPFManifestItem> result = new ArrayList<OPFManifestItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            OPFManifestItem manifestItem = new OPFManifestItem(this, element);
            result.add(manifestItem);
        }
        return result;
    }

    public List<String> getLocalManifestItemsUrisWithPotentialNormalizationProblems(File opfFile) {
        ArrayList<String> result = new ArrayList<String>();
        for (OPFManifestItem item : this.getLocalManifestItems()) {
            String decodedPath = FileUtilities.decodeURIPath(item.getHref());
            if (!Normalizer.isNormalized(decodedPath, Normalizer.Form.NFC) || !Normalizer.isNormalized(decodedPath, Normalizer.Form.NFD)) {
                result.add(decodedPath);
                continue;
            }
            File referencedFile = new File(opfFile.getParentFile(), decodedPath);
            if (referencedFile.exists()) continue;
            result.add(decodedPath);
        }
        return result;
    }

    public List<String> getLocalManifestItemsUrisWithNonFileTargets(File opfFile) {
        ArrayList<String> result = new ArrayList<String>();
        for (OPFManifestItem item : this.getLocalManifestItems()) {
            String decodedPath = FileUtilities.decodeURIPath(item.getHref());
            File referencedFile = new File(opfFile.getParentFile(), decodedPath);
            if (referencedFile.isFile()) continue;
            result.add(decodedPath);
        }
        return result;
    }

    public List<OPFManifestItem> getLocalManifestItems() {
        ArrayList<OPFManifestItem> result = new ArrayList<OPFManifestItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            OPFManifestItem manifestItem = new OPFManifestItem(this, element);
            if (manifestItem == null || !OPFDocument.isLocalFileHref(manifestItem.getHref())) continue;
            result.add(manifestItem);
        }
        return result;
    }

    public List<OPFManifestItem> getRemoteManifestItems() {
        ArrayList<OPFManifestItem> result = new ArrayList<OPFManifestItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            OPFManifestItem manifestItem = new OPFManifestItem(this, element);
            if (manifestItem == null || OPFDocument.isLocalFileHref(manifestItem.getHref())) continue;
            result.add(manifestItem);
        }
        return result;
    }

    private static boolean isLocalFileHref(String href) {
        String s;
        if (href == null) {
            return false;
        }
        Matcher matcher = URI_PATTERN.matcher(href);
        return !matcher.find() || (s = matcher.group(0)).equals("file://");
    }

    public OPFManifestItem getManifestItem(String id) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[@id='" + XMLUtilities.xpathEscape(id) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFManifestItem(this, element);
    }

    public OPFManifestItem getManifestItem(GuideItem gItem) {
        String navId = this.getXHTMLNavId();
        String gURI = gItem.getURI();
        if (gURI.contains("#")) {
            gURI = gURI.substring(0, gURI.indexOf("#"));
        }
        if (navId == null) {
            return this.getManifestItemByHref(gURI);
        }
        OPFManifestItem navItem = this.getManifestItem(navId);
        String navURI = navItem.getHref();
        String filename = FilenameUtils.concat((String)(navURI = FilenameUtils.getPath((String)navURI)), (String)gURI);
        if (filename == null) {
            return null;
        }
        return this.getManifestItemByHref(filename);
    }

    public OPFManifestItem getManifestItemByHref(String href) {
        String xpathString = null;
        xpathString = href.indexOf("'") > -1 ? "/opf:package/opf:manifest/opf:item[@href=\"" + href.replaceAll("&", "&amp;") + "\"]" : "/opf:package/opf:manifest/opf:item[@href='" + XMLUtilities.xpathEscape(href) + "']";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFManifestItem(this, element);
    }

    public OPFManifestItem getManifestItem(CFI cfi) {
        if (cfi == null) {
            throw new IllegalArgumentException("Parameter cfi cannot be null.");
        }
        Element element = cfi.resolveToElement(this.document.getRootElement());
        if (element == null || !"itemref".equals(element.getName())) {
            return null;
        }
        return this.getManifestItem(element.getAttributeValue("idref"));
    }

    public List<String> getMetadataLinksHrefs() {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata/opf:link");
        List references = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Element reference : references) {
            String href = reference.getAttributeValue("href");
            result.add(href);
        }
        return result;
    }

    public List<OPFManifestItem> getManifestItemsByProperty(String property) {
        ArrayList<OPFManifestItem> result = new ArrayList<OPFManifestItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[contains(@properties,'" + XMLUtilities.xpathEscape(property) + "')]");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            result.add(new OPFManifestItem(this, element));
        }
        return result;
    }

    public List<OPFManifestItem> getManifestItemsByMediaType(String mediaType) {
        ArrayList<OPFManifestItem> result = new ArrayList<OPFManifestItem>();
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[contains(@media-type,'" + XMLUtilities.xpathEscape(mediaType) + "')]");
        List nodes = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object nodeObj : nodes) {
            Element element = (Element)nodeObj;
            result.add(new OPFManifestItem(this, element));
        }
        return result;
    }

    public OPFSpineItem getSpineItem(String id) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:spine/opf:itemref[@idref='" + XMLUtilities.xpathEscape(id) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFSpineItem(this, element);
    }

    public Document getDocument() {
        return this.document;
    }

    public void deleteManifestItem(String id) {
        OPFSpineItem spineItem;
        OPFManifestItem manifestItem = this.getManifestItem(id);
        String href = null;
        if (manifestItem != null) {
            href = manifestItem.getHref();
            Element element = manifestItem.getElement();
            element.detach();
        }
        if ((spineItem = this.getSpineItem(id)) != null) {
            Element element = spineItem.getElement();
            element.detach();
        }
    }

    public String getFirstPageHref() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:guide/opf:reference");
        List references = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Element reference : references) {
            String[] preferedTypes;
            String type = reference.getAttributeValue("type");
            String href = reference.getAttributeValue("href");
            for (String preferedType : preferedTypes = new String[]{"text", "start", "acknowledgements", "dedication", "foreword", "preface"}) {
                if (!preferedType.equalsIgnoreCase(type)) continue;
                return href;
            }
        }
        return null;
    }

    public EPUBGuide getGuide() {
        if (this.guide == null) {
            this.guide = new OPFGuide(this.getDocument());
        }
        return this.guide;
    }

    public OPFManifestItem getManifestItemWithFallback(String id) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[@fallback='" + XMLUtilities.xpathEscape(id) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFManifestItem(this, element);
    }

    public OPFManifestItem getManifestItemWithFallbackStyle(String id) {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:manifest/opf:item[@fallback-style='" + XMLUtilities.xpathEscape(id) + "']");
        Element element = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (element == null) {
            return null;
        }
        return new OPFManifestItem(this, element);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPFDocument other = (OPFDocument)obj;
        return this.document == other.document || this.document != null && this.document.equals((Object)other.document);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this.document != null ? this.document.hashCode() : 0);
        return hash;
    }

    public boolean isRenditionLayoutFixed() {
        Element renditionLayoutElement = this.getMetaElement(RENDITION_LAYOUT);
        return renditionLayoutElement != null && renditionLayoutElement.getText() != null && renditionLayoutElement.getText().equals(PRE_PAGINATED);
    }

    public boolean isRenditionSpreadNone() {
        Element renditionSpreadElement = this.getMetaElement(RENDITION_SPREAD);
        if (renditionSpreadElement == null) {
            return false;
        }
        String renditionSpread = renditionSpreadElement.getText();
        if (renditionSpread == null) {
            return false;
        }
        return renditionSpread.equalsIgnoreCase(NONE);
    }

    private void removeDanglingRefines() {
        XPath refinesXPath = this.xpathFactory.createXPath("//*[@refines and starts-with(@refines,'#')]");
        List refinesList = XPathFactory.selectNodes(this.getDocument(), refinesXPath);
        for (Object refines : refinesList) {
            if (!(refines instanceof Element)) continue;
            Element refinesElement = (Element)refines;
            String refinesValue = refinesElement.getAttribute("refines").getValue().substring(1);
            XPath targetXPath = this.xpathFactory.createXPath("//*[@id=" + refinesValue + "]");
            List targetList = XPathFactory.selectNodes(this.getDocument(), targetXPath);
            if (targetList != null && targetList.size() != 0) continue;
            refinesElement.detach();
        }
    }

    protected Element getMetadataElement() {
        XPath xpath = this.xpathFactory.createXPath("/opf:package/opf:metadata");
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    public String getMetadataXml() {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getCompactFormat());
        return outputter.outputString(this.getMetadataElement());
    }

    public String getCreatorOrGenerator() {
        if (this.getBookProducers().size() > 0) {
            return this.getBookProducers().iterator().next();
        }
        Element generatorElement = this.getMetaElementByName("generator");
        if (generatorElement != null) {
            return generatorElement.getAttributeValue("content");
        }
        return null;
    }

    public void detachiTunesArtworkManifestItem(File ePubFolder, File opfFile) {
        File iTunesArtworkAtRoot = new File(ePubFolder, "iTunesArtwork");
        List<OPFManifestItem> manifestItems = this.getLocalManifestItems();
        for (OPFManifestItem item : manifestItems) {
            String href = item.getHref();
            if (href == null) continue;
            File referencedFile = new File(opfFile.getParentFile(), FileUtilities.decodeURIPath(href));
            try {
                String referencedFileCanonicalPath;
                String iTunesArtworkAtRootCanonicalPath = iTunesArtworkAtRoot.getCanonicalPath();
                if (!iTunesArtworkAtRootCanonicalPath.equals(referencedFileCanonicalPath = referencedFile.getCanonicalPath())) continue;
                item.getElement().detach();
                logger.debug((Object)"DETACH_MANIFEST_ITEM_WITH_ITUNESARTWORK_HREF");
            }
            catch (IOException e) {
                logger.error((Object)"CANNOT_GET_CANONICAL_PATH", (Throwable)e);
            }
        }
    }
}

