/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.NavPoint;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class NCXNavPoint
implements NavPoint {
    private Element element;
    private XPathFactory xpathFactory;

    public NCXNavPoint(Element element) {
        String uri;
        this.element = element;
        this.xpathFactory = new XPathFactory();
        Namespace namespace = element.getNamespace();
        if (namespace != null && (uri = namespace.getURI()) != null && uri.length() > 0) {
            this.xpathFactory.addNamespace("ncx", uri);
        }
    }

    protected String getClassAttribute() {
        return this.element.getAttributeValue("class");
    }

    private Element getContent() {
        return this.element.getChild("content", this.element.getNamespace());
    }

    public String getTitle() {
        return this.element.getValue();
    }

    @Override
    public String getLabel() {
        String xpathString = "ncx:navLabel/ncx:text";
        XPath xpath = this.xpathFactory.createXPath("ncx:navLabel/ncx:text");
        Element textElement = (Element)XPathFactory.selectSingleNode(this.element, xpath);
        if (textElement == null) {
            if (this.getTitle() != null && this.getTitle().length() > 0) {
                return this.getTitle();
            }
            return null;
        }
        return textElement.getText();
    }

    public String getText() {
        String xpathString = "ncx:navLabel/ncx:text";
        XPath xpath = this.xpathFactory.createXPath("ncx:navLabel/ncx:text");
        Element textElement = (Element)XPathFactory.selectSingleNode(this.element, xpath);
        if (textElement == null) {
            return null;
        }
        return textElement.getText();
    }

    @Override
    public String getURI() {
        Element content = this.getContent();
        if (content == null) {
            return null;
        }
        return content.getAttributeValue("src");
    }

    @Override
    public void setURI(String src) {
        Element content = this.getContent();
        if (content == null) {
            return;
        }
        content.setAttribute("src", src);
    }

    @Override
    public Element getDOMElement() {
        return this.element;
    }
}

