/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfoError;
import com.apple.itunes.epubtoolkit.EPUBInfoErrorEnum;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.NCXDocument;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalAddException;
import org.jdom2.IllegalDataException;
import org.jdom2.IllegalNameException;
import org.jdom2.IllegalTargetException;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class NCXExtensions {
    private final boolean validateContents;
    private final List<EPUBInfoError> errorList = new ArrayList<EPUBInfoError>();
    private final File baseDir;
    private final String extensionsFileName;
    private final Document ncxExtensionsDocument;
    private final List<Attribute> navPointIdAttributes = new ArrayList<Attribute>();
    private final LinkedHashMap<String, NavMapEntry> navMap = new LinkedHashMap();
    private String ibooksCurrentVersion;
    private String ibooksRequiredVersion;
    private String tocHeaderImage;
    private Boolean showPageNumbers;
    private long numberOfPagesTotal = 0L;
    private long numberOfTOCHeadingsTotal = 0L;

    public NCXExtensions(EPUBModel model, NCXDocument ncxDocument, boolean validateContents) throws EPUBException {
        this.validateContents = validateContents;
        this.baseDir = model.getOPFFile().getParentFile();
        this.extensionsFileName = ncxDocument.getNXCAdditions();
        this.ncxExtensionsDocument = this.getNCXExtensionsDocument(this.baseDir, this.extensionsFileName);
        if (this.ncxExtensionsDocument != null) {
            this.populateNavPointIdAttributes(ncxDocument);
            this.processPlist();
            this.computeSummaryAttributes();
        }
    }

    private Document getNCXExtensionsDocument(File baseDir, String extensionsFileName) {
        if (extensionsFileName == null || extensionsFileName.trim().length() == 0) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.NO_NCX_EXTENSIONS_DOCUMENT_SPECIFIED, extensionsFileName, "No NCX Extensions Document specified");
            this.errorList.add(error);
            return null;
        }
        File ncxExtensionsFile = new File(baseDir, extensionsFileName);
        if (!ncxExtensionsFile.exists()) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.NO_NCX_EXTENSIONS_DOCUMENT_FILE, extensionsFileName, "No NCX Extensions file found at:" + extensionsFileName);
            this.errorList.add(error);
            return null;
        }
        try {
            return XMLUtilities.createDocument(ncxExtensionsFile);
        }
        catch (IllegalAddException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (IllegalDataException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (IllegalNameException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (IllegalTargetException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (JDOMException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.JDOM_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (IOException e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.IO_EXCEPTION_IN_PARSING_XML, extensionsFileName, e.getMessage());
            this.errorList.add(error);
            return null;
        }
        catch (Exception e) {
            EPUBInfoError error = new EPUBInfoError(EPUBInfoErrorEnum.CANNOT_CREATE_DOC_FOR_NCX_EXTENSIONS, extensionsFileName, "Cannot create Document for this Content XHTML");
            this.errorList.add(error);
            return null;
        }
    }

    private void populateNavPointIdAttributes(NCXDocument ncxDocument) {
        XPathFactory ncxDocumentXPathFactory = new XPathFactory();
        ncxDocumentXPathFactory.addNamespace("ncx", "http://www.daisy.org/z3986/2005/ncx/");
        XPath navPointsIdXPath = ncxDocumentXPathFactory.createXPath("//ncx:navPoint/@id");
        this.navPointIdAttributes.addAll(XPathFactory.selectNodes(ncxDocument.getDocument(), navPointsIdXPath));
        if (this.navPointIdAttributes == null || this.navPointIdAttributes.size() == 0) {
            return;
        }
    }

    private void processPlist() {
        Element rootElement = this.ncxExtensionsDocument.getRootElement();
        List rootDictionaryElements = rootElement.getChildren("dict");
        if (rootDictionaryElements.isEmpty()) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "No <dict> element found in NCX Extensions document"));
            }
            return;
        }
        if (rootDictionaryElements.size() > 1) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "Multiple <dict> elements found in NCX Extensions document"));
            }
            return;
        }
        Element rootDictionaryElement = (Element)rootDictionaryElements.get(0);
        LinkedHashMap<String, Element> rootDictionary = NCXExtensions.convertToDictionary(rootDictionaryElement);
        if (rootDictionary.isEmpty()) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "Empty <dict> element found in NCX Extensions document"));
            }
            return;
        }
        this.ibooksCurrentVersion = NCXExtensions.getElementTextTrim(rootDictionary.get("ibooks:currentVersion"));
        this.ibooksRequiredVersion = NCXExtensions.getElementTextTrim(rootDictionary.get("ibooks:requiredVersion"));
        this.tocHeaderImage = NCXExtensions.getElementTextTrim(rootDictionary.get("tocHeaderImage"));
        this.showPageNumbers = NCXExtensions.getBooleanFromElementName(rootDictionary.get("showPageNumbers"));
        Element navMapElement = rootDictionary.get("navMap");
        if (navMapElement == null) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "No <navMap> element found in <dict> element in NCX Extensions document"));
            }
            return;
        }
        this.processNavMap(navMapElement);
    }

    private void processNavMap(Element navMapElement) {
        if (!navMapElement.getName().equals("dict")) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "No <dict> element found for <navMap> element in NCX Extensions document"));
            }
            return;
        }
        LinkedHashMap<String, Element> navDictionary = NCXExtensions.convertToDictionary(navMapElement);
        if (this.validateContents) {
            for (Attribute attribute : this.navPointIdAttributes) {
                String idValue = attribute.getValue();
                if (navDictionary.containsKey(idValue)) continue;
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NO_NCX_EXTENSION_FOUND_FOR_NAVPOINT, this.extensionsFileName, "No NCX Extension found for NavPoint id=" + idValue));
            }
        }
        for (Map.Entry entry : navDictionary.entrySet()) {
            this.processNavEntry(entry);
        }
    }

    private void processNavEntry(Map.Entry<String, Element> navElementEntry) {
        String navKey = navElementEntry.getKey();
        Element navElement = navElementEntry.getValue();
        if (!navElement.getName().equals("dict")) {
            if (this.validateContents) {
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.INVALID_NCX_EXTENSIONS_STRUCTURE, this.extensionsFileName, "No <dict> element found for <navMap> key " + navKey + " in NCX Extensions document"));
            }
            return;
        }
        NavMapEntry navMapEntry = new NavMapEntry(navKey);
        this.navMap.put(navKey, navMapEntry);
        LinkedHashMap<String, Element> dictionary = NCXExtensions.convertToDictionary(navElement);
        for (Map.Entry<String, Element> dictionaryEntry : dictionary.entrySet()) {
            if (dictionaryEntry.getKey().equals("sectionIdentifier")) {
                this.processSectionIdentifier(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("displayNumberFormat")) {
                this.processDisplayNumberFormat(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("displayStartPageNumber")) {
                this.processDisplayStartPageNumber(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("includeInTOC")) {
                this.processIncludeInTOC(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("numberOfPages")) {
                this.processNumberOfPages(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("numberOfTOCHeadings")) {
                this.processNumberOfTOCHeadings(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (dictionaryEntry.getKey().equals("tinyThumbs")) {
                this.processTinyThumbs(navMapEntry, dictionaryEntry.getValue());
                continue;
            }
            if (!dictionaryEntry.getKey().equals("largerThumbs")) continue;
            this.processLargerThumbs(navMapEntry, dictionaryEntry.getValue());
        }
    }

    private void processSectionIdentifier(NavMapEntry navMapEntry, Element element) {
        navMapEntry.sectionIdentifier = element.getTextTrim();
    }

    private void processDisplayNumberFormat(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("string")) {
            navMapEntry.displayNumberFormat = element.getTextTrim();
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "displayNumberFormat for key " + navMapEntry.getKey() + " is invalid: " + element.getTextTrim()));
        }
    }

    private void processDisplayStartPageNumber(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("integer") && element.getTextTrim().matches("\\d+")) {
            navMapEntry.displayStartPageNumber = NCXExtensions.getIntegerFromElementText(element);
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "displayStartPageNumber for key " + navMapEntry.getKey() + " is invalid: " + element.getTextTrim()));
        }
    }

    private void processIncludeInTOC(NavMapEntry navMapEntry, Element element) {
        navMapEntry.includeInTOC = NCXExtensions.getBooleanFromElementName(element);
    }

    private void processNumberOfPages(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("integer") && element.getTextTrim().matches("\\d+")) {
            navMapEntry.numberOfPages = NCXExtensions.getIntegerFromElementText(element);
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "numberOfPages for key " + navMapEntry.getKey() + " is invalid: " + element.getTextTrim()));
        }
    }

    private void processNumberOfTOCHeadings(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("integer") && element.getTextTrim().matches("\\d+")) {
            navMapEntry.numberOfTOCHeadings = NCXExtensions.getIntegerFromElementText(element);
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "numberOfTOCHeadings for key " + navMapEntry.getKey() + " is invalid: " + element.getTextTrim()));
        }
    }

    private void processTinyThumbs(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("array")) {
            List stringChildrenElements = element.getChildren("string");
            for (Element stringChildElement : stringChildrenElements) {
                File file;
                String relativePath = stringChildElement.getTextTrim();
                navMapEntry.tinyThumbs.add(relativePath);
                if (!this.validateContents || (file = new File(this.baseDir.getParentFile(), relativePath)).exists()) continue;
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "tinyThumbs file for key " + navMapEntry.getKey() + " does not exist: " + relativePath));
            }
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "tinyThumbs for key " + navMapEntry.getKey() + " does not have an array element child"));
        }
    }

    private void processLargerThumbs(NavMapEntry navMapEntry, Element element) {
        if (element.getName().equals("array")) {
            List stringChildrenElements = element.getChildren("string");
            for (Element stringChildElement : stringChildrenElements) {
                File file;
                String relativePath = stringChildElement.getTextTrim();
                navMapEntry.largerThumbs.add(relativePath);
                if (!this.validateContents || (file = new File(this.baseDir.getParentFile(), relativePath)).exists()) continue;
                this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "largerThumbs file for key " + navMapEntry.getKey() + " does not exist: " + relativePath));
            }
        } else if (this.validateContents) {
            this.errorList.add(new EPUBInfoError(EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY, this.extensionsFileName, "largerThumbs for key " + navMapEntry.getKey() + " does not have an array element child"));
        }
    }

    private void computeSummaryAttributes() {
        for (NavMapEntry navMapEntry : this.navMap.values()) {
            if (navMapEntry.getNumberOfPages() != null) {
                this.numberOfPagesTotal += (long)navMapEntry.getNumberOfPages().intValue();
            }
            if (navMapEntry.getNumberOfTOCHeadings() == null) continue;
            this.numberOfTOCHeadingsTotal += (long)navMapEntry.getNumberOfTOCHeadings().intValue();
        }
    }

    private static String getElementName(Element element) {
        return element == null ? null : element.getName();
    }

    private static Boolean getBooleanFromElementName(Element element) {
        String elementNameString = NCXExtensions.getElementName(element);
        return elementNameString == null ? null : Boolean.valueOf(elementNameString);
    }

    private static String getElementTextTrim(Element element) {
        return element == null ? null : element.getTextTrim();
    }

    private static Integer getIntegerFromElementText(Element element) {
        String elementText = NCXExtensions.getElementTextTrim(element);
        return elementText == null ? null : Integer.valueOf(elementText);
    }

    private static LinkedHashMap<String, Element> convertToDictionary(Element element) {
        LinkedHashMap<String, Element> dictionary = new LinkedHashMap<String, Element>();
        List childrenElements = element.getChildren();
        for (int i = 0; i < childrenElements.size(); ++i) {
            String keyTagContent;
            Element childElement = (Element)childrenElements.get(i);
            String tag = childElement.getName();
            String string = keyTagContent = tag.equals("key") ? childElement.getTextTrim() : null;
            if (keyTagContent == null || ++i >= childrenElements.size()) continue;
            Element nextElement = (Element)childrenElements.get(i);
            dictionary.put(keyTagContent, nextElement);
        }
        return dictionary;
    }

    public List<EPUBInfoError> getErrors() {
        return this.errorList;
    }

    public Long getNumberOfPagesTotal() {
        return this.numberOfPagesTotal;
    }

    public Long getNumberOfTOCHeadingsTotal() {
        return this.numberOfTOCHeadingsTotal;
    }

    public String getIbooksCurrentVersion() {
        return this.ibooksCurrentVersion;
    }

    public String getIbooksRequiredVersion() {
        return this.ibooksRequiredVersion;
    }

    public String getTocHeaderImage() {
        return this.tocHeaderImage;
    }

    public Boolean getShowPageNumbers() {
        return this.showPageNumbers;
    }

    public LinkedHashMap<String, NavMapEntry> getNavMap() {
        return this.navMap;
    }

    public static class NavMapEntry {
        private final String key;
        private String sectionIdentifier;
        private String displayNumberFormat;
        private Integer displayStartPageNumber;
        private Boolean includeInTOC;
        private Integer numberOfPages;
        private Integer numberOfTOCHeadings;
        private List<String> tinyThumbs = new ArrayList<String>();
        private List<String> largerThumbs = new ArrayList<String>();

        public NavMapEntry(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getSectionIdentifier() {
            return this.sectionIdentifier;
        }

        public String getDisplayNumberFormat() {
            return this.displayNumberFormat;
        }

        public Integer getDisplayStartPageNumber() {
            return this.displayStartPageNumber;
        }

        public Boolean getIncludeInTOC() {
            return this.includeInTOC;
        }

        public Integer getNumberOfPages() {
            return this.numberOfPages;
        }

        public Integer getNumberOfTOCHeadings() {
            return this.numberOfTOCHeadings;
        }

        public List<String> getTinyThumbs() {
            return this.tinyThumbs;
        }

        public List<String> getLargerThumbs() {
            return this.largerThumbs;
        }
    }
}

