/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.NCXNavPoint;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavPoint;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class NCXDocument
implements NavDocument {
    public static final String NCX_MIME_TYPE = "application/x-dtbncx+xml";
    private Document document;
    private XPathFactory xpathFactory;
    public static final String NCX_EXTENSION = ".ncx";

    public NCXDocument(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        String uri = namespace.getURI();
        this.xpathFactory = new XPathFactory();
        this.xpathFactory.addNamespace("ncx", uri);
    }

    public String getFirstChapterNavPointSrc() {
        List<NavPoint> navPoints = this.getNavPoints();
        for (NavPoint point : navPoints) {
            String classAttribute = ((NCXNavPoint)point).getClassAttribute();
            if (!"chapter".equalsIgnoreCase(classAttribute)) continue;
            return point.getURI();
        }
        return null;
    }

    @Override
    public List<NavPoint> getNavPoints() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//ncx:navPoint";
        XPath xpath = this.xpathFactory.createXPath("//ncx:navPoint");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new NCXNavPoint((Element)navpointObject));
        }
        return result;
    }

    @Override
    public List<NavPoint> getAllPoints() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//ncx:navPoint|//ncx:navTarget|//ncx:pageTarget";
        XPath xpath = this.xpathFactory.createXPath("//ncx:navPoint|//ncx:navTarget|//ncx:pageTarget");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new NCXNavPoint((Element)navpointObject));
        }
        return result;
    }

    private List<NCXNavPoint> getNavTargets() {
        ArrayList<NCXNavPoint> result = new ArrayList<NCXNavPoint>();
        String xpathString = "//ncx:navTarget";
        XPath xpath = this.xpathFactory.createXPath("//ncx:navTarget");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new NCXNavPoint((Element)navpointObject));
        }
        return result;
    }

    @Override
    public List<NavPoint> getPageList() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//ncx:pageTarget";
        XPath xpath = this.xpathFactory.createXPath("//ncx:pageTarget");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new NCXNavPoint((Element)navpointObject));
        }
        return result;
    }

    private Element getNavPointElementForSrc(String src) {
        String xpathString = "//ncx:navPoint[ncx:content[@src='" + XMLUtilities.xpathEscape(src) + "']]";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        return (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
    }

    @Override
    public void deleteNavPointForSrc(String src) {
        Element navPointElement = this.getNavPointElementForSrc(src);
        if (navPointElement == null) {
            return;
        }
        navPointElement.detach();
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public String getNXCAdditions() {
        String xpathString = "//ncx:meta[@name='ibooks:ncxAdditions']";
        XPath xpath = this.xpathFactory.createXPath("//ncx:meta[@name='ibooks:ncxAdditions']");
        Element e = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (e == null) {
            return null;
        }
        return e.getAttributeValue("content");
    }
}

