/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.AnchorNavPoint;
import com.apple.itunes.epubtoolkit.model.EPUBGuide;
import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavPoint;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class HtmlNavDocument
implements NavDocument,
EPUBGuide {
    public static final String NAV_MIME_TYPE = "application/xhtml+xml";
    private static final String epubNamespace = "http://www.idpf.org/2007/ops";
    private Document document;
    private XPathFactory xpathFactory;
    private static final String NAV_EXTENSION = ".xhtml";

    public HtmlNavDocument(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace("epub");
        String uri = namespace == null ? epubNamespace : namespace.getURI();
        this.xpathFactory = new XPathFactory();
        this.xpathFactory.addNamespace("epub", uri);
        namespace = rootElement.getNamespace();
        uri = namespace.getURI();
        this.xpathFactory.addNamespace("xhtml", uri);
    }

    @Override
    public List<NavPoint> getNavPoints() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//xhtml:nav[@epub:type='toc']//xhtml:a";
        XPath xpath = this.xpathFactory.createXPath("//xhtml:nav[@epub:type='toc']//xhtml:a");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new AnchorNavPoint((Element)navpointObject));
        }
        return result;
    }

    @Override
    public void deleteNavPointForSrc(String src) {
        List<Element> navPointElements = this.getNavPointElementForSrc(src);
        if (navPointElements == null) {
            return;
        }
        for (Element navPointElement : navPointElements) {
            navPointElement.detach();
        }
    }

    private List<Element> getNavPointElementForSrc(String src) {
        String xpathString = "//xhtml:nav//xhtml:a[@href='" + XMLUtilities.xpathEscape(src) + "'] | //xhtml:img[@src='" + XMLUtilities.xpathEscape(src) + "']";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        return XPathFactory.selectNodes(this.getDocument(), xpath);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public List<NavPoint> getPageList() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//xhtml:nav[@epub:type='page-list']//xhtml:a";
        XPath xpath = this.xpathFactory.createXPath("//xhtml:nav[@epub:type='page-list']//xhtml:a");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new AnchorNavPoint((Element)navpointObject));
        }
        return result;
    }

    public List<NavPoint> getLandmarks() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//xhtml:nav[@epub:type='landmarks']//xhtml:a";
        XPath xpath = this.xpathFactory.createXPath("//xhtml:nav[@epub:type='landmarks']//xhtml:a");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new AnchorNavPoint((Element)navpointObject));
        }
        return result;
    }

    public void addLandmark(String type, String text, String uri) {
        Element ol;
        String xpathString = "//xhtml:nav[@epub:type='landmarks']";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        Element landmarks = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        Namespace rootNS = this.document.getRootElement().getNamespace();
        if (landmarks == null) {
            xpathString = "//xhtml:nav";
            xpath = this.xpathFactory.createXPath(xpathString);
            List navs = XPathFactory.selectNodes(this.getDocument(), xpath);
            if (navs.isEmpty()) {
                return;
            }
            Element navParent = ((Element)navs.get(0)).getParentElement();
            Namespace epubNS = Namespace.getNamespace((String)"epub", (String)epubNamespace);
            landmarks = new Element("nav", rootNS);
            landmarks.addNamespaceDeclaration(epubNS);
            landmarks.setAttribute("type", "landmarks", epubNS);
            navParent.addContent((Content)landmarks);
        }
        if ((ol = landmarks.getChild("ol")) == null) {
            ol = new Element("ol", rootNS);
            landmarks.addContent((Content)ol);
        }
        Element li = new Element("li", rootNS);
        ol.addContent((Content)li);
        Element a = new Element("a", rootNS);
        li.addContent((Content)a);
        a.setAttribute("href", uri);
        a.setAttribute("type", type, landmarks.getNamespace("epub"));
        a.setText(text);
    }

    @Override
    public List<NavPoint> getAllPoints() {
        ArrayList<NavPoint> result = new ArrayList<NavPoint>();
        String xpathString = "//xhtml:a";
        XPath xpath = this.xpathFactory.createXPath("//xhtml:a");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new AnchorNavPoint((Element)navpointObject));
        }
        return result;
    }

    @Override
    public GuideItem getGuideItem(String href) {
        String xpathString = "//xhtml:nav[@epub:type='landmarks']//xhtml:a[@href='" + XMLUtilities.xpathEscape(href) + "']";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        Element e = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (e == null) {
            return null;
        }
        return new AnchorNavPoint(e);
    }

    @Override
    public GuideItem getGuideItemByType(String type) {
        String xpathString = "//xhtml:nav[@epub:type='landmarks']//xhtml:a[@epub:type='" + XMLUtilities.xpathEscape(type) + "']";
        XPath xpath = this.xpathFactory.createXPath(xpathString);
        Element e = (Element)XPathFactory.selectSingleNode(this.getDocument(), xpath);
        if (e == null) {
            return null;
        }
        return new AnchorNavPoint(e);
    }

    @Override
    public GuideItem getBackCoverGuideItem() {
        return this.getGuideItemByType("other.back-cover");
    }

    @Override
    public List<String> getGuideURIs() {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = this.xpathFactory.createXPath("//xhtml:nav[@epub:type='landmarks']//xhtml:a");
        List spineItems = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object object : spineItems) {
            Element item = (Element)object;
            result.add(item.getAttributeValue("href"));
        }
        return result;
    }

    @Override
    public List<GuideItem> getGuideItems() {
        ArrayList<GuideItem> result = new ArrayList<GuideItem>();
        String xpathString = "//xhtml:nav[@epub:type='landmarks']//xhtml:a";
        XPath xpath = this.xpathFactory.createXPath("//xhtml:nav[@epub:type='landmarks']//xhtml:a");
        List navpointElements = XPathFactory.selectNodes(this.getDocument(), xpath);
        for (Object navpointObject : navpointElements) {
            result.add(new AnchorNavPoint((Element)navpointObject));
        }
        return result;
    }

    @Override
    public GuideItem getCoverPageGuideItem() {
        return this.getGuideItemByType("cover");
    }
}

