/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.xpath.jaxen.JDOMXPath;

public class EncryptionXml {
    private static final String[] caseSensitiveUris = new String[]{"//@URI", "//@Uri", "//@uri"};
    private Document document;
    private Map<String, String> namespaceMap;
    private List<JDOMXPath> xpaths;
    private List<String> results;

    public EncryptionXml(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        this.namespaceMap = new HashMap<String, String>();
        String uri = namespace.getURI();
        this.namespaceMap.put("nns", uri);
        this.namespaceMap.put("enc", "http://www.w3.org/2001/04/xmlenc#");
        this.namespaceMap.put("deenc", "http://ns.adobe.com/digitaleditions/enc");
    }

    public List<String> getURIs() throws JaxenException, JDOMException {
        this.buildXPaths();
        this.buildResults();
        return this.results;
    }

    private void buildXPaths() throws JaxenException, JDOMException {
        this.xpaths = new ArrayList<JDOMXPath>();
        for (String uri : caseSensitiveUris) {
            JDOMXPath xpath = new JDOMXPath(uri);
            for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
                xpath.addNamespace(Namespace.getNamespace((String)entry.getKey(), (String)entry.getValue()));
            }
            this.xpaths.add(xpath);
        }
    }

    private void buildResults() throws JaxenException, JDOMException {
        this.results = new ArrayList<String>();
        for (JDOMXPath xpath : this.xpaths) {
            List uris = xpath.selectNodes((Object)this.getDocument());
            this.addUrisToResult(uris);
        }
    }

    private void addUrisToResult(List uris) {
        for (Object object : uris) {
            Attribute att = (Attribute)object;
            this.results.add(att.getValue());
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

