/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfoImpl;
import com.apple.itunes.epubtoolkit.EPUBPreviewCutterThreshold;
import com.apple.itunes.epubtoolkit.XHTMLReferenceFinder;
import com.apple.itunes.epubtoolkit.XHTMLReferenceScrubber;
import com.apple.itunes.epubtoolkit.XHTMLReferenceScrubberSAXHandler;
import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.cfi.CFISyntaxException;
import com.apple.itunes.epubtoolkit.model.AppleDisplayOptionsDocument;
import com.apple.itunes.epubtoolkit.model.ApplePrintableDocument;
import com.apple.itunes.epubtoolkit.model.ContainerDocument;
import com.apple.itunes.epubtoolkit.model.ContainerRootFile;
import com.apple.itunes.epubtoolkit.model.EPUBGuide;
import com.apple.itunes.epubtoolkit.model.EncryptionXml;
import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.HtmlNavDocument;
import com.apple.itunes.epubtoolkit.model.NCXDocument;
import com.apple.itunes.epubtoolkit.model.NCXExtensions;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavDocumentBuilder;
import com.apple.itunes.epubtoolkit.model.NavPoint;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.OPFSpineItem;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Document;

public class EPUBModel {
    private static final Logger log = Logger.getLogger(EPUBModel.class);
    private static final String PRINTABLE_XSD = "http://apple.com/ibooks/printable";
    private static final String PRINTABLE_XSD_FILE = "com/apple/itunes/epubtoolkit/resources/printable.xsd";
    private File directory;
    private OPFDocument opf;
    private EncryptionXml enc;
    private Map<NavDocumentBuilder.NavType, NavDocument> navs;
    private AppleDisplayOptionsDocument ado;
    private ApplePrintableDocument applePrintable;
    private EPUBGuide guide;

    public EPUBModel(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter directory cannot be null.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Parameter directory does not represent a directory.");
        }
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public EPUBGuide getGuide() throws EPUBException {
        if (this.guide == null) {
            Map<NavDocumentBuilder.NavType, NavDocument> navs = this.getNavs();
            this.guide = navs.get((Object)NavDocumentBuilder.NavType.XHTML) != null ? (HtmlNavDocument)navs.get((Object)NavDocumentBuilder.NavType.XHTML) : this.getOPF().getGuide();
        }
        return this.guide;
    }

    public OPFDocument getOPF() throws EPUBException {
        if (this.opf == null) {
            Document opfDoc = this.getOPFDocument();
            try {
                this.opf = new OPFDocument(opfDoc);
            }
            catch (Exception e) {
                throw new EPUBException("Error in manifest file '" + this.getOPFFile().getName() + "':  " + e.getMessage(), e);
            }
        }
        return this.opf;
    }

    public EncryptionXml getEncryptionXml() throws EPUBException {
        Document encryptionDocument;
        if (this.enc == null && (encryptionDocument = this.getEncryptionXmlDocument()) != null) {
            this.enc = new EncryptionXml(encryptionDocument);
        }
        return this.enc;
    }

    public AppleDisplayOptionsDocument getADO() throws EPUBException {
        Document adoDoc;
        if (this.ado == null && (adoDoc = this.getADODocument()) != null) {
            this.ado = new AppleDisplayOptionsDocument(adoDoc);
        }
        return this.ado;
    }

    public ApplePrintableDocument getApplePrintable() throws EPUBException {
        Document applePrintableDoc;
        if (this.applePrintable == null && (applePrintableDoc = this.getApplePrintableDocument()) != null) {
            this.applePrintable = new ApplePrintableDocument(applePrintableDoc);
        }
        return this.applePrintable;
    }

    public NavDocument getPrimaryNav() throws EPUBException {
        Map<NavDocumentBuilder.NavType, NavDocument> navs = this.getNavs();
        if (navs == null || navs.isEmpty()) {
            return null;
        }
        if (navs.get((Object)NavDocumentBuilder.NavType.XHTML) != null) {
            return navs.get((Object)NavDocumentBuilder.NavType.XHTML);
        }
        return navs.get((Object)NavDocumentBuilder.NavType.NCX);
    }

    public Map<NavDocumentBuilder.NavType, NavDocument> getNavs() throws EPUBException {
        if (this.navs == null) {
            Map<NavDocumentBuilder.NavType, Document> documents = this.getNavDocuments();
            if (documents == null || documents.isEmpty()) {
                return null;
            }
            this.navs = new HashMap<NavDocumentBuilder.NavType, NavDocument>();
            for (NavDocumentBuilder.NavType key : documents.keySet()) {
                this.navs.put(key, NavDocumentBuilder.getNav(documents.get((Object)key)));
            }
        }
        return this.navs;
    }

    protected Document getOPFDocument() throws EPUBException {
        Document document;
        File rootFile = this.getOPFFile();
        try {
            document = XMLUtilities.createDocument(rootFile);
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse opf file: " + rootFile.getName(), e);
        }
        return document;
    }

    protected Document getEncryptionXmlDocument() throws EPUBException {
        Document document;
        File rootFile = this.getEncryptionXmlFile();
        if (rootFile == null || !rootFile.exists()) {
            return null;
        }
        try {
            document = XMLUtilities.createDocument(rootFile);
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse encryption xml file: " + rootFile.getName(), e);
        }
        return document;
    }

    protected Document getADODocument() throws EPUBException {
        Document document;
        File rootFile = this.getADOFile();
        if (rootFile == null) {
            return null;
        }
        try {
            document = XMLUtilities.createDocument(rootFile);
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse apple display options file: " + rootFile.getName(), e);
        }
        return document;
    }

    protected Document getApplePrintableDocument() throws EPUBException {
        Document document;
        File rootFile = this.getApplePrintableFile();
        if (rootFile == null) {
            return null;
        }
        try {
            document = XMLUtilities.createDocument(rootFile, "http://apple.com/ibooks/printable " + EPUBModel.class.getClassLoader().getResource(PRINTABLE_XSD_FILE));
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse com.apple.printable file: " + rootFile.getName() + " " + e.getMessage(), e);
        }
        return document;
    }

    protected Map<NavDocumentBuilder.NavType, Document> getNavDocuments() throws EPUBException {
        Map<NavDocumentBuilder.NavType, File> navFiles = this.getNavFiles();
        if (navFiles == null) {
            return null;
        }
        HashMap<NavDocumentBuilder.NavType, Document> documents = new HashMap<NavDocumentBuilder.NavType, Document>();
        for (NavDocumentBuilder.NavType key : navFiles.keySet()) {
            try {
                Document document = XMLUtilities.createDocument(navFiles.get((Object)key));
                documents.put(key, document);
            }
            catch (Exception e) {
                throw new EPUBException("Unable to parse nav file: " + navFiles.get((Object)key).getName(), e);
            }
        }
        return documents;
    }

    public Map<NavDocumentBuilder.NavType, File> getNavFiles() throws EPUBException {
        Map<NavDocumentBuilder.NavType, OPFManifestItem> navItems = this.getNavManifestItems();
        File opfFile = this.getOPFFile();
        File baseDir = opfFile.getParentFile();
        HashMap<NavDocumentBuilder.NavType, File> navFiles = new HashMap<NavDocumentBuilder.NavType, File>();
        for (Map.Entry<NavDocumentBuilder.NavType, OPFManifestItem> entry : navItems.entrySet()) {
            OPFManifestItem manifestItem = entry.getValue();
            String href = manifestItem.getHref();
            if (href == null) {
                throw new EPUBException("No href found for manifest item with toc id: " + manifestItem.getId());
            }
            navFiles.put(entry.getKey(), new File(baseDir, FileUtilities.decodeURIPath(href)));
        }
        if (navFiles.isEmpty()) {
            throw new EPUBException("No Navigation files within the epub.");
        }
        return navFiles;
    }

    public Map<NavDocumentBuilder.NavType, OPFManifestItem> getNavManifestItems() throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        HashMap<NavDocumentBuilder.NavType, OPFManifestItem> navItems = new HashMap<NavDocumentBuilder.NavType, OPFManifestItem>();
        for (NavDocumentBuilder.NavType navType : NavDocumentBuilder.NavType.values()) {
            OPFManifestItem manifestItem = opfDoc.getTableOfConentsItem(navType);
            if (manifestItem == null) continue;
            navItems.put(navType, manifestItem);
        }
        if (navItems.isEmpty()) {
            throw new EPUBException("No Navigation files within the epub.");
        }
        return navItems;
    }

    public File getOPFFile() throws EPUBException {
        ContainerRootFile rootFileItem = this.getOPFFileItem();
        String fullPath = FileUtilities.decodeURIPath(rootFileItem.getFullPath());
        File rootFile = new File(this.directory, fullPath);
        return rootFile;
    }

    public File getManifestItemFile(OPFManifestItem manifestItem) throws EPUBException {
        String relativePath = FileUtilities.decodeURIPath(manifestItem.getHref());
        return this.getFileForPath(relativePath);
    }

    public File getManifestItemFile(String manifestItemHref) throws EPUBException {
        String relativePath = FileUtilities.decodeURIPath(manifestItemHref);
        return this.getFileForPath(relativePath);
    }

    public File getManifestItemFile(CFI cfi) throws EPUBException {
        if (cfi == null) {
            throw new IllegalArgumentException("Parameter cfi cannot be null.");
        }
        return this.getManifestItemFile(this.opf.getManifestItem(cfi));
    }

    protected File getFileForPath(String relativePath) throws EPUBException {
        File rootFile = this.getOPFFile();
        File baseDir = rootFile.getParentFile();
        return new File(baseDir, relativePath);
    }

    public String getMimeType() throws EPUBException {
        File mimeTypeFile = this.getMimeTypeFile();
        if (mimeTypeFile == null || !mimeTypeFile.exists()) {
            return null;
        }
        InputStreamReader isr = null;
        BufferedReader in = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(mimeTypeFile), "UTF-8");
            in = new BufferedReader(isr);
            String string = in.readLine();
            return string;
        }
        catch (IOException e) {
            throw new EPUBException("Unable to read from: " + mimeTypeFile, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close BufferedReader for mimetype file", (Throwable)e);
                }
            } else if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close InputStreamReader for mimetype file", (Throwable)e);
                }
            }
        }
    }

    public boolean isEncryptionXmlPresent() {
        File file = this.getEncryptionXmlFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public boolean isSignaturesXmlPresent() {
        File file = this.getSignaturesXmlFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    protected ContainerRootFile getOPFFileItem() throws EPUBException {
        ContainerDocument container = this.getContainer();
        List<ContainerRootFile> rootFiles = container.getRootFiles();
        if (rootFiles == null || rootFiles.size() < 1) {
            return null;
        }
        return rootFiles.get(0);
    }

    protected File getContainerFile() {
        File result = new File(this.directory, "META-INF/container.xml");
        return result;
    }

    protected File getApplePrintableFile() {
        File result = new File(this.directory, "META-INF/com.apple.printable.xml");
        if (!result.exists()) {
            return null;
        }
        return result;
    }

    protected File getADOFile() {
        File result = new File(this.directory, "META-INF/com.apple.ibooks.display-options.xml");
        if (!result.exists()) {
            return null;
        }
        return result;
    }

    protected File getMimeTypeFile() {
        File result = new File(this.directory, "mimetype");
        return result;
    }

    protected File getEncryptionXmlFile() {
        File result = new File(this.directory, "META-INF/encryption.xml");
        return result;
    }

    protected File getSignaturesXmlFile() {
        File result = new File(this.directory, "META-INF/signatures.xml");
        return result;
    }

    public ContainerDocument getContainer() throws EPUBException {
        Document document;
        File containerFile = this.getContainerFile();
        try {
            document = XMLUtilities.createDocument(containerFile);
        }
        catch (Exception e) {
            throw new EPUBException("Unable to parse container file: " + containerFile.getName(), e);
        }
        return new ContainerDocument(document);
    }

    public void deleteManifestItem(String id, boolean updateNav) throws EPUBException {
        Map<NavDocumentBuilder.NavType, NavDocument> navDocs;
        OPFDocument opfDoc = this.getOPF();
        OPFManifestItem item = opfDoc.getManifestItem(id);
        if (item == null) {
            return;
        }
        String itemPath = item.getHref();
        if (itemPath == null) {
            throw new EPUBException("No href for manifest item with id: " + id);
        }
        File rootFile = this.getOPFFile();
        File rootDir = rootFile.getParentFile();
        File itemFile = new File(rootDir, FileUtilities.decodeURIPath(itemPath));
        itemFile.delete();
        opfDoc.deleteManifestItem(id);
        if (updateNav && (navDocs = this.getNavs()) != null) {
            for (NavDocument doc : navDocs.values()) {
                doc.deleteNavPointForSrc(itemPath);
            }
        }
    }

    public void saveChanges() throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        File opfFile = this.getOPFFile();
        try {
            FileUtilities.write(opfFile, opfDoc.getDocument());
        }
        catch (IOException e) {
            throw new EPUBException("Unable to save opf file to disk.", e);
        }
        Map<NavDocumentBuilder.NavType, NavDocument> navDocs = this.getNavs();
        Map<NavDocumentBuilder.NavType, File> navFiles = this.getNavFiles();
        if (navDocs == null || navFiles == null) {
            return;
        }
        for (NavDocumentBuilder.NavType type : navDocs.keySet()) {
            File navFile = navFiles.get((Object)type);
            NavDocument navDoc = navDocs.get((Object)type);
            if (navFile == null) continue;
            try {
                FileUtilities.write(navFile, navDoc.getDocument());
            }
            catch (IOException e) {
                throw new EPUBException("Unable to save nav file to disk.", e);
            }
        }
    }

    public void cleanup(EPUBPreviewCutterThreshold threshold, List<String> anchors) throws EPUBException {
        this.cleanup(threshold, anchors, false, null);
    }

    public void cleanup(EPUBPreviewCutterThreshold threshold, List<String> anchors, boolean deleteUnmanifestedFiles, String excludeUnmanifestedFilesRE) throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        opfDoc.cleanup();
        this.removeUnreferencedFiles();
        this.cleanupReferences(threshold, anchors);
        this.cleanupEncoding();
        if (deleteUnmanifestedFiles) {
            this.deleteUnmanifestedFiles(excludeUnmanifestedFilesRE);
        }
    }

    private void removeFallbacks() throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        List<OPFManifestItem> manifestItems = opfDoc.getLocalManifestItems();
        for (OPFManifestItem item : manifestItems) {
            item.removeFallback();
        }
    }

    private void cleanupEncoding() throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        File opfFile = this.getOPFFile();
        File root = opfFile.getParentFile();
        List<OPFManifestItem> manifestItems = opfDoc.getLocalManifestItems();
        for (OPFManifestItem manifestItem : manifestItems) {
            if (!manifestItem.isXHTML()) continue;
            String manifestItemPath = FileUtilities.decodeURIPath(manifestItem.getHref());
            File manifestFile = new File(root, manifestItemPath);
            try {
                if (!FileUtilities.containsRegex(manifestFile, "(?i)<[?]xml[^>]*encoding=\"(?!utf-8)[^\">]*\"[^>]*[?]>", 1)) continue;
                File manifestFileTemp = new File(root, manifestItemPath + "." + System.currentTimeMillis() + ".tmp");
                FileUtilities.writeReplace(manifestFile, manifestFileTemp, "(?i)<[?]xml[^>]*encoding=\"(?!utf-8)[^\">]*\"[^>]*[?]>", "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                manifestFile.delete();
                boolean renameToSucceeded = manifestFileTemp.renameTo(manifestFile);
                if (renameToSucceeded) continue;
                FileUtilities.writeReplace(manifestFileTemp, manifestFile, null, null);
                manifestFileTemp.delete();
            }
            catch (IOException e) {
                throw new EPUBException("Unable to check xml encoding for " + manifestItem.getHref(), e);
            }
        }
    }

    protected void cleanupReferences(EPUBPreviewCutterThreshold threshold, List<String> anchors) throws EPUBException {
        OPFManifestItem item;
        OPFDocument opfDoc = this.getOPF();
        if (opfDoc.getSpineElement() == null) {
            throw new EPUBException("OPF document does not contain a spine.");
        }
        File root = this.getOPFFile().getParentFile();
        List<OPFManifestItem> manifestItems = opfDoc.getLocalManifestItems();
        File thresholdFile = null;
        String id = null;
        if (threshold != null) {
            id = threshold.getAnalysis().getId();
        }
        String thresholdHref = "";
        if (id != null && (item = opfDoc.getManifestItem(id)) != null) {
            thresholdHref = item.getHref();
            String thresholdPath = FileUtilities.decodeURIPath(thresholdHref);
            thresholdFile = new File(thresholdPath);
        }
        for (OPFManifestItem manifestItem : manifestItems) {
            String href = manifestItem.getHref();
            if (href == null) continue;
            manifestItem.setHref(FileUtilities.cleanURL(href));
            String manifestItemPath = FileUtilities.decodeURIPath(href);
            File itemFile = new File(root, manifestItemPath);
            if (manifestItem.isCSS()) {
                this.cleanupCSSReferences(itemFile);
                continue;
            }
            if (!manifestItem.isXHTML() || manifestItem.getId().equals(opfDoc.getTableOfConentsId())) continue;
            File scrubFile = new File(manifestItemPath);
            String scrubValue = null;
            if (anchors != null) {
                scrubValue = FileUtilities.createScrubValue(thresholdFile, scrubFile, anchors.get(0), thresholdHref);
            }
            XHTMLReferenceScrubber scrubber = new XHTMLReferenceScrubber(root, itemFile, scrubValue, threshold, this);
            scrubber.scrub();
        }
        Map<NavDocumentBuilder.NavType, NavDocument> navDocuments = this.getNavs();
        Map<NavDocumentBuilder.NavType, File> navFiles = this.getNavFiles();
        if (navDocuments == null) {
            throw new EPUBException("Nav Document is not present or not referenced properly.");
        }
        for (NavDocumentBuilder.NavType type : navDocuments.keySet()) {
            NavDocument navDocument = navDocuments.get((Object)type);
            List<NavPoint> allPoints = navDocument.getAllPoints();
            int anchorIndex = 0;
            HashMap<String, String> originalSrcValues = new HashMap<String, String>();
            File navFile = navFiles.get((Object)type);
            for (NavPoint point : allPoints) {
                boolean isAvailable;
                String src = point.getURI();
                if (src == null) continue;
                if (CFI.isCFI(src)) {
                    File file = null;
                    try {
                        file = this.getManifestItemFile(new CFI(src));
                    }
                    catch (CFISyntaxException e) {
                        // empty catch block
                    }
                    isAvailable = file != null && file.exists();
                } else {
                    if (opfDoc.getManifestItemByHref(src) == null && opfDoc.getManifestItemByHref(src.trim()) != null) {
                        src = src.trim();
                    }
                    isAvailable = XHTMLReferenceScrubberSAXHandler.isResourceAvailable(root, threshold, navFile, src);
                }
                point.setURI(FileUtilities.cleanURL(src));
                if (isAvailable) continue;
                String scrubValue = (String)originalSrcValues.get(src);
                if (scrubValue == null && anchors != null) {
                    String scrubAnchor = anchors.get(anchorIndex);
                    String navManifestItemPath = navFile.getPath().substring(this.getOPFFile().getParent().length() + 1);
                    File scrubFile = new File(navManifestItemPath);
                    scrubValue = FileUtilities.createScrubValue(thresholdFile, scrubFile, scrubAnchor, thresholdHref);
                    originalSrcValues.put(src, scrubValue);
                    ++anchorIndex;
                }
                point.setURI(scrubValue);
            }
        }
        List<GuideItem> items = opfDoc.getGuide().getGuideItems();
        String scrubValue = null;
        if (anchors != null) {
            String scrubAnchor = anchors.get(0);
            scrubValue = FileUtilities.createScrubValue(thresholdFile, null, scrubAnchor, thresholdHref);
        }
        for (GuideItem item2 : items) {
            String src = item2.getURI();
            if (src == null) continue;
            boolean isAvailable = XHTMLReferenceScrubberSAXHandler.isResourceAvailable(root, threshold, this.getOPFFile(), src);
            item2.setURI(FileUtilities.cleanURL(src));
            if (isAvailable || scrubValue == null) continue;
            item2.setURI(scrubValue);
        }
    }

    private void cleanupCSSReferences(File itemFile) throws EPUBException {
        try {
            String css = FileUtilities.readFileAsString(itemFile);
            Pattern p1 = Pattern.compile("(?i)([@]import url[(])([^)]*)[)]");
            Matcher m1 = p1.matcher(css);
            StringBuffer sb = new StringBuffer();
            while (m1.find()) {
                m1.appendReplacement(sb, m1.group(1) + m1.group(2).replaceAll(" ", "%20") + ")");
            }
            m1.appendTail(sb);
            FileUtilities.write(itemFile, sb.toString(), "UTF-8");
        }
        catch (IOException e) {
            throw new EPUBException("Unable to scan " + itemFile.getName(), e);
        }
    }

    protected void removeUnreferencedFiles() throws EPUBException {
        OPFDocument opfDoc = this.getOPF();
        Map<NavDocumentBuilder.NavType, File> navFiles = this.getNavFiles();
        File root = this.getOPFFile().getParentFile();
        List<OPFManifestItem> manifestItems = opfDoc.getLocalManifestItems();
        ArrayList<OPFManifestItem> fallbacksToDelete = new ArrayList<OPFManifestItem>();
        HashSet<String> manifestIdsToDelete = new HashSet<String>();
        HashSet<String> manifestIdsToKeep = new HashSet<String>();
        OPFManifestItem coverItem = opfDoc.getCoverItem();
        for (OPFManifestItem removalCandidate : manifestItems) {
            if (coverItem != null && coverItem.equals(removalCandidate) || removalCandidate.getElement().getAttributeValue("properties") != null && removalCandidate.getElement().getAttributeValue("properties").indexOf("cover-image") >= 0 || opfDoc.getSpineItem(removalCandidate.getId()) != null && !removalCandidate.isFallback() || opfDoc.getGuide().getGuideItem(removalCandidate.getHref()) != null) continue;
            File removalCandidateFile = new File(root, FileUtilities.decodeURIPath(removalCandidate.getHref()));
            if (navFiles.values().contains(removalCandidateFile)) continue;
            if (!removalCandidateFile.exists()) {
                throw new IllegalStateException("Item file has already been deleted: " + removalCandidateFile.getName());
            }
            boolean isReferencedByAnotherManifestItem = false;
            for (OPFManifestItem possibleReference : manifestItems) {
                File possibleReferenceFile;
                if (possibleReference.equals(removalCandidate) || !(possibleReferenceFile = new File(root, FileUtilities.decodeURIPath(possibleReference.getHref()))).exists()) continue;
                boolean grepStyleFallback = false;
                if (possibleReference.isXHTML() || possibleReference.isSVG()) {
                    try {
                        XHTMLReferenceFinder finder = new XHTMLReferenceFinder(possibleReferenceFile, removalCandidateFile.getName(), removalCandidate, true);
                        isReferencedByAnotherManifestItem |= finder.contains();
                    }
                    catch (EPUBException e) {
                        grepStyleFallback = true;
                    }
                }
                if (!possibleReference.isText() && !possibleReference.isCSS() && !grepStyleFallback) continue;
                try {
                    boolean contains = FileUtilities.containsText(possibleReferenceFile, removalCandidateFile.getName());
                    isReferencedByAnotherManifestItem |= contains;
                }
                catch (IOException e) {
                    throw new EPUBException("Unable to grep for " + removalCandidateFile.getName() + " in: " + possibleReferenceFile.getName(), e);
                }
            }
            if (!isReferencedByAnotherManifestItem) {
                if (removalCandidate.isFallback()) {
                    fallbacksToDelete.add(removalCandidate);
                    continue;
                }
                manifestIdsToDelete.add(removalCandidate.getId());
                continue;
            }
            manifestIdsToKeep.add(removalCandidate.getId());
        }
        for (String id : manifestIdsToDelete) {
            if (manifestIdsToKeep.contains(id)) continue;
            this.deleteManifestItem(id, true);
        }
        while (!fallbacksToDelete.isEmpty()) {
            OPFManifestItem item = (OPFManifestItem)fallbacksToDelete.remove(fallbacksToDelete.size() - 1);
            OPFManifestItem parent = item.getFallbackParent();
            if (parent == null) {
                if (manifestIdsToKeep.contains(item.getId())) continue;
                this.deleteManifestItem(item.getId(), false);
                continue;
            }
            if (item.getFallbackItem() != null && EPUBModel.hasCircularFallback(item)) {
                throw new EPUBException("Circular fallback reference detected while preview cutting.  Reference found in file " + item.getHref());
            }
            if (!fallbacksToDelete.contains(parent)) continue;
            fallbacksToDelete.add(0, item);
        }
    }

    public static boolean hasCircularFallback(OPFManifestItem item) {
        OPFManifestItem fallback1 = item.getFallbackItem();
        OPFManifestItem fallback2 = null;
        if (fallback1 != null) {
            fallback2 = fallback1.getFallbackItem();
        }
        while (fallback2 != null) {
            if (fallback1.equals(fallback2)) {
                return true;
            }
            fallback1 = fallback1.getFallbackItem();
            if ((fallback2 = fallback2.getFallbackItem()) == null) continue;
            fallback2 = fallback2.getFallbackItem();
        }
        return false;
    }

    public void deleteUnmanifestedFiles(String excludeUnmanifestedFilesRE) throws EPUBException {
        try {
            EPUBInfoImpl epubInfo = new EPUBInfoImpl(this);
            List<String> unmanifestedFilePaths = epubInfo.getUnmanifestedFilePathsForDelete(excludeUnmanifestedFilesRE);
            if (unmanifestedFilePaths != null && unmanifestedFilePaths.size() > 0) {
                File rootFile = this.getOPFFile();
                File rootDir = rootFile.getParentFile().getParentFile();
                for (String filePath : unmanifestedFilePaths) {
                    File itemFile = new File(rootDir, FileUtilities.decodeURIPath(filePath));
                    itemFile.delete();
                }
            }
        }
        catch (EPUBException e) {
            throw new EPUBException("Cannot delete unmanifested files", e);
        }
    }

    private boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        boolean boolValue = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
        return boolValue;
    }

    public boolean isCoverOnlyLinearSpineItem() throws EPUBException {
        OPFManifestItem coverPageManifestItem;
        GuideItem coverPageGuideItem;
        OPFDocument opfDocument = this.getOPF();
        if (opfDocument == null) {
            return false;
        }
        String coverPageHref = null;
        EPUBGuide guide = this.getGuide();
        if (guide != null && (coverPageGuideItem = guide.getCoverPageGuideItem()) != null && (coverPageManifestItem = opfDocument.getManifestItem(coverPageGuideItem)) != null) {
            coverPageHref = coverPageManifestItem.getHref();
        }
        boolean coverItemLinear = false;
        boolean nonCoverItemLinear = false;
        List<String> spineIdentifiers = opfDocument.getXHTMLSpineIdentifiers();
        if (spineIdentifiers != null) {
            for (String spineIdentifier : spineIdentifiers) {
                OPFSpineItem spineItem = opfDocument.getSpineItem(spineIdentifier);
                if (spineItem == null || spineItem.getLinear() != null && !this.isTrue(spineItem.getLinear())) continue;
                OPFManifestItem spineManifestItem = opfDocument.getManifestItem(spineIdentifier);
                if (spineManifestItem != null) {
                    String spineItemHref = spineManifestItem.getHref();
                    if (coverPageHref != null && spineItemHref.equals(coverPageHref)) {
                        coverItemLinear = true;
                        continue;
                    }
                    nonCoverItemLinear = true;
                    continue;
                }
                nonCoverItemLinear = true;
            }
        }
        boolean isCoverOnlyLinearSpineItem = coverItemLinear && !nonCoverItemLinear;
        return isCoverOnlyLinearSpineItem;
    }

    public Long getComputedPageCountForFixedLayoutEpub() throws EPUBException {
        List<String> spineIdentifiers;
        OPFManifestItem coverPageManifestItem;
        GuideItem coverPageGuideItem;
        OPFDocument opfDocument = this.getOPF();
        if (opfDocument == null) {
            return null;
        }
        int pageCount = 0;
        String coverPageHref = null;
        boolean pageCountIncr = true;
        EPUBGuide guide = this.getGuide();
        if (guide != null && (coverPageGuideItem = guide.getCoverPageGuideItem()) != null && (coverPageManifestItem = opfDocument.getManifestItem(coverPageGuideItem)) != null) {
            coverPageHref = coverPageManifestItem.getHref();
        }
        if ((spineIdentifiers = opfDocument.getXHTMLSpineIdentifiers()) != null) {
            for (String spineIdentifier : spineIdentifiers) {
                OPFManifestItem spineManifestItem;
                OPFSpineItem spineItem = opfDocument.getSpineItem(spineIdentifier);
                if (spineItem == null || spineItem.getLinear() != null && !this.isTrue(spineItem.getLinear()) || (spineManifestItem = opfDocument.getManifestItem(spineIdentifier)) == null) continue;
                String spineItemHref = spineManifestItem.getHref();
                if (coverPageHref != null && spineItemHref.equals(coverPageHref)) continue;
                ++pageCount;
            }
        }
        return pageCount;
    }

    public Long getComputedPageCountForApplePub() throws EPUBException {
        NCXDocument ncxDocument;
        NCXExtensions ncxExtensions;
        NavDocument navDoc;
        OPFDocument opfDocument = this.getOPF();
        if (opfDocument != null && (navDoc = this.getPrimaryNav()) != null && navDoc instanceof NCXDocument && (ncxExtensions = new NCXExtensions(this, ncxDocument = (NCXDocument)navDoc, false)) != null) {
            return ncxExtensions.getNumberOfPagesTotal();
        }
        return null;
    }
}

