/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.ContainerRootFile;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class ContainerDocument {
    private Document document;
    private XPathFactory xpathFactory;

    public ContainerDocument(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        String uri = namespace.getURI();
        this.xpathFactory = new XPathFactory();
        this.xpathFactory.addNamespace("c", uri);
    }

    public List<ContainerRootFile> getRootFiles() {
        ArrayList<ContainerRootFile> result = new ArrayList<ContainerRootFile>();
        XPath xpath = this.xpathFactory.createXPath("/c:container/c:rootfiles/c:rootfile");
        List nodes = XPathFactory.selectNodes(this.document, xpath);
        for (Object node : nodes) {
            result.add(new ContainerRootFile((Element)node));
        }
        return result;
    }
}

