/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.xpath.XPath;

public class AppleDisplayOptionsDocument {
    private Document document;
    private XPathFactory xpathFactory;
    private List<Element> platformElements;

    public AppleDisplayOptionsDocument(Document document) {
        this.document = document;
        this.xpathFactory = new XPathFactory();
    }

    public List<Element> getPlatformElements() {
        if (this.platformElements == null) {
            this.platformElements = new ArrayList<Element>();
            XPath xpath = this.xpathFactory.createXPath("display_options/platform");
            List platformItems = XPathFactory.selectNodes(this.getDocument(), xpath);
            for (Object object : platformItems) {
                Element item = (Element)object;
                this.platformElements.add(item);
            }
        }
        return this.platformElements;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<String> getPlatforms() {
        List<Element> platformElems = this.getPlatformElements();
        ArrayList<String> platforms = new ArrayList<String>();
        for (Element elem : platformElems) {
            platforms.add(elem.getAttributeValue("name"));
        }
        return platforms;
    }

    public List<Element> getOptionElementsForPlatform(String platform) {
        XPath xpath = this.xpathFactory.createXPath("display_options/platform[@name='" + platform + "']/option");
        List platformOptionItems = XPathFactory.selectNodes(this.getDocument(), xpath);
        ArrayList<Element> platformOptionElements = new ArrayList<Element>();
        for (Object object : platformOptionItems) {
            Element item = (Element)object;
            platformOptionElements.add(item);
        }
        return platformOptionElements;
    }

    public Map<String, String> getOptionsForPlatform(String platform) {
        HashMap<String, String> options = new HashMap<String, String>();
        List<Element> optionElems = this.getOptionElementsForPlatform(platform);
        for (Element elem : optionElems) {
            options.put(elem.getAttributeValue("name"), elem.getValue());
        }
        return options;
    }
}

