/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.model;

import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.NavPoint;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AnchorNavPoint
implements NavPoint,
GuideItem {
    private Element element;
    private Namespace ns;

    public AnchorNavPoint(Element element) {
        this.element = element;
        String uri = "http://www.idpf.org/2007/ops";
        this.ns = Namespace.getNamespace((String)"epub", (String)uri);
    }

    @Override
    public String getURI() {
        return this.element.getAttributeValue("href");
    }

    @Override
    public void setURI(String src) {
        this.element.setAttribute("href", src);
    }

    @Override
    public String getType() {
        return this.element.getAttributeValue("type", this.ns);
    }

    @Override
    public String getTitle() {
        return this.element.getValue();
    }

    @Override
    public String getLabel() {
        if ((this.element.getText() == null || this.element.getText().length() == 0) && this.getTitle() != null && this.getTitle().length() > 0) {
            return this.getTitle();
        }
        return this.element.getText();
    }

    @Override
    public Element getDOMElement() {
        return this.element;
    }
}

