/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.itemproperties;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import com.apple.itunes.epubtoolkit.XHTMLTagFinderSAXHandler;
import com.apple.itunes.epubtoolkit.itemproperties.DefaultItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.ItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.MathMLItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.RemoteResourcesItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.SVGItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.ScriptedItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.SwitchItemProperty;
import com.apple.itunes.epubtoolkit.util.DocumentInputSource;
import java.io.File;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ItemPropertyFactory {
    public static ItemProperty getProperty(String prop) {
        if ("mathml".equals(prop)) {
            return new MathMLItemProperty();
        }
        if ("remote-resources".equals(prop)) {
            return new RemoteResourcesItemProperty();
        }
        if ("scripted".equals(prop)) {
            return new ScriptedItemProperty();
        }
        if ("svg".equals(prop)) {
            return new SVGItemProperty();
        }
        if ("switch".equals(prop)) {
            return new SwitchItemProperty();
        }
        return new DefaultItemProperty();
    }

    public static boolean hasTags(File contentDoc, String ... tags) throws EPUBException {
        XHTMLTagFinderSAXHandler handler = new XHTMLTagFinderSAXHandler(tags);
        ItemPropertyFactory.parse(contentDoc, handler);
        return handler.hasTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(File contentDoc, XHTMLSAXHandler handler) throws EPUBException {
        SAXParser parser;
        try {
            parser = handler.createParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error while trying to create parser to evaluate item properties for : " + contentDoc.getName(), e);
        }
        try {
            DocumentInputSource inputSource = new DocumentInputSource(contentDoc);
            try {
                parser.parse((InputSource)inputSource, (DefaultHandler)handler);
                return;
            }
            finally {
                if (inputSource != null) {
                    inputSource.cleanup();
                }
            }
        }
        catch (Exception e) {
            throw new EPUBException("Unable to cut: " + contentDoc.getName(), e);
        }
    }
}

