/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.HTMLTagFilter;
import com.apple.itunes.epubtoolkit.html.HTMLTagFilterEntry;
import com.apple.itunes.epubtoolkit.html.HTMLTagFilterEntryType;
import java.util.Collection;
import java.util.HashSet;

public class HTMLTagFilterBuilder {
    private Collection<HTMLTagFilterEntry> entries = new HashSet<HTMLTagFilterEntry>();
    private boolean allowComments;
    private boolean allowDTDDeclarations;
    private boolean allowDocumentDeclarations;
    private boolean allowByDefault;
    private boolean allowAttributes;
    private String textParentElement;

    public HTMLTagFilter build() {
        HTMLTagFilter filter = new HTMLTagFilter();
        filter.setAllowAttributes(this.allowAttributes);
        filter.setAllowByDefault(this.allowByDefault);
        filter.setAllowComments(this.allowComments);
        filter.setAllowDocumentDeclarations(this.allowDocumentDeclarations);
        filter.setAllowDTDDeclarations(this.allowDTDDeclarations);
        filter.setFilterEntries(this.entries);
        filter.setTextParentElement(this.textParentElement);
        return filter;
    }

    public boolean allowComments() {
        return this.allowComments;
    }

    public void setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
    }

    public boolean allowDTDDeclarations() {
        return this.allowDTDDeclarations;
    }

    public void setAllowDTDDeclarations(boolean allowDTDDeclarations) {
        this.allowDTDDeclarations = allowDTDDeclarations;
    }

    public boolean allowDocumentDeclarations() {
        return this.allowDocumentDeclarations;
    }

    public void setAllowDocumentDeclarations(boolean allowDocumentDeclarations) {
        this.allowDocumentDeclarations = allowDocumentDeclarations;
    }

    public boolean allowByDefault() {
        return this.allowByDefault;
    }

    public void setAllowByDefault(boolean allowByDefault) {
        this.allowByDefault = allowByDefault;
    }

    public boolean allowAttributes() {
        return this.allowAttributes;
    }

    public void setAllowAttributes(boolean allowAttributes) {
        this.allowAttributes = allowAttributes;
    }

    public void disallow(String tagName) {
        this.entries.add(new HTMLTagFilterEntry(HTMLTagFilterEntryType.DISALLOW, tagName));
    }

    public void allow(String tagName) {
        this.entries.add(new HTMLTagFilterEntry(HTMLTagFilterEntryType.ALLOW, tagName));
    }

    public void allowContentOnly(String tagName) {
        this.entries.add(new HTMLTagFilterEntry(HTMLTagFilterEntryType.CONTENT_ONLY, tagName));
    }

    public void setTextParentElement(String textParentElement) {
        this.textParentElement = textParentElement;
    }
}

