/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.HTMLEventContext;
import com.apple.itunes.epubtoolkit.html.HTMLEventHandler;
import com.apple.itunes.epubtoolkit.html.HTMLParser;
import com.apple.itunes.epubtoolkit.html.HTMLParserException;
import com.apple.itunes.epubtoolkit.html.HTMLTagFilterEntry;
import com.apple.itunes.epubtoolkit.html.HTMLTagFilterEntryType;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class HTMLTagFilter
implements HTMLEventHandler {
    private final List<HTMLTagFilterEntryType> filterEntryTypeStack = new LinkedList<HTMLTagFilterEntryType>();
    private final StringBuilder buffer = new StringBuilder();
    private final Map<String, HTMLTagFilterEntry> filteredTagMap = new HashMap<String, HTMLTagFilterEntry>();
    private boolean allowComments;
    private boolean allowDTDDeclarations;
    private boolean allowDocumentDeclarations;
    private boolean allowByDefault;
    private boolean allowAttributes;
    private String textParentElement;

    HTMLTagFilter() {
    }

    public void processInput(String input) throws HTMLParserException {
        this.buffer.setLength(0);
        HTMLParser parser = new HTMLParser(new StringReader(input != null ? input : ""));
        parser.setHtmlEventHandler(this);
        parser.getParserEventHandler().setTextParentElement(this.textParentElement);
        parser.parse();
    }

    public String getOutput() {
        return this.buffer.toString();
    }

    protected boolean stackPermitsOutput() {
        for (int index = this.filterEntryTypeStack.size() - 1; index >= 0; --index) {
            HTMLTagFilterEntryType type = this.filterEntryTypeStack.get(index);
            switch (type) {
                case DISALLOW: {
                    return false;
                }
            }
        }
        return true;
    }

    protected HTMLTagFilterEntryType pushFilterTypeForTag(String elementName) {
        HTMLTagFilterEntry filterEntry = this.filteredTagMap.get(elementName.toLowerCase());
        HTMLTagFilterEntryType type = filterEntry != null ? filterEntry.getType() : (this.allowByDefault ? HTMLTagFilterEntryType.ALLOW : HTMLTagFilterEntryType.DISALLOW);
        this.push(type);
        return type;
    }

    @Override
    public void handleStartElement(String elementName, Attributes attributes, boolean isQuickClose, HTMLEventContext context) {
        boolean stackPermitsOutput = this.stackPermitsOutput();
        HTMLTagFilterEntryType currentType = this.pushFilterTypeForTag(elementName);
        if (isQuickClose) {
            this.pop();
        }
        if (!stackPermitsOutput) {
            return;
        }
        if (currentType == HTMLTagFilterEntryType.DISALLOW || currentType == HTMLTagFilterEntryType.CONTENT_ONLY) {
            return;
        }
        this.appendStartElement(elementName, attributes, isQuickClose);
    }

    @Override
    public void handleEndElement(String elementName, HTMLEventContext context) {
        HTMLTagFilterEntryType type = this.pop();
        if (type == null) {
            HTMLTagFilterEntryType hTMLTagFilterEntryType = type = this.allowByDefault ? HTMLTagFilterEntryType.ALLOW : HTMLTagFilterEntryType.DISALLOW;
        }
        if (type == HTMLTagFilterEntryType.DISALLOW || type == HTMLTagFilterEntryType.CONTENT_ONLY) {
            return;
        }
        boolean stackPermitsOutput = this.stackPermitsOutput();
        if (stackPermitsOutput) {
            HTMLTagFilter.appendEndElement(this.buffer, elementName);
        }
    }

    @Override
    public void handleComment(String text, HTMLEventContext context) {
        boolean stackPermitsOutput = this.stackPermitsOutput();
        if (this.allowComments && stackPermitsOutput) {
            this.buffer.append(text);
        }
    }

    @Override
    public void handleDocumentDeclaration(String declaration, HTMLEventContext context) {
        boolean stackPermitsOutput = this.stackPermitsOutput();
        if (this.allowDocumentDeclarations && stackPermitsOutput) {
            this.buffer.append(declaration);
        }
    }

    @Override
    public void handleDTD(String dtdDefinition, HTMLEventContext context) {
        boolean stackPermitsOutput = this.stackPermitsOutput();
        if (this.allowDTDDeclarations && stackPermitsOutput) {
            this.buffer.append(dtdDefinition);
        }
    }

    @Override
    public void handleText(String text, HTMLEventContext context) {
        boolean stackPermitsOutput = this.stackPermitsOutput();
        if (stackPermitsOutput) {
            this.buffer.append(text);
        }
    }

    protected void appendStartElement(String elementName, Attributes attributes, boolean isQuickClose) {
        this.buffer.append("<");
        this.buffer.append(elementName);
        if (this.allowAttributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String key = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.buffer.append(" ");
                this.buffer.append(key);
                if (value == null) continue;
                this.buffer.append("=");
                this.buffer.append(value);
            }
        }
        if (isQuickClose) {
            this.buffer.append("/>");
        } else {
            this.buffer.append(">");
        }
    }

    protected static void appendEndElement(StringBuilder buffer, String elementName) {
        buffer.append("</");
        buffer.append(elementName);
        buffer.append(">");
    }

    protected void push(HTMLTagFilterEntryType type) {
        this.filterEntryTypeStack.add(type);
    }

    protected HTMLTagFilterEntryType pop() {
        int stackSize = this.filterEntryTypeStack.size();
        if (stackSize < 1) {
            return null;
        }
        return this.filterEntryTypeStack.remove(stackSize - 1);
    }

    public void setFilterEntries(Collection<HTMLTagFilterEntry> entries) {
        this.filteredTagMap.clear();
        for (HTMLTagFilterEntry entry : entries) {
            this.filteredTagMap.put(entry.getTagName().toLowerCase(), entry);
        }
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public void setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
    }

    public boolean isAllowDTDDeclarations() {
        return this.allowDTDDeclarations;
    }

    public void setAllowDTDDeclarations(boolean allowDTDDeclarations) {
        this.allowDTDDeclarations = allowDTDDeclarations;
    }

    public boolean isAllowDocumentDeclarations() {
        return this.allowDocumentDeclarations;
    }

    public void setAllowDocumentDeclarations(boolean allowDocumentDeclarations) {
        this.allowDocumentDeclarations = allowDocumentDeclarations;
    }

    public boolean isAllowByDefault() {
        return this.allowByDefault;
    }

    public void setAllowByDefault(boolean allowByDefault) {
        this.allowByDefault = allowByDefault;
    }

    public boolean isAllowAttributes() {
        return this.allowAttributes;
    }

    public void setAllowAttributes(boolean allowAttributes) {
        this.allowAttributes = allowAttributes;
    }

    @Override
    public void setTextParentElement(String textParentElement) {
        this.textParentElement = textParentElement;
    }
}

