/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.ElementHandler;
import java.util.HashSet;
import java.util.Set;

class ElementHandlerRestricted
extends ElementHandler {
    private final Set<String> validChildren = new HashSet<String>();

    public ElementHandlerRestricted(String[] validChildren) {
        if (validChildren != null) {
            for (String child : validChildren) {
                this.validChildren.add(child);
            }
        }
    }

    @Override
    public boolean acceptsChildElement(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Parameter elementName cannot be null.");
        }
        return this.validChildren.contains(elementName.toLowerCase());
    }

    @Override
    public boolean acceptsChildren() {
        return this.validChildren.size() > 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.validChildren == null ? 0 : this.validChildren.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementHandlerRestricted other = (ElementHandlerRestricted)obj;
        return !(this.validChildren == null ? other.validChildren != null : !this.validChildren.equals(other.validChildren));
    }

    @Override
    public String toString() {
        return "ElementHandlerRestricted [validChildren=" + this.validChildren + "]";
    }
}

