/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.ElementHandler;
import com.apple.itunes.epubtoolkit.html.ElementHandlerEmpty;
import com.apple.itunes.epubtoolkit.html.ElementHandlerNoElementChildren;
import com.apple.itunes.epubtoolkit.html.ElementHandlerRestricted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ElementHandlerFactory {
    private Map<String, ElementHandler> elementHandlerMap = new HashMap<String, ElementHandler>();
    protected static final String[] HTML_CONTENT = new String[]{"head", "body"};
    protected static final String[] HEAD_CONTENT = new String[]{"title", "base"};
    protected static final String[] HEAD_MISC = new String[]{"script", "style", "meta", "link", "object"};
    protected static final String[] HEAD = ElementHandlerFactory.concatStringArray(HEAD_CONTENT, HEAD_MISC);
    protected static final String[] HEADING = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    protected static final String[] LIST = new String[]{"ul", "ol"};
    protected static final String[] PREFORMATTED = new String[]{"pre"};
    protected static final String[] FONTSTYLE = new String[]{"tt", "i", "b", "big", "small", "u"};
    protected static final String[] PHRASE = new String[]{"em", "string", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym"};
    protected static final String[] SPECIAL = new String[]{"a", "img", "object", "br", "script", "map", "q", "sub", "sup", "span", "bdo"};
    protected static final String[] FORMCTL = new String[]{"input", "select", "textarea", "label", "button"};
    protected static final String[] INLINE = ElementHandlerFactory.concatStringArray(FONTSTYLE, PHRASE, SPECIAL, FORMCTL);
    protected static final String[] BLOCK = ElementHandlerFactory.concatStringArray(HEADING, LIST, PREFORMATTED, {"p", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address"});
    protected static final String[] FLOW = ElementHandlerFactory.concatStringArray(BLOCK, INLINE);
    protected static final String[] PRE_EXCLUSION = new String[]{"img", "object", "big", "small", "sub", "sup"};

    public ElementHandlerFactory() {
        ElementHandlerRestricted inlineHandler = new ElementHandlerRestricted(INLINE);
        for (String elementName : ElementHandlerFactory.concatStringArray(FONTSTYLE, PHRASE, HEADING)) {
            this.elementHandlerMap.put(elementName, inlineHandler);
        }
        this.elementHandlerMap.put("sub", inlineHandler);
        this.elementHandlerMap.put("sup", inlineHandler);
        this.elementHandlerMap.put("span", inlineHandler);
        this.elementHandlerMap.put("bdo", inlineHandler);
        this.elementHandlerMap.put("address", inlineHandler);
        this.elementHandlerMap.put("a", inlineHandler);
        this.elementHandlerMap.put("p", inlineHandler);
        this.elementHandlerMap.put("q", inlineHandler);
        this.elementHandlerMap.put("dt", inlineHandler);
        this.elementHandlerMap.put("label", inlineHandler);
        this.elementHandlerMap.put("legend", inlineHandler);
        this.elementHandlerMap.put("caption", inlineHandler);
        ElementHandlerRestricted flowHandler = new ElementHandlerRestricted(FLOW);
        this.elementHandlerMap.put("div", flowHandler);
        this.elementHandlerMap.put("ins", flowHandler);
        this.elementHandlerMap.put("del", flowHandler);
        this.elementHandlerMap.put("dd", flowHandler);
        this.elementHandlerMap.put("li", flowHandler);
        this.elementHandlerMap.put("th", flowHandler);
        this.elementHandlerMap.put("td", flowHandler);
        ElementHandlerRestricted listHandler = new ElementHandlerRestricted(new String[]{"li"});
        this.elementHandlerMap.put("ol", listHandler);
        this.elementHandlerMap.put("ul", listHandler);
        ElementHandlerEmpty emptyElementHandler = new ElementHandlerEmpty();
        this.elementHandlerMap.put("area", emptyElementHandler);
        this.elementHandlerMap.put("link", emptyElementHandler);
        this.elementHandlerMap.put("img", emptyElementHandler);
        this.elementHandlerMap.put("param", emptyElementHandler);
        this.elementHandlerMap.put("hr", emptyElementHandler);
        this.elementHandlerMap.put("input", emptyElementHandler);
        this.elementHandlerMap.put("col", emptyElementHandler);
        this.elementHandlerMap.put("base", emptyElementHandler);
        this.elementHandlerMap.put("meta", emptyElementHandler);
        this.elementHandlerMap.put("br", emptyElementHandler);
        ElementHandlerNoElementChildren noElementHandler = new ElementHandlerNoElementChildren();
        this.elementHandlerMap.put("option", noElementHandler);
        this.elementHandlerMap.put("textarea", noElementHandler);
        this.elementHandlerMap.put("title", noElementHandler);
    }

    public ElementHandler getInstance(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Parameter elementName cannot be null.");
        }
        ElementHandler handler = this.elementHandlerMap.get(elementName.toLowerCase());
        if (handler == null) {
            handler = new ElementHandler();
        }
        handler.setFactory(this);
        return handler;
    }

    protected static String[] concatStringArray(String[] ... arrays) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (String[] currentArray : arrays) {
            for (int j = 0; j < currentArray.length; ++j) {
                buffer.add(currentArray[j]);
            }
        }
        String[] result = new String[buffer.size()];
        return buffer.toArray(result);
    }
}

