/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.AttributesImpl;
import com.apple.itunes.epubtoolkit.html.ElementHandler;
import com.apple.itunes.epubtoolkit.html.ElementHandlerFactory;
import com.apple.itunes.epubtoolkit.html.HTMLEventContext;
import com.apple.itunes.epubtoolkit.html.HTMLEventHandler;
import com.apple.itunes.epubtoolkit.html.HTMLParserEventHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

class DefaultHTMLParserEventHandler
implements HTMLParserEventHandler {
    private final List<String> stack = new ArrayList<String>();
    private final ElementHandlerFactory factory = new ElementHandlerFactory();
    private HTMLEventHandler htmlEventHandler;
    private String textParentElement;
    private boolean textWrapped = false;

    DefaultHTMLParserEventHandler() {
    }

    @Override
    public void close() {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            String stackElement = this.popStack();
            this.htmlEventHandler.handleEndElement(stackElement, null);
        }
    }

    @Override
    public void handleStartElement(String elementName, Attributes attributes, boolean isQuickClose, HTMLEventContext context) {
        boolean isHermitElement;
        while (this.shouldPopStackElementOnStartElement(elementName)) {
            String stackElement = this.popStack();
            if (this.textParentElement != null && this.textParentElement.equalsIgnoreCase(stackElement)) {
                this.textWrapped = false;
            }
            this.htmlEventHandler.handleEndElement(stackElement, context);
        }
        if (!this.textWrapped && this.textParentElement != null && !this.textParentElement.isEmpty()) {
            if (this.textParentElement.equalsIgnoreCase(elementName)) {
                this.textWrapped = true;
            } else if (this.stack.isEmpty()) {
                ElementHandler handler = this.factory.getInstance(elementName);
                ElementHandler parentHandler = this.factory.getInstance(this.textParentElement);
                if (!handler.acceptsChildElement(this.textParentElement) && parentHandler.acceptsChildElement(elementName)) {
                    this.handleStartElement(this.textParentElement, null, false, context);
                }
            }
        }
        ElementHandler elementHandler = this.factory.getInstance(elementName);
        boolean bl = isHermitElement = isQuickClose || !elementHandler.acceptsChildren();
        if (!isHermitElement) {
            this.pushStack(elementName);
        }
        this.htmlEventHandler.handleStartElement(elementName, attributes, isHermitElement, context);
    }

    private boolean shouldPopStackElementOnStartElement(String elementName) {
        String stackElement = this.peekStack();
        if (stackElement == null) {
            return false;
        }
        ElementHandler handler = this.factory.getInstance(stackElement);
        if (!handler.acceptsChildren()) {
            return true;
        }
        return !handler.acceptsChildElement(elementName);
    }

    @Override
    public void handleEndElement(String elementName, HTMLEventContext context) {
        if (this.stack.size() < 1) {
            return;
        }
        String stackElement = this.peekStack();
        boolean elementsAreEqual = elementName.equalsIgnoreCase(stackElement);
        if (elementsAreEqual) {
            this.popStack();
            if (this.textWrapped && elementName.equalsIgnoreCase(this.textParentElement)) {
                this.textWrapped = false;
            }
            this.htmlEventHandler.handleEndElement(elementName, context);
            return;
        }
        boolean stackContainsElement = this.stackContainsIgnoreCase(elementName);
        if (stackContainsElement) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                String currentElement = this.stack.get(i);
                this.stack.remove(i);
                if (!currentElement.equalsIgnoreCase(elementName)) {
                    if (this.textWrapped && elementName.equalsIgnoreCase(currentElement)) {
                        this.textWrapped = false;
                    }
                    this.htmlEventHandler.handleEndElement(currentElement, context);
                    continue;
                }
                break;
            }
        } else {
            this.htmlEventHandler.handleStartElement(elementName, new AttributesImpl(), false, context);
        }
        if (this.textWrapped && elementName.equalsIgnoreCase(elementName)) {
            this.textWrapped = false;
        }
        this.htmlEventHandler.handleEndElement(elementName, context);
    }

    private boolean stackContainsIgnoreCase(String elementName) {
        for (String currentElement : this.stack) {
            if (!currentElement.equalsIgnoreCase(elementName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleText(String text, HTMLEventContext context) {
        if (!this.textWrapped && this.textParentElement != null && !this.textParentElement.isEmpty() && this.stack.isEmpty()) {
            this.handleStartElement(this.textParentElement, null, false, context);
        }
        this.htmlEventHandler.handleText(text, context);
    }

    @Override
    public void handleComment(String text, HTMLEventContext context) {
        this.htmlEventHandler.handleComment(text, context);
    }

    @Override
    public void handleDTD(String dtdDefinition, HTMLEventContext context) {
        this.htmlEventHandler.handleDTD(dtdDefinition, context);
    }

    @Override
    public void handleDocumentDeclaration(String declaration, HTMLEventContext context) {
        this.htmlEventHandler.handleDocumentDeclaration(declaration, context);
    }

    protected String peekStack() {
        int size = this.stack.size();
        if (size < 1) {
            return null;
        }
        return this.stack.get(size - 1);
    }

    protected String popStack() {
        int size = this.stack.size();
        if (size < 1) {
            return null;
        }
        return this.stack.remove(size - 1);
    }

    protected void pushStack(String element) {
        this.stack.add(element);
    }

    @Override
    public HTMLEventHandler getHtmlEventHandler() {
        return this.htmlEventHandler;
    }

    @Override
    public void setHtmlEventHandler(HTMLEventHandler htmlEventHandler) {
        this.htmlEventHandler = htmlEventHandler;
    }

    @Override
    public void setTextParentElement(String value) {
        this.textParentElement = value;
    }
}

