/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.html;

import com.apple.itunes.epubtoolkit.html.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

class AttributesImpl
implements Attributes {
    private List<Attribute> entries = new ArrayList<Attribute>();
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();

    AttributesImpl() {
    }

    protected synchronized void add(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        int index = this.entries.size();
        this.entries.add(attribute);
        this.indexMap.put(attribute.getName(), index);
    }

    @Override
    public int getIndex(String uri, String localName) {
        return this.getIndex(localName);
    }

    @Override
    public int getIndex(String qName) {
        Integer index = this.indexMap.get(qName);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public int getLength() {
        return this.entries.size();
    }

    @Override
    public String getLocalName(int index) {
        return this.getQName(index);
    }

    @Override
    public String getQName(int index) {
        Attribute entry = this.entries.get(index);
        if (entry == null) {
            return null;
        }
        return entry.getName();
    }

    @Override
    public String getType(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType(String uri, String localName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType(String qName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getURI(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue(int index) {
        Attribute entry = this.entries.get(index);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.getValue(localName);
    }

    @Override
    public String getValue(String qName) {
        int index = this.getIndex(qName);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.indexMap == null ? 0 : this.indexMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributesImpl other = (AttributesImpl)obj;
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return !(this.indexMap == null ? other.indexMap != null : !this.indexMap.equals(other.indexMap));
    }

    public String toString() {
        return "AttributesImpl [entries=" + this.entries + "]";
    }
}

