/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.commandline.Command;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionException;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionMap;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionParameterDescription;
import java.io.File;

abstract class SimpleIOCommand
extends Command {
    private CommandOptionMap options;
    private File input;
    private File output;

    public SimpleIOCommand(String commandPath, String commandKey) {
        super(commandPath, commandKey);
    }

    protected abstract CommandOptionParameterDescription[] getValidParamDescriptions();

    protected CommandOptionMap buildCommandOptionMap(String[] args) throws CommandOptionException {
        return new CommandOptionMap(this.getValidParamDescriptions(), args, 1, args.length - 3);
    }

    @Override
    public int takeValuesFromArgs(String[] args) {
        File outputDirectory;
        if (args.length < 3) {
            System.err.println("Missing one or more required arguments.");
            return this.printHelp();
        }
        if (args.length % 2 == 0) {
            System.err.println("Wrong number of arguments.");
            return this.printHelp();
        }
        try {
            this.options = this.buildCommandOptionMap(args);
        }
        catch (CommandOptionException ex) {
            System.err.println(ex.getLocalizedMessage());
            return this.printHelp();
        }
        this.input = new File(args[args.length - 2]);
        this.output = new File(args[args.length - 1]);
        if (!this.input.exists()) {
            System.err.println("Input file does not exist: " + this.input.getAbsolutePath());
            return 2;
        }
        boolean inputIsDirectory = this.input.isDirectory();
        boolean outputIsDirectory = this.output.isDirectory();
        if (inputIsDirectory) {
            if (!outputIsDirectory) {
                System.err.println("If input is a directory, then output must also be a directory: " + this.output.getAbsolutePath());
                return 3;
            }
            if (!this.output.exists()) {
                System.err.println("If input is a directory, then output must also be an existing directory: " + this.output.getAbsolutePath());
                return 4;
            }
        } else if (outputIsDirectory) {
            System.err.println("If input is a file, then output must also be a file: " + this.output.getAbsolutePath());
            return 5;
        }
        if ((outputDirectory = this.output.getParentFile()) == null) {
            outputDirectory = new File(".");
        }
        if (!outputDirectory.isDirectory() || !outputDirectory.exists()) {
            System.err.println("Output directory does not exist or is not a directory: " + outputDirectory.getAbsolutePath());
            return 6;
        }
        if (!outputDirectory.canWrite()) {
            System.err.println("Cannot write to output directory: " + outputDirectory.getAbsolutePath());
            return 7;
        }
        return 0;
    }

    public File getInput() {
        return this.input;
    }

    public File getOutput() {
        return this.output;
    }

    public CommandOptionMap getOptions() {
        return this.options;
    }
}

