/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.EPUBCleaner;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionParameterDescription;
import com.apple.itunes.epubtoolkit.commandline.CutPreviewCommand;
import com.apple.itunes.epubtoolkit.commandline.SimpleIOCommand;
import java.io.File;

public class LintCommand
extends SimpleIOCommand {
    private static final CommandOptionParameterDescription CONTINUE_PARAM = new CommandOptionParameterDescription("c", Boolean.class);
    private static final CommandOptionParameterDescription VERBOSE_PARAM = new CommandOptionParameterDescription("v", Boolean.class);
    private static final CommandOptionParameterDescription DELETE_UNMANIFESTED_FILES_PARAM = new CommandOptionParameterDescription("d", Boolean.class);
    private static final CommandOptionParameterDescription EXCLUDE_UNMANIFESTED_FILES_PARAM = new CommandOptionParameterDescription("e", String.class);
    private static final CommandOptionParameterDescription[] VALID_PARAMS = new CommandOptionParameterDescription[]{CONTINUE_PARAM, VERBOSE_PARAM, DELETE_UNMANIFESTED_FILES_PARAM, EXCLUDE_UNMANIFESTED_FILES_PARAM};

    public LintCommand(String commandPath, String commandKey) {
        super(commandPath, commandKey);
    }

    @Override
    public int printHelp() {
        String usagePrefix = this.getHelpUsagePrefix();
        System.out.print(usagePrefix);
        System.out.println("[-c <continue after error>] [-v <verbose> ] [-d <delete unmanifested files (boolean)>] [-e <RE for do not delete unmanifested files>] <input file|directory> <output file|directory>");
        System.out.println("Examples: ");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println(" /path/to/input.epub /path/to/output.clean.epub");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println(" -c true /path/to/input/directory /path/to/output/directory");
        return 1;
    }

    @Override
    protected CommandOptionParameterDescription[] getValidParamDescriptions() {
        return VALID_PARAMS;
    }

    @Override
    public int execute() throws Exception {
        Boolean continueOnError = this.getContinueOnError();
        boolean inputIsDirectory = this.getInput().isDirectory();
        if (inputIsDirectory) {
            return this.processDirectories(this.getInput(), this.getOutput(), continueOnError);
        }
        EPUBCleaner cleaner = new EPUBCleaner(this.getInput(), this.getOutput());
        cleaner.clean(this.isDeleteUnmanifestedFiles(), this.getExcludeUnmanifestedFilesRE());
        return 0;
    }

    private int processDirectories(File input, File output, Boolean continueOnError) throws Exception {
        File[] epubFiles;
        for (File inputFile : epubFiles = input.listFiles(new CutPreviewCommand.EPUBFilenameFilter())) {
            if (this.isVerbose()) {
                System.out.println("Cleanning up: " + inputFile.getAbsolutePath());
            }
            File outputFile = new File(output, inputFile.getName() + ".clean.epub");
            EPUBCleaner cleaner = new EPUBCleaner(inputFile, outputFile);
            try {
                cleaner.clean(this.isDeleteUnmanifestedFiles(), this.getExcludeUnmanifestedFilesRE());
            }
            catch (Exception ex) {
                if (!continueOnError.booleanValue()) {
                    throw ex;
                }
                System.err.println("ERROR: Unable to clean " + inputFile.getAbsolutePath() + ": " + ex.getMessage());
            }
        }
        return 0;
    }

    public boolean getContinueOnError() {
        Boolean continueOnError = (Boolean)this.getOptions().get(CONTINUE_PARAM);
        if (continueOnError == null) {
            return false;
        }
        return continueOnError;
    }

    public boolean isVerbose() {
        Boolean verbose = (Boolean)this.getOptions().get(VERBOSE_PARAM);
        if (verbose == null) {
            return false;
        }
        return verbose;
    }

    public boolean isDeleteUnmanifestedFiles() {
        Boolean deleteUnmanifestedFiles = (Boolean)this.getOptions().get(DELETE_UNMANIFESTED_FILES_PARAM);
        if (deleteUnmanifestedFiles == null) {
            return false;
        }
        return deleteUnmanifestedFiles;
    }

    public String getExcludeUnmanifestedFilesRE() {
        String excludeUnmanifestedFilesRE = (String)this.getOptions().get(EXCLUDE_UNMANIFESTED_FILES_PARAM);
        return excludeUnmanifestedFilesRE;
    }
}

