/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoExtractor;
import com.apple.itunes.epubtoolkit.commandline.Command;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import java.io.File;
import java.io.IOException;

public class InfoCommand
extends Command {
    private File input;

    public InfoCommand(String commandPath, String commandKey) {
        super(commandPath, commandKey);
    }

    @Override
    public int takeValuesFromArgs(String[] args) {
        if (args.length != 2) {
            System.err.println("Missing one or more required arguments.");
            return this.printHelp();
        }
        this.input = new File(args[1]);
        if (!this.input.exists()) {
            System.err.println("Input file does not exist: " + this.input.getAbsolutePath());
            return 2;
        }
        return 0;
    }

    @Override
    public int execute() throws Exception {
        File input = this.getInput();
        if (input.isFile()) {
            this.printFileInfo(input);
        }
        if (input.isDirectory()) {
            File[] files;
            for (File file : files = input.listFiles()) {
                if (!file.isFile()) continue;
                this.printFileInfo(file);
            }
        }
        return 0;
    }

    private void printFileInfo(File input) throws IOException, EPUBException {
        EPUBInfoExtractor extractor = new EPUBInfoExtractor(input);
        EPUBInfoExtractor.setUnzipper(new CommonsCompressZipUtil());
        EPUBInfo info = extractor.extract();
        String header = "Info for: " + input.getAbsolutePath();
        String footer = "End Report For: " + input.getAbsolutePath();
        InfoCommand.printHeaderFooterSeparator(footer.length());
        System.out.println(header);
        InfoCommand.printHeaderFooterSeparator(footer.length());
        System.out.println("MIME: " + info.getMimeType());
        System.out.println("Rootfile Tag Count: " + info.getRootTagCount());
        System.out.println("Cover Art: " + info.getCoverArtFile());
        System.out.println("Cover Art MIME: " + info.getCoverArtMimeType());
        System.out.println("Manifest Document Count: " + info.getManifestItemCount());
        System.out.println("All Manifest Documents Found: " + InfoCommand.booleanToBool(info.hasAllManifestItems()));
        System.out.println("Spine Document Count: " + info.getSpineItemCount());
        System.out.println("All Spine Documents Found: " + InfoCommand.booleanToBool(info.hasAllSpineItems()));
        System.out.println("Has Rights.xml: " + InfoCommand.booleanToBool(info.isSignaturesXmlPresent()));
        System.out.println("Has Encryption.xml: " + InfoCommand.booleanToBool(info.isEncryptionXmlPresent()));
        System.out.println();
        System.out.println("OPF:");
        System.out.println(info.getOpfContents());
        System.out.println("NCX Nav:");
        System.out.println(info.getNCXNavContents());
        System.out.println("XHTML Nav:");
        System.out.println(info.getXHTMLNavContents());
        InfoCommand.printHeaderFooterSeparator(footer.length());
        System.out.println(footer);
        InfoCommand.printHeaderFooterSeparator(footer.length());
    }

    private static String booleanToBool(boolean value) {
        return value ? "YES" : "NO";
    }

    private static void printHeaderFooterSeparator(int length) {
        for (int i = 0; i < length; ++i) {
            System.out.print("=");
        }
        System.out.println();
    }

    @Override
    public int printHelp() {
        String usagePrefix = this.getHelpUsagePrefix();
        System.out.print(usagePrefix);
        System.out.println("<input file|directory>");
        System.out.println("Examples: ");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println(" /path/to/input.epub");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println("/path/to/input/directory");
        return 1;
    }

    public File getInput() {
        return this.input;
    }
}

