/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.commandline.Command;
import com.apple.itunes.epubtoolkit.commandline.CommandFactory;
import java.util.Collection;

public class HelpCommand
extends Command {
    public HelpCommand(String commandPath, String commandKey) {
        super(commandPath, commandKey);
    }

    @Override
    public int execute() throws Exception {
        String commandPath = this.getCommandPath();
        System.out.print("Usage: ");
        System.out.print(commandPath);
        System.out.println(" <command> [help | <command options>]");
        System.out.println("Commands:");
        Collection<String> commandKeys = CommandFactory.getInstance().getSupportedCommandKeys();
        for (String key : commandKeys) {
            System.out.print("    ");
            System.out.println(key);
        }
        System.out.println("Examples: ");
        System.out.print("    ");
        System.out.print(commandPath);
        System.out.println(" help");
        System.out.print("    ");
        System.out.print(commandPath);
        System.out.println(" preview help");
        System.out.print("    ");
        System.out.print(commandPath);
        System.out.println(" preview -p 10 -s 1 input.epub output.epub");
        return -1;
    }

    @Override
    public int takeValuesFromArgs(String[] args) {
        return 0;
    }

    @Override
    public int printHelp() {
        System.err.println("No documentation for help command.");
        return 0;
    }
}

