/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.EPUBPreviewCutter;
import com.apple.itunes.epubtoolkit.EPUBPreviewCutterStatusDelegate;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionParameterDescription;
import com.apple.itunes.epubtoolkit.commandline.SimpleIOCommand;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class CutPreviewCommand
extends SimpleIOCommand
implements EPUBPreviewCutterStatusDelegate {
    private static final CommandOptionParameterDescription PERCENTAGE_PARAM = new CommandOptionParameterDescription("p", Integer.class);
    private static final CommandOptionParameterDescription START_INDEX_PARAM = new CommandOptionParameterDescription("s", Integer.class);
    private static final CommandOptionParameterDescription ANCHOR_PARAM = new CommandOptionParameterDescription("a", String.class);
    private static final CommandOptionParameterDescription CONTINUE_PARAM = new CommandOptionParameterDescription("c", Boolean.class);
    private static final CommandOptionParameterDescription VERBOSE_PARAM = new CommandOptionParameterDescription("v", Boolean.class);
    private static final CommandOptionParameterDescription FIXED_LAYOUT_PARAM = new CommandOptionParameterDescription("f", Boolean.class);
    private static final CommandOptionParameterDescription[] VALID_PARAMS = new CommandOptionParameterDescription[]{PERCENTAGE_PARAM, START_INDEX_PARAM, ANCHOR_PARAM, CONTINUE_PARAM, VERBOSE_PARAM, FIXED_LAYOUT_PARAM};

    public CutPreviewCommand(String commandPath, String commandKey) {
        super(commandPath, commandKey);
    }

    @Override
    public int printHelp() {
        String usagePrefix = this.getHelpUsagePrefix();
        System.out.print(usagePrefix);
        System.out.println("[-p <percentage> -s <start index> -a <end anchor> -c <continue after error> -v <verbose> -f <fixed-layout> ] <input file|directory> <output file|directory>");
        System.out.println("Examples: ");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println(" -p 10 -s 0 /path/to/input.epub /path/to/output.preview.epub");
        System.out.append("    ");
        System.out.append(this.getCommandPath());
        System.out.append(" ");
        System.out.append(this.getCommandKey());
        System.out.println(" -p 10 -s 0 -a com_apple_itunes_epub_end -c true /path/to/input/directory /path/to/output/directory");
        return 1;
    }

    @Override
    protected CommandOptionParameterDescription[] getValidParamDescriptions() {
        return VALID_PARAMS;
    }

    @Override
    public int execute() throws Exception {
        Integer percentage = this.getPercentage();
        Integer startIndex = this.getStartIndex();
        String anchor = this.getAnchor();
        Boolean continueOnError = this.getContinueOnError();
        Boolean fixedLayout = this.isFixedLayout();
        boolean inputIsDirectory = this.getInput().isDirectory();
        if (inputIsDirectory) {
            return this.processDirectories(this.getInput(), this.getOutput(), startIndex, percentage, anchor, continueOnError, fixedLayout);
        }
        EPUBPreviewCutter cutter = new EPUBPreviewCutter(this.getInput(), this.getOutput(), startIndex, percentage, anchor, this, fixedLayout);
        cutter.cut();
        return 0;
    }

    @Override
    public void previewCutterWillOpenInput(EPUBPreviewCutter cutter) {
        if (this.isVerbose()) {
            System.out.println(cutter.getInput().getName() + ": Opening...");
        }
    }

    @Override
    public void previewCutterDidOpenInput(EPUBPreviewCutter cutter) {
    }

    @Override
    public void previewCutterCalculatedCharCount(EPUBPreviewCutter cutter, long charCount) {
        if (this.isVerbose()) {
            System.out.println(cutter.getInput().getName() + ": Char count: " + charCount);
        }
    }

    @Override
    public void previewCutterFoundCuttoffPointInFile(EPUBPreviewCutter cutter, File file) {
        if (this.isVerbose()) {
            System.out.println(cutter.getInput().getName() + ": Reached cut-off point in " + file.getName());
        }
    }

    @Override
    public void previewCutterWillCreateOutput(EPUBPreviewCutter cutter) {
    }

    @Override
    public void previewCutterDidCreateOutput(EPUBPreviewCutter cutter) {
        if (this.isVerbose()) {
            System.out.println(cutter.getInput().getName() + ": Created " + cutter.getOutput().getName());
        }
    }

    private int processDirectories(File input, File output, Integer startIndex, Integer percentage, String anchor, Boolean continueOnError, boolean fixedLayout) throws Exception {
        File[] inputFiles;
        EPUBFilenameFilter filter = new EPUBFilenameFilter();
        for (File inputFile : inputFiles = input.listFiles(filter)) {
            if (this.isVerbose()) {
                System.out.println("Cutting preview of: " + inputFile.getAbsolutePath());
            }
            File outputFile = new File(output, inputFile.getName() + ".preview.epub");
            EPUBPreviewCutter cutter = new EPUBPreviewCutter(inputFile, outputFile, startIndex, percentage, anchor, this, fixedLayout);
            try {
                cutter.cut();
            }
            catch (Exception ex) {
                System.err.println("ERROR: Unable to cut preview of " + inputFile.getAbsolutePath() + ": " + ex.getMessage());
                if (continueOnError.booleanValue()) continue;
                throw ex;
            }
        }
        return 0;
    }

    public Integer getPercentage() {
        Integer percentage = (Integer)this.getOptions().get(PERCENTAGE_PARAM);
        if (percentage == null) {
            return 10;
        }
        return percentage;
    }

    public Integer getStartIndex() {
        Integer startIndex = (Integer)this.getOptions().get(START_INDEX_PARAM);
        if (startIndex == null) {
            return 0;
        }
        return startIndex;
    }

    public String getAnchor() {
        return (String)this.getOptions().get(ANCHOR_PARAM);
    }

    public boolean getContinueOnError() {
        Boolean continueOnError = (Boolean)this.getOptions().get(CONTINUE_PARAM);
        return continueOnError != null && continueOnError != false;
    }

    public boolean isVerbose() {
        Boolean verbose = (Boolean)this.getOptions().get(VERBOSE_PARAM);
        return verbose != null && verbose != false;
    }

    public boolean isFixedLayout() {
        Boolean fixed = (Boolean)this.getOptions().get(FIXED_LAYOUT_PARAM);
        return fixed != null && fixed != false;
    }

    protected static class EPUBFilenameFilter
    implements FilenameFilter {
        private static final Pattern EPUB_FILENAME_PATTERN = Pattern.compile(".+?[.]epub$", 2);

        protected EPUBFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return EPUB_FILENAME_PATTERN.matcher(name).matches();
        }
    }
}

