/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.commandline.CommandOptionException;
import com.apple.itunes.epubtoolkit.commandline.CommandOptionParameterDescription;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandOptionMap
extends HashMap<String, Object> {
    private static final Pattern KEY_PATTERN = Pattern.compile("-+(\\w+)");

    public CommandOptionMap(CommandOptionParameterDescription[] validKeys, String[] args, int offset, int count) throws CommandOptionException {
        if (args == null) {
            throw new IllegalArgumentException("Parameter args cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Parameter offset cannot be less than zero.");
        }
        if (offset >= args.length) {
            throw new IllegalArgumentException("Parameter offset, " + offset + ", is greater than args length, " + args.length + ".");
        }
        if (offset + count >= args.length) {
            throw new IllegalArgumentException("Parameter count, " + count + ", extends past args length, " + args.length + ".");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Parameter count, " + count + ", must be an even number.");
        }
        HashMap<String, CommandOptionParameterDescription> validKeySet = new HashMap<String, CommandOptionParameterDescription>();
        for (CommandOptionParameterDescription parameter : validKeys) {
            validKeySet.put(parameter.getKey(), parameter);
        }
        for (int i = offset; i < count; i += 2) {
            Object value;
            String rawKey = args[i];
            Matcher keyMatcher = KEY_PATTERN.matcher(rawKey);
            if (!keyMatcher.matches()) {
                throw new CommandOptionException("Not an option key: " + rawKey);
            }
            String key = keyMatcher.group(1);
            CommandOptionParameterDescription param = (CommandOptionParameterDescription)validKeySet.get(key);
            if (param == null) {
                throw new CommandOptionException("Not an option key: " + rawKey);
            }
            String rawValue = args[i + 1];
            try {
                value = param.valueOf(rawValue);
            }
            catch (Exception e) {
                throw new CommandOptionException("Not a valid value for " + key + ": " + rawValue);
            }
            this.put(key, value);
        }
    }

    public Object get(CommandOptionParameterDescription paramDescription) {
        if (paramDescription == null) {
            throw new IllegalArgumentException("Parameter paramDescription cannot be null.");
        }
        return this.get(paramDescription.getKey());
    }
}

