/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.commandline;

import com.apple.itunes.epubtoolkit.commandline.Command;
import com.apple.itunes.epubtoolkit.commandline.CutPreviewCommand;
import com.apple.itunes.epubtoolkit.commandline.HelpCommand;
import com.apple.itunes.epubtoolkit.commandline.InfoCommand;
import com.apple.itunes.epubtoolkit.commandline.LintCommand;
import com.apple.itunes.epubtoolkit.commandline.Main;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CommandFactory {
    private static Map<String, Class<? extends Command>> COMMAND_MAP = new HashMap<String, Class<? extends Command>>();
    private static final String COMMAND_PATH_PROPERTY_KEY = "com.apple.itunes.epubtoolkit.commandline.path";
    private static final CommandFactory SHARED_INSTANCE;

    private CommandFactory() {
    }

    public static final CommandFactory getInstance() {
        return SHARED_INSTANCE;
    }

    public Command createCommand(String key) {
        Command result;
        Class<? extends Command> commandClass = COMMAND_MAP.get(key);
        if (commandClass == null) {
            return null;
        }
        try {
            Constructor<? extends Command> constructor = commandClass.getConstructor(String.class, String.class);
            result = constructor.newInstance(this.getCommandPath(), key);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot initialize command " + key + ".  This is most likely a bug.", ex);
        }
        return result;
    }

    public Collection<String> getSupportedCommandKeys() {
        return COMMAND_MAP.keySet();
    }

    public String getCommandPath() {
        String commandPath = System.getProperty(COMMAND_PATH_PROPERTY_KEY);
        if (commandPath == null) {
            commandPath = Main.class.getCanonicalName();
        }
        return commandPath;
    }

    static {
        COMMAND_MAP.put("help", HelpCommand.class);
        COMMAND_MAP.put("preview", CutPreviewCommand.class);
        COMMAND_MAP.put("lint", LintCommand.class);
        COMMAND_MAP.put("info", InfoCommand.class);
        SHARED_INSTANCE = new CommandFactory();
    }
}

