/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.cfi;

import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.cfi.CFISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Text;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class CFIFactory {
    public static CFI create(String cfistr) {
        try {
            return new CFI(cfistr);
        }
        catch (CFISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CFI create(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter element cannot be null.");
        }
        Element parent = element.parent();
        if (parent == null || parent instanceof Document) {
            throw new IllegalArgumentException("Parameter element must be attached to a parent element.");
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        CFIFactory.addToInvSteps(element, invSteps);
        return CFIFactory.invStepsToCFI(invSteps);
    }

    public static CFI createRange(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter element cannot be null.");
        }
        Element parent = element.parent();
        if (parent == null || parent instanceof Document) {
            throw new IllegalArgumentException("Parameter element must be attached to a parent element.");
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        CFIFactory.addToInvSteps(element, invSteps);
        CFI start = CFIFactory.invStepsToCFI(invSteps);
        invSteps.set(0, new CFI.Text(((CFI.Step)invSteps.get(0)).index() + 1));
        CFI end = CFIFactory.invStepsToCFI(invSteps);
        return new CFI(start, end);
    }

    public static CFI create(TextNode textNode) {
        return CFIFactory.create(textNode, 0);
    }

    public static CFI create(TextNode textNode, int offset) {
        Node node;
        if (textNode == null) {
            throw new IllegalArgumentException("Parameter textNode cannot be null.");
        }
        Node parent = textNode.parent();
        if (parent == null || parent instanceof Document) {
            throw new IllegalArgumentException("Parameter textNode must be attached to a parent element.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Parameter offset must be non-negatove.");
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        int index = 0;
        for (node = textNode.previousSibling(); node != null; node = node.previousSibling()) {
            if (!(node instanceof TextNode)) continue;
            ++index;
        }
        invSteps.add(new CFI.Text(index, offset));
        node = textNode.parent();
        if (node instanceof Element) {
            CFIFactory.addToInvSteps((Element)node, invSteps);
        }
        return CFIFactory.invStepsToCFI(invSteps);
    }

    public static CFI create(CFI cfiDoc, Element element) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.create(element));
    }

    public static CFI createRange(CFI cfiDoc, Element element) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.createRange(element));
    }

    public static CFI create(CFI cfiDoc, TextNode textNode) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.create(textNode));
    }

    private static void addToInvSteps(Element element, List<CFI.Step> invSteps) {
        do {
            Element parent;
            int index = element.elementSiblingIndex();
            String assertion = element.hasAttr("id") ? element.attr("id") : "";
            invSteps.add(new CFI.Element(index, assertion));
            element = element.parent();
            if (element == null || (parent = element.parent()) != null && !(parent instanceof Document)) continue;
            element = null;
        } while (element != null);
    }

    public static CFI create(org.jdom2.Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter element cannot be null.");
        }
        org.jdom2.Element parent = element.getParentElement();
        if (parent == null) {
            throw new IllegalArgumentException("Parameter element must be attached to a parent element.");
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        CFIFactory.addToInvSteps(element, invSteps);
        return CFIFactory.invStepsToCFI(invSteps);
    }

    public static CFI createRange(org.jdom2.Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter element cannot be null.");
        }
        org.jdom2.Element parent = element.getParentElement();
        if (parent == null) {
            throw new IllegalArgumentException("Parameter element must be attached to a parent element.");
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        CFIFactory.addToInvSteps(element, invSteps);
        CFI start = CFIFactory.invStepsToCFI(invSteps);
        invSteps.set(0, new CFI.Text(((CFI.Step)invSteps.get(0)).index() + 1));
        CFI end = CFIFactory.invStepsToCFI(invSteps);
        return new CFI(start, end);
    }

    public static CFI create(Text textNode) {
        return CFIFactory.create(textNode, 0);
    }

    public static CFI create(Text textNode, int offset) {
        if (textNode == null) {
            throw new IllegalArgumentException("Parameter textNode cannot be null.");
        }
        org.jdom2.Element parent = textNode.getParentElement();
        if (parent == null) {
            throw new IllegalArgumentException("Parameter textNode must be attached to a parent element.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Parameter offset must be non-negative.");
        }
        int index = 0;
        for (Content c : parent.getContent()) {
            if (!(c instanceof Text)) continue;
            if (c.equals((Object)textNode)) break;
            ++index;
        }
        ArrayList<CFI.Step> invSteps = new ArrayList<CFI.Step>();
        invSteps.add(new CFI.Text(index, offset));
        CFIFactory.addToInvSteps(parent, invSteps);
        return CFIFactory.invStepsToCFI(invSteps);
    }

    public static CFI create(CFI cfiDoc, org.jdom2.Element element) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.create(element));
    }

    public static CFI createRange(CFI cfiDoc, org.jdom2.Element element) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.createRange(element));
    }

    public static CFI create(CFI cfiDoc, Text textNode) {
        if (cfiDoc == null) {
            throw new IllegalArgumentException("Parameter cfiDoc cannot be null.");
        }
        return cfiDoc.redirect(CFIFactory.create(textNode));
    }

    private static void addToInvSteps(org.jdom2.Element element, List<CFI.Step> invSteps) {
        do {
            org.jdom2.Element e;
            int index = 0;
            org.jdom2.Element parent = element.getParentElement();
            Iterator i$ = parent.getChildren().iterator();
            while (i$.hasNext() && !(e = (org.jdom2.Element)i$.next()).equals((Object)element)) {
                ++index;
            }
            String assertion = element.getAttributeValue("id");
            invSteps.add(new CFI.Element(index, assertion));
            element = parent;
            if (element.getParentElement() != null) continue;
            element = null;
        } while (element != null);
    }

    private static CFI invStepsToCFI(List<CFI.Step> invSteps) {
        CFI cfi = new CFI();
        for (int i = invSteps.size() - 1; i >= 0; --i) {
            cfi.add(invSteps.get(i));
        }
        return cfi;
    }
}

