/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit.cfi;

import com.apple.itunes.epubtoolkit.cfi.CFISyntaxException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.select.Elements;

public class CFI
implements Comparable<CFI>,
Iterable<Step>,
Cloneable {
    private final List<Step> steps = new ArrayList<Step>();
    private CFI start;
    private CFI end;
    private float tempOffset = -1.0f;
    private float spatOffsetX = -1.0f;
    private float spatOffsetY = -1.0f;
    private Bias bias = Bias.NONE;

    public CFI() {
    }

    @JsonCreator
    public CFI(String cfistr) throws CFISyntaxException {
        if (cfistr == null || cfistr.isEmpty()) {
            throw new IllegalArgumentException("Parameter cfistr cannot be null or empty string.");
        }
        this.parse(cfistr);
    }

    public CFI(CFI start, CFI end) {
        if (start == null || start.steps.isEmpty()) {
            throw new IllegalArgumentException("Parameter start cannot be null or empty.");
        }
        if (end == null || end.steps.isEmpty()) {
            throw new IllegalArgumentException("Parameter end cannot be null or empty.");
        }
        int cmp = start.compareTo(end);
        if (cmp >= 0) {
            throw new IllegalArgumentException("Parameter start must be less than parameter end.");
        }
        Iterator<Step> startIt = start.iterator();
        Iterator<Step> endIt = end.iterator();
        Step lastStart = null;
        Step lastEnd = null;
        while (startIt.hasNext() && endIt.hasNext()) {
            Step endStep;
            Step startStep = startIt.next();
            if (startStep.equals(endStep = endIt.next())) {
                this.steps.add(startStep);
                continue;
            }
            lastStart = startStep;
            lastEnd = endStep;
            break;
        }
        if (this.steps.isEmpty()) {
            throw new IllegalArgumentException("Parameters do not have common parent path.");
        }
        this.start = new CFI();
        this.start.steps.add(lastStart);
        while (startIt.hasNext()) {
            this.start.steps.add(startIt.next());
        }
        if (this.start.steps.isEmpty()) {
            throw new IllegalArgumentException("Parameter start does not have enough steps.");
        }
        CFI.copyState(this.start, start);
        this.end = new CFI();
        this.end.steps.add(lastEnd);
        while (endIt.hasNext()) {
            this.end.steps.add(endIt.next());
        }
        if (this.end.steps.isEmpty()) {
            throw new IllegalArgumentException("Parameter end does not have enough steps.");
        }
        CFI.copyState(this.end, end);
    }

    @Override
    public int compareTo(CFI cfi) {
        if (cfi == null) {
            throw new IllegalArgumentException("Parameter cfi cannot be null.");
        }
        Iterator<Step> mine = this.steps.iterator();
        Iterator<Step> their = cfi.steps.iterator();
        int cmp = 0;
        while (cmp == 0 && mine.hasNext() && their.hasNext()) {
            cmp = mine.next().compareTo(their.next());
        }
        if (cmp == 0) {
            cmp = !their.hasNext() ? (mine.hasNext() ? 1 : 0) : -1;
        }
        return cmp;
    }

    public CFI clone() {
        CFI cfi = new CFI();
        cfi.steps.addAll(this.steps);
        if (this.start != null) {
            cfi.start = this.start.clone();
        }
        if (this.end != null) {
            cfi.end = this.end.clone();
        }
        CFI.copyState(cfi, this);
        return cfi;
    }

    private static void copyState(CFI to, CFI from) {
        to.tempOffset = from.tempOffset;
        to.spatOffsetX = from.spatOffsetX;
        to.spatOffsetY = from.spatOffsetY;
        to.bias = from.bias;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CFI)) {
            return false;
        }
        CFI cfi = (CFI)obj;
        if (this.size() != cfi.size()) {
            return false;
        }
        Iterator<Step> mine = this.steps.iterator();
        Iterator<Step> their = cfi.steps.iterator();
        while (mine.hasNext()) {
            if (mine.next().cfiIndex() == their.next().cfiIndex()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int seed = 131;
        int hash = 0;
        for (Step s : this.steps) {
            hash = hash * seed + s.hashCode();
        }
        return hash;
    }

    @JsonValue
    public String toString() {
        if (this.steps.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("epubcfi(");
        CFI.toStringHelper(builder, this);
        return builder.append(')').toString();
    }

    private static void toStringHelper(StringBuilder builder, CFI cfi) {
        if (cfi.bias == Bias.NONE || cfi.start != null) {
            for (Step s : cfi.steps) {
                builder.append(s);
            }
            if (cfi.start != null) {
                builder.append(',');
                CFI.toStringHelper(builder, cfi.start);
                builder.append(',');
                CFI.toStringHelper(builder, cfi.end);
            }
        } else {
            for (int i = 0; i < cfi.steps.size() - 1; ++i) {
                builder.append(cfi.steps.get(i));
            }
            Step s = cfi.getLast();
            if (s instanceof Element) {
                Element e = (Element)s;
                builder.append('/').append(e.cfiIndex());
                builder.append('[').append(CFI.escape(e.id)).append(";s=").append(cfi.bias.code).append(']');
            } else if (s instanceof Text) {
                Text t = (Text)s;
                builder.append('/').append(t.cfiIndex());
                if (t.offset >= 0) {
                    builder.append(':').append(t.offset);
                }
                builder.append('[').append(CFI.escape(t.before));
                if (!t.after.isEmpty()) {
                    builder.append(',').append(CFI.escape(t.after));
                }
                builder.append(";s=").append(cfi.bias.code).append(']');
            } else {
                builder.append(s);
            }
        }
        if (cfi.tempOffset >= 0.0f) {
            builder.append('~').append(cfi.tempOffset);
        }
        if (cfi.spatOffsetX >= 0.0f && cfi.spatOffsetY >= 0.0f) {
            builder.append('@').append(cfi.spatOffsetX).append(':').append(cfi.spatOffsetY);
        }
    }

    public CFI compact() {
        CFI cfi = new CFI();
        for (Step s : this.steps) {
            if (s instanceof Element) {
                Element e = (Element)s;
                cfi.add(new Element(e.index));
                continue;
            }
            if (s instanceof Text) {
                Text t = (Text)s;
                cfi.add(new Text(t.index, t.offset));
                continue;
            }
            cfi.add(s);
        }
        CFI.copyState(cfi, this);
        return cfi;
    }

    public boolean isRange() {
        return this.start != null;
    }

    public CFI getRangeStart() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("getRangeStart() is only supported for range CFI.");
        }
        return this.start.clone();
    }

    public CFI getRangeStartAbs() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("getRangeStartAbs() is only supported for range CFI.");
        }
        return this.combine(this.start);
    }

    public CFI getRangeEnd() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("getRangeEnd() is only supported for range CFI.");
        }
        return this.end.clone();
    }

    public CFI getRangeEndAbs() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("getRangeEndAbs() is only supported for range CFI.");
        }
        return this.combine(this.end);
    }

    public CFI getRangeParent() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("getRangeParent() is only supported for range CFI.");
        }
        CFI result = new CFI();
        result.steps.addAll(this.steps);
        return result;
    }

    @Override
    public Iterator<Step> iterator() {
        return this.steps.iterator();
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public int size() {
        return this.steps.size();
    }

    public CFI add(Step step) {
        if (step == null) {
            throw new IllegalArgumentException("Parameter step cannot be null.");
        }
        if (this.lastIsText()) {
            throw new IllegalStateException("Cannot add to a text step.");
        }
        this.steps.add(step);
        return this;
    }

    public CFI addElement(int index) {
        return this.add(new Element(index));
    }

    public CFI addElement(int index, String id) {
        return this.add(new Element(index, id));
    }

    public CFI addText(int index) {
        return this.add(new Text(index));
    }

    public CFI addText(int index, int offset) {
        return this.add(new Text(index, offset));
    }

    public CFI addText(int index, int offset, String before) {
        return this.add(new Text(index, offset, before));
    }

    public CFI addText(int index, int offset, String before, String after) {
        return this.add(new Text(index, offset, before, after));
    }

    public CFI addRedirect() {
        return this.add(new Redirect());
    }

    public float getTempOffset() {
        return this.tempOffset;
    }

    public void setTempOffset(float seconds) {
        this.tempOffset = seconds;
    }

    public float getSpatOffsetX() {
        return this.spatOffsetX;
    }

    public float getSpatOffsetY() {
        return this.spatOffsetY;
    }

    public void setSpatOffset(float x, float y) {
        if (x > 100.0f) {
            throw new IllegalArgumentException("Parameter x is out of [0, 100] range");
        }
        if (y > 100.0f) {
            throw new IllegalArgumentException("Parameter y is out of [0, 100] range");
        }
        if (x < 0.0f || y < 0.0f) {
            this.spatOffsetY = -1.0f;
            this.spatOffsetX = -1.0f;
        } else {
            this.spatOffsetX = x;
            this.spatOffsetY = y;
        }
    }

    public Bias getBias() {
        return this.bias;
    }

    public void setBias(Bias bias) {
        this.bias = bias;
    }

    public Step getLast() {
        if (this.isRange()) {
            throw new UnsupportedOperationException("last() is unsupported for range CFI.");
        }
        return this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
    }

    public Step remove() {
        if (this.steps.isEmpty()) {
            return null;
        }
        return this.steps.remove(this.steps.size() - 1);
    }

    public boolean hasRedirect() {
        for (Step s : this.steps) {
            if (!(s instanceof Redirect)) continue;
            return true;
        }
        return false;
    }

    public CFI getFirstRedirect() {
        CFI cfi = new CFI();
        boolean redirectFound = false;
        for (Step s : this.steps) {
            if (s instanceof Redirect) {
                redirectFound = true;
                break;
            }
            cfi.steps.add(s);
        }
        return redirectFound ? cfi : null;
    }

    public List<CFI> getRedirects() {
        ArrayList<CFI> list = new ArrayList<CFI>();
        CFI cfi = new CFI();
        for (Step s : this.steps) {
            if (s instanceof Redirect) {
                list.add(cfi);
                cfi = new CFI();
                continue;
            }
            cfi.steps.add(s);
        }
        return list;
    }

    public CFI getRedirectTarget() {
        int startIdx = -1;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            if (!(this.steps.get(i) instanceof Redirect)) continue;
            startIdx = i + 1;
            break;
        }
        if (startIdx == -1) {
            return null;
        }
        CFI cfi = new CFI();
        for (int i = startIdx; i < this.steps.size(); ++i) {
            cfi.steps.add(this.steps.get(i));
        }
        CFI.copyState(cfi, this);
        return cfi;
    }

    public <E> E resolveToElement(E startElement) {
        Object result;
        if (startElement == null) {
            throw new IllegalArgumentException("Parameter startElement cannot be null.");
        }
        if (startElement instanceof org.jdom2.Element) {
            result = this.resolveJDOM((org.jdom2.Element)startElement);
        } else if (startElement instanceof org.jsoup.nodes.Element) {
            result = this.resolveJsoup((org.jsoup.nodes.Element)startElement);
        } else {
            throw new IllegalArgumentException("The type of startElement is not supported: " + startElement.getClass().getName());
        }
        return (E)result;
    }

    private Object resolveJDOM(org.jdom2.Element element) {
        for (Step step : this.steps) {
            if (!(step instanceof Element)) break;
            Element cfiElement = (Element)step;
            List children = element.getChildren();
            org.jdom2.Element child = null;
            boolean findById = false;
            if (cfiElement.index() < children.size()) {
                child = (org.jdom2.Element)children.get(cfiElement.index());
                if (!cfiElement.id().isEmpty() && !cfiElement.id().equals(child.getAttributeValue("id"))) {
                    findById = true;
                }
            }
            if (findById || child == null && !cfiElement.id().isEmpty()) {
                for (org.jdom2.Element e : children) {
                    if (!cfiElement.id().equals(e.getAttributeValue("id"))) continue;
                    child = e;
                    break;
                }
            }
            if (child == null) {
                return null;
            }
            element = child;
        }
        return element;
    }

    private Object resolveJsoup(org.jsoup.nodes.Element element) {
        for (Step step : this.steps) {
            if (!(step instanceof Element)) break;
            Element cfiElement = (Element)step;
            Elements children = element.children();
            org.jsoup.nodes.Element child = null;
            boolean findById = false;
            if (cfiElement.index() < children.size()) {
                child = (org.jsoup.nodes.Element)children.get(cfiElement.index());
                if (!cfiElement.id().isEmpty() && !cfiElement.id().equals(child.attr("id"))) {
                    findById = true;
                }
            }
            if (findById || child == null && !cfiElement.id().isEmpty()) {
                for (org.jsoup.nodes.Element e : children) {
                    if (!cfiElement.id().equals(e.attr("id"))) continue;
                    child = e;
                    break;
                }
            }
            if (child == null) {
                return null;
            }
            element = child;
        }
        return element;
    }

    private boolean lastIsText() {
        return !this.steps.isEmpty() && this.steps.get(this.steps.size() - 1) instanceof Text;
    }

    private static String escape(String str) {
        StringBuilder builder = null;
        int startIdx = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!CFI.isEscapeChar(ch)) continue;
            if (builder == null) {
                builder = new StringBuilder(str.substring(0, i));
            } else {
                builder.append(str.substring(startIdx, i));
            }
            builder.append('^').append(ch);
            startIdx = i + 1;
        }
        if (startIdx > 0 && startIdx < str.length()) {
            builder.append(str.substring(startIdx));
        }
        return builder == null ? str : builder.toString();
    }

    private static String unescape(String str) {
        StringBuilder builder = null;
        int startIdx = 0;
        for (int i = 0; i < str.length() - 1; ++i) {
            char ch = str.charAt(i);
            if (ch != '^') continue;
            if (builder == null) {
                builder = new StringBuilder(str.substring(0, i));
            } else {
                builder.append(str.substring(startIdx, i));
            }
            startIdx = i + 1;
            ++i;
        }
        if (startIdx > 0 && startIdx < str.length()) {
            builder.append(str.substring(startIdx));
        }
        return builder == null ? str : builder.toString();
    }

    private static boolean isEscapeChar(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '=': 
            case '[': 
            case ']': 
            case '^': {
                return true;
            }
        }
        return false;
    }

    public Step get(int index) {
        return this.steps.get(index);
    }

    public CFI redirect(CFI target) {
        if (this.isRange()) {
            throw new UnsupportedOperationException("redirect() is unsupported for CFI range.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Parameter target cannot be null.");
        }
        CFI result = new CFI();
        result.steps.addAll(this.steps);
        result.addRedirect();
        result.steps.addAll(target.steps);
        if (target.isRange()) {
            result.start = target.start.clone();
            result.end = target.end.clone();
        }
        return result;
    }

    public CFI combine(CFI cfi) {
        if (cfi == null) {
            throw new IllegalArgumentException("Parameter cfi cannot be null.");
        }
        CFI result = new CFI();
        result.steps.addAll(this.steps);
        result.steps.addAll(cfi.steps);
        if (cfi.isRange()) {
            result.start = cfi.start.clone();
            result.end = cfi.end.clone();
        } else {
            CFI.copyState(result, cfi);
        }
        return result;
    }

    public static boolean isCFI(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter str cannot be null.");
        }
        return CFIMatcher.CFI_FULL.pattern.matcher(str).matches();
    }

    private void parse(String cfistr) throws CFISyntaxException {
        try {
            Matcher m = CFIMatcher.CFI_FULL.pattern.matcher(cfistr);
            if (!m.matches()) {
                throw new CFISyntaxException(cfistr, "does not match CFI pattern");
            }
            String str = m.group(1);
            if ((m = CFIMatcher.SIMPLE_RANGE.pattern.matcher(str)).matches()) {
                CFI.parseStepsInto(this, m.group(1), cfistr);
                this.start = new CFI();
                CFI.parseStepsInto(this.start, m.group(2), cfistr);
                this.end = new CFI();
                CFI.parseStepsInto(this.end, m.group(3), cfistr);
                if (this.steps.isEmpty() || this.start.steps.isEmpty() || this.end.steps.isEmpty() || this.end.compareTo(this.start) < 0) {
                    throw new CFISyntaxException(cfistr, "invalid range");
                }
            } else {
                CFI.parseStepsInto(this, str, cfistr);
            }
        }
        catch (CFISyntaxException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw new CFISyntaxException(cfistr, "syntax error", (Throwable)e);
        }
        catch (Exception e) {
            throw new CFISyntaxException(cfistr, e);
        }
        if (this.steps.isEmpty()) {
            throw new CFISyntaxException(cfistr, "cannot parse steps");
        }
    }

    private static void parseStepsInto(CFI cfi, String str, String cfistr) throws CFISyntaxException {
        Matcher m = CFIMatcher.STEP.pattern.matcher(str);
        if (!m.matches()) {
            throw new CFISyntaxException(cfistr, "cannot find first step");
        }
        str = m.group(1);
        while ((str = CFI.parseStepInto(cfi, str)) != null && !str.isEmpty()) {
            if (cfi.bias != Bias.NONE) {
                throw new CFISyntaxException(cfistr, "unexpected \"" + str + "\" after side bias");
            }
            m = CFIMatcher.STEP.pattern.matcher(str);
            if (!m.matches()) {
                m = CFIMatcher.TEMPORAL_OFFSET.pattern.matcher(str);
                if (m.matches()) {
                    String posStr = m.group(1);
                    str = m.group(2);
                    cfi.setTempOffset(Float.parseFloat(posStr));
                }
                if (str != null && !str.isEmpty() && (m = CFIMatcher.SPATIAL_OFFSET.pattern.matcher(str)).matches()) {
                    String xStr = m.group(1);
                    String yStr = m.group(2);
                    str = null;
                    cfi.setSpatOffset(Float.parseFloat(xStr), Float.parseFloat(yStr));
                }
                if (str == null || str.isEmpty()) break;
                m = CFIMatcher.CHARACTER_OFFSET.pattern.matcher(str);
                if (m.matches()) {
                    String indexStr = m.group(1);
                    int cfiIndex = Integer.parseInt(indexStr);
                    cfi.addText(cfiIndex == 0 ? -1 : (cfiIndex - 1) / 2, 0, "", "");
                    break;
                }
                throw new CFISyntaxException(cfistr, "unexpected \"" + str + '\"');
            }
            str = m.group(1);
        }
    }

    private static String parseStepInto(CFI cfi, String str) {
        Matcher m = CFIMatcher.ELEMENT.pattern.matcher(str);
        if (m.matches()) {
            String indexStr = m.group(1);
            String id = "";
            String remained = m.group(2);
            if (remained != null && !remained.isEmpty() && (m = CFIMatcher.ELEMENT_ID.pattern.matcher(remained)).matches()) {
                id = m.group(1);
                String nextRemained = m.group(2);
                m = CFIMatcher.SIDE_BIAS.pattern.matcher(id);
                if (m.matches()) {
                    id = m.group(1);
                    cfi.bias = Bias.fromCode(m.group(2));
                }
                remained = nextRemained;
            }
            int cfiIndex = Integer.parseInt(indexStr);
            cfi.addElement(cfiIndex / 2 - 1, CFI.unescape(id));
            if (remained != null && !remained.isEmpty() && (m = CFIMatcher.INDIRECTION.pattern.matcher(remained)).matches()) {
                cfi.addRedirect();
                remained = m.group(1);
            }
            return remained;
        }
        m = CFIMatcher.TEXT_NODE.pattern.matcher(str);
        if (m.matches()) {
            int cfiIndex;
            String indexStr = m.group(1);
            String remained = m.group(2);
            String offsetStr = "0";
            if (remained != null && !remained.isEmpty() && (m = CFIMatcher.CHARACTER_OFFSET.pattern.matcher(remained)).matches()) {
                offsetStr = m.group(1);
                remained = m.group(2);
            }
            String before = "";
            String after = "";
            if (remained != null && !remained.isEmpty() && (m = CFIMatcher.TEXT_ASSERTION.pattern.matcher(remained)).matches()) {
                before = m.group(1);
                if ((m = CFIMatcher.SIDE_BIAS.pattern.matcher(before)).matches()) {
                    before = m.group(1);
                    cfi.bias = Bias.fromCode(m.group(2));
                }
                if ((m = CFIMatcher.TEXT_ASSERTION2.pattern.matcher(before)).matches()) {
                    before = m.group(1);
                    if (before == null) {
                        before = "";
                    }
                    after = m.group(2);
                }
                remained = null;
            }
            cfi.addText((cfiIndex = Integer.parseInt(indexStr)) == 0 ? -1 : (cfiIndex - 1) / 2, Integer.parseInt(offsetStr), CFI.unescape(before), CFI.unescape(after));
            return remained;
        }
        throw new IllegalStateException("caused by " + str);
    }

    private static enum CFIMatcher {
        CFI_FULL(".*epubcfi[(]([^)]*)[)]"),
        STEP("/(.*)"),
        ELEMENT("([2468]|[1-9]\\d*[02468])([^\\d].*)?"),
        TEXT_NODE("((?:[1-9]\\d*)?[13579])([^\\d].*)?"),
        ELEMENT_ID("\\[([^\\]]+)\\](.*)"),
        INDIRECTION("!(.*)"),
        CHARACTER_OFFSET(":(\\d+)([^\\d].*)?"),
        TEMPORAL_OFFSET("~([1-9]\\d*|(?:[1-9]\\d*|0)[.]\\d*)(@.*)?"),
        SPATIAL_OFFSET("@(\\d\\d?(?:[.]\\d+)?|100):(\\d\\d?(?:[.]\\d+)?|100)"),
        TEXT_ASSERTION("\\[(.+(?:,.+)?|,.+)\\]"),
        TEXT_ASSERTION2("(.+[^\\^])?,(.+)"),
        SIDE_BIAS("([^\\]]*);s=([ab])"),
        SIMPLE_RANGE("([^\\]]*(?:\\[.*\\][^\\]]*)*),([^\\]]*(?:\\[.*\\][^\\]]*)*),([^\\]]*(?:\\[.*\\][^\\]]*)*)");

        public Pattern pattern;

        private CFIMatcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }
    }

    public static enum Bias {
        NONE(""),
        BEFORE("b"),
        AFTER("a");

        private final String code;

        private Bias(String code) {
            this.code = code;
        }

        private static Bias fromCode(String code) {
            if ("b".equals(code)) {
                return BEFORE;
            }
            if ("a".equals(code)) {
                return AFTER;
            }
            return NONE;
        }
    }

    public static class Redirect
    extends Step {
        public Redirect() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public int cfiIndex() {
            return this.index;
        }

        @Override
        public String toString() {
            return "!";
        }
    }

    public static class Text
    extends Step {
        private final int offset;
        private final String before;
        private final String after;

        public Text(int index) {
            this(index, 0, "", "");
        }

        public Text(int index, int offset) {
            this(index, offset, "", "");
        }

        public Text(int index, int offset, String before) {
            this(index, offset, before, "");
        }

        public Text(int index, int offset, String before, String after) {
            if (offset < 0) {
                throw new IllegalArgumentException("Parameter offset must be greater or equal to zero.");
            }
            this.index = index < 0 ? -1 : index;
            this.offset = index < 0 ? 0 : offset;
            this.before = before == null ? "" : before;
            this.after = after == null ? "" : after;
        }

        @Override
        public int cfiIndex() {
            return this.index < 0 ? 0 : this.index * 2 + 1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            if (this.offset > 0) {
                builder.append(':').append(this.offset);
            }
            if (!this.before.isEmpty() || !this.after.isEmpty()) {
                builder.append('[');
                if (!this.before.isEmpty()) {
                    builder.append(CFI.escape(this.before));
                }
                if (!this.after.isEmpty()) {
                    builder.append(',').append(CFI.escape(this.after));
                }
                builder.append(']');
            }
            return builder.toString();
        }

        @Override
        public int compareTo(Step other) {
            int cmp = super.compareTo(other);
            return cmp == 0 && other instanceof Text ? this.offset - ((Text)other).offset : cmp;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Text) {
                Text other = (Text)o;
                return super.equals(other) && this.offset == other.offset;
            }
            return false;
        }

        public int offset() {
            return this.offset;
        }

        public String before() {
            return this.before;
        }

        public String after() {
            return this.after;
        }
    }

    public static class Element
    extends Step {
        private final String id;
        private final int offset;

        public Element(int index) {
            this(index, "", -1);
        }

        public Element(int index, String id) {
            this(index, id, -1);
        }

        public Element(int index, String id, int offset) {
            if (index < 0) {
                throw new IllegalArgumentException("Index must be greater or equal to zero.");
            }
            this.index = index;
            this.id = id == null ? "" : id;
            this.offset = offset;
        }

        @Override
        public int cfiIndex() {
            return (this.index + 1) * 2;
        }

        @Override
        public String toString() {
            String str = super.toString();
            if (this.offset >= 0) {
                str = str + ":" + this.offset;
            }
            return this.id.isEmpty() ? str : str + '[' + CFI.escape(this.id) + ']';
        }

        @Override
        public int compareTo(Step other) {
            int cmp = super.compareTo(other);
            return cmp == 0 && other instanceof Element ? this.offset - ((Element)other).offset : cmp;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element other = (Element)o;
                return super.equals(other) && this.offset == other.offset;
            }
            return false;
        }

        public String id() {
            return this.id;
        }

        public int offset() {
            return this.offset;
        }
    }

    public static abstract class Step
    implements Comparable<Step> {
        protected int index;

        public int index() {
            return this.index;
        }

        public abstract int cfiIndex();

        @Override
        public int compareTo(Step s) {
            return this.cfiIndex() - s.cfiIndex();
        }

        public boolean equals(Object o) {
            return o instanceof Step && ((Step)o).cfiIndex() == this.cfiIndex();
        }

        public int hashCode() {
            return this.cfiIndex();
        }

        public String toString() {
            return "/" + this.cfiIndex();
        }
    }
}

