/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XHTMLTagFinderSAXHandler
extends XHTMLSAXHandler {
    private List<String> tagList = new ArrayList<String>();
    private boolean exists = false;

    public XHTMLTagFinderSAXHandler(String ... tags) {
        for (String tag : tags) {
            this.tagList.add(tag.toLowerCase());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.exists) {
            return;
        }
        localName = localName == null ? "" : localName.toLowerCase();
        qName = qName == null ? "" : qName.toLowerCase();
        String localNameNoNS = localName.substring(localName.lastIndexOf(":") + 1);
        String qNameNoNS = qName.substring(qName.lastIndexOf(":") + 1);
        for (String tag : this.tagList) {
            if (tag == null) continue;
            if (tag.indexOf(":") >= 0) {
                if (!tag.equals(localName) && !tag.equals(qName)) continue;
                this.exists = true;
                break;
            }
            if (!tag.equals(localNameNoNS) && !tag.equals(qNameNoNS)) continue;
            this.exists = true;
            break;
        }
    }

    public boolean hasTag() {
        return this.exists;
    }
}

