/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public abstract class XHTMLSAXHandler
extends DefaultHandler2 {
    protected static final Pattern REFERENCE_SOURCE_ATTRIBUTE_NAME_PATTERN = Pattern.compile("src|href|definitionURL|altimg|cdgroup|data", 2);
    protected static final Pattern REFERENCE_TARGET_ATTRIBUTE_NAME_PATTERN = Pattern.compile("name|id", 2);
    protected static final Pattern REFERENCE_TARGET_ELEMENT_NAME_PATTERN = Pattern.compile("a", 2);
    protected static final String PARSER_PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    protected static final String PARSER_PROPERTY_DTD_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private XMLOutputter xmlOutputter = new XMLOutputter(Format.getRawFormat().setLineSeparator("\n"));

    public SAXParser createParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.setProperty(PARSER_PROPERTY_LEXICAL_HANDLER, this);
        parser.setProperty(PARSER_PROPERTY_DTD_HANDLER, this);
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        reader.setFeature("http://apache.org/xml/features/validation/schema", false);
        reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        reader.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
        reader.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", false);
        reader.setFeature("http://apache.org/xml/features/generate-synthetic-annotations", false);
        reader.setFeature("http://apache.org/xml/features/validate-annotations", false);
        reader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", false);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://xml.org/sax/features/namespaces", false);
        reader.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        reader.setFeature("http://apache.org/xml/features/xinclude/fixup-language", false);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
        return parser;
    }

    protected static boolean isReferenceAttribute(String name, String value) {
        if (value == null) {
            return false;
        }
        if (name != null && name.contains(":")) {
            name = name.substring(name.indexOf(":") + 1);
        }
        return REFERENCE_SOURCE_ATTRIBUTE_NAME_PATTERN.matcher(name).matches() && !value.toLowerCase().startsWith("data:");
    }

    protected static boolean isReferenceDestinationAttribute(String name, String value) {
        return REFERENCE_TARGET_ATTRIBUTE_NAME_PATTERN.matcher(name).matches();
    }

    protected static boolean isReferenceDestinationElement(String name) {
        return REFERENCE_TARGET_ELEMENT_NAME_PATTERN.matcher(name).matches();
    }

    protected static boolean isTag(String localName, String qName, String tagName) {
        if (qName != null && qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        boolean isTag = tagName.equalsIgnoreCase(localName) || tagName.equalsIgnoreCase(qName);
        return isTag;
    }

    protected static boolean isAnchor(String localName, String qName) {
        if (qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        return XHTMLSAXHandler.isTag(localName, qName, "a") || XHTMLSAXHandler.isTag(localName, qName, "applet") || XHTMLSAXHandler.isTag(localName, qName, "form") || XHTMLSAXHandler.isTag(localName, qName, "frame") || XHTMLSAXHandler.isTag(localName, qName, "iframe") || XHTMLSAXHandler.isTag(localName, qName, "img") || XHTMLSAXHandler.isTag(localName, qName, "map") || XHTMLSAXHandler.isTag(localName, qName, "audio") || XHTMLSAXHandler.isTag(localName, qName, "video");
    }

    protected static boolean isAudioOrVideo(String localName, String qName) {
        if (qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        return XHTMLSAXHandler.isTag(localName, qName, "audio") || XHTMLSAXHandler.isTag(localName, qName, "video");
    }

    protected static String getReferenceAttributeName(String localName, String qName) {
        if (XHTMLSAXHandler.isAudioOrVideo(localName, qName)) {
            return "src";
        }
        return "href";
    }

    protected String escapeAttributeEntities(String s) {
        if (s == null) {
            return s;
        }
        return this.xmlOutputter.escapeAttributeEntities(s);
    }

    protected String escapeElementEntities(String s) {
        if (s == null) {
            return s;
        }
        return this.xmlOutputter.escapeElementEntities(s);
    }
}

