/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBPreviewCutterThreshold;
import com.apple.itunes.epubtoolkit.XHTMLCutterSAXHandler;
import com.apple.itunes.epubtoolkit.XHTMLReferenceFinderSAXHandler;
import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.XHTMLAnchorMemento;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public class XHTMLReferenceScrubberSAXHandler
extends XHTMLCutterSAXHandler {
    private static final Pattern REFERENCE_ATTRIBUTE_VALUE_PATTERN = Pattern.compile("([^#]+?)[#](.+?)", 2);
    private static final Pattern HTML_REFERENCE_PATTERN = Pattern.compile(".+\\.(x?html?|xml)([#?].*)?", 2);
    private File root;
    private File file;
    private String scrubValue;
    private EPUBPreviewCutterThreshold threshold;
    private EPUBModel model;

    public XHTMLReferenceScrubberSAXHandler() {
        super(Integer.MAX_VALUE, null);
    }

    @Override
    protected void appendElementAttributes(StringBuilder builder, String uri, String localName, String qName, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            boolean isReference;
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            boolean isAnchorTag = XHTMLReferenceFinderSAXHandler.isAnchor(localName, qName);
            boolean isContentTag = XHTMLReferenceFinderSAXHandler.isTag(localName, qName, "content");
            if ((isAnchorTag || isContentTag) && (isReference = XHTMLReferenceFinderSAXHandler.isReferenceAttribute(attributeName, attributeValue))) {
                if (CFI.isCFI(attributeValue)) {
                    try {
                        CFI cfi = new CFI(attributeValue);
                        OPFManifestItem item = this.model.getOPF().getManifestItem(cfi);
                        attributeValue = item.getSpineItem().getCFI().toString();
                    }
                    catch (Exception e) {
                        attributeValue = FileUtilities.cleanURL(this.getScrubValue());
                    }
                } else {
                    boolean isAvailable = this.isResourceAvailable(attributeValue);
                    attributeValue = !isAvailable && XHTMLReferenceScrubberSAXHandler.isHtmlReference(attributeValue) ? this.getScrubValue() : attributeValue.trim();
                    attributeValue = FileUtilities.cleanURL(attributeValue);
                }
            }
            builder.append(" ");
            builder.append(attributeName);
            builder.append("=\"");
            builder.append(this.escapeAttributeEntities(attributeValue));
            builder.append("\"");
        }
    }

    static boolean isHtmlReference(String str) {
        return str != null && (str.startsWith("#") || HTML_REFERENCE_PATTERN.matcher(str).matches());
    }

    protected boolean isResourceAvailable(String originalReference) {
        return XHTMLReferenceScrubberSAXHandler.isResourceAvailable(this.root, this.threshold, this.file, originalReference);
    }

    public static boolean isResourceAvailable(File root, EPUBPreviewCutterThreshold threshold, File scrubFile, String originalReference) {
        String unescapedReference = FileUtilities.decodeURIPath(originalReference).trim();
        if (unescapedReference.equals("#")) {
            return true;
        }
        if (unescapedReference.startsWith("#")) {
            if (threshold == null || threshold.getLocalCharLimit() < 0L) {
                return true;
            }
            String anchorId = unescapedReference.substring(1);
            return XHTMLReferenceScrubberSAXHandler.isAnchorAvailable(threshold, anchorId, scrubFile);
        }
        boolean isAbsolute = unescapedReference.startsWith("/");
        Matcher matcher = REFERENCE_ATTRIBUTE_VALUE_PATTERN.matcher(unescapedReference);
        boolean matches = matcher.matches();
        String fileName = matches ? matcher.group(1) : unescapedReference;
        String anchorId = matches ? matcher.group(2) : null;
        File file = isAbsolute ? new File(root, fileName) : new File(scrubFile.getParent(), fileName);
        boolean exists = file.exists();
        if (exists) {
            return XHTMLReferenceScrubberSAXHandler.isAnchorAvailable(threshold, anchorId, file);
        }
        try {
            URI uri = new URI(originalReference);
            return uri.isAbsolute() && (uri.getScheme().equals("http") || uri.getScheme().equals("https") || uri.getScheme().equals("ftp"));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected static boolean isAnchorAvailable(EPUBPreviewCutterThreshold threshold, String anchorId, File targetFile) {
        boolean sameFile;
        if (anchorId == null || anchorId.equals("")) {
            return targetFile.exists();
        }
        if (threshold == null) {
            return true;
        }
        File thresholdFile = threshold.getAnalysis().getFile();
        try {
            sameFile = thresholdFile.getCanonicalPath().equals(targetFile.getCanonicalPath());
        }
        catch (IOException e) {
            sameFile = thresholdFile.equals(targetFile);
        }
        if (thresholdFile != null && sameFile) {
            boolean isAnchorPresent;
            Map<String, XHTMLAnchorMemento> anchorMementos = threshold.getAnalysis().getAnchorMementos();
            XHTMLAnchorMemento anchorMemento = anchorMementos.get(anchorId);
            boolean bl = isAnchorPresent = anchorMemento != null;
            if (!isAnchorPresent) {
                return false;
            }
            Long fileCharLimit = threshold.getLocalCharLimit();
            if (fileCharLimit == null) {
                return true;
            }
            long anchorCharCountLocation = anchorMemento.getCharCountOffset();
            return anchorCharCountLocation < fileCharLimit;
        }
        return true;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected File getRoot() {
        return this.root;
    }

    protected void setRoot(File root) {
        this.root = root;
    }

    protected String getScrubValue() {
        return this.scrubValue;
    }

    protected void setScrubValue(String scrubValue) {
        this.scrubValue = scrubValue;
    }

    protected EPUBPreviewCutterThreshold getThreshold() {
        return this.threshold;
    }

    protected void setThreshold(EPUBPreviewCutterThreshold threshold) {
        this.threshold = threshold;
    }

    public void setEpubModel(EPUBModel model) {
        this.model = model;
    }
}

