/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBPreviewCutterThreshold;
import com.apple.itunes.epubtoolkit.XHTMLReferenceScrubberSAXHandler;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.helpers.DefaultHandler;

public class XHTMLReferenceScrubber {
    private File root;
    private File file;
    private String scrubValue;
    private EPUBPreviewCutterThreshold threshold;
    private final EPUBModel model;

    public XHTMLReferenceScrubber(File root, File file, String scrubValue, EPUBPreviewCutterThreshold threshold, EPUBModel model) {
        this.root = root;
        this.file = file;
        this.scrubValue = scrubValue;
        this.threshold = threshold;
        this.model = model;
    }

    public void scrub() throws EPUBException {
        XHTMLReferenceScrubberSAXHandler handler = new XHTMLReferenceScrubberSAXHandler();
        handler.setRoot(this.root);
        handler.setFile(this.file);
        handler.setScrubValue(this.scrubValue);
        handler.setThreshold(this.threshold);
        handler.setEpubModel(this.model);
        this.scrub(handler);
        String output = handler.getOutput();
        try {
            FileUtilities.write(this.file, output, handler.getEncoding());
        }
        catch (IOException e) {
            throw new EPUBException("Unable to write scrubbed " + this.file.getName() + " to disk:\n" + output, e);
        }
    }

    private void scrub(XHTMLReferenceScrubberSAXHandler handler) throws EPUBException {
        SAXParser parser;
        try {
            parser = handler.createParser();
        }
        catch (Exception ex) {
            throw new EPUBException("Unable to create parser for " + this.file.getName(), ex);
        }
        try {
            parser.parse(this.file, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            throw new EPUBException("Unable to parse " + this.file.getName(), ex);
        }
    }
}

