/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.cfi.CFISyntaxException;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class XHTMLReferenceFinderSAXHandler
extends XHTMLSAXHandler {
    private String searchValue;
    private boolean isSearchValuePresent;
    private boolean decode;
    private OPFManifestItem searchItem;

    public XHTMLReferenceFinderSAXHandler(String searchValue, OPFManifestItem searchItem, boolean decode) {
        this.searchValue = searchValue;
        this.isSearchValuePresent = false;
        this.decode = decode;
        this.searchItem = searchItem;
    }

    public boolean isSearchValuePresent() {
        return this.isSearchValuePresent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeValue;
            String attributeName = attributes.getQName(i);
            boolean isReference = XHTMLReferenceFinderSAXHandler.isReferenceAttribute(attributeName, attributeValue = attributes.getValue(i));
            if (!isReference) continue;
            boolean contains = false;
            if (CFI.isCFI(attributeValue)) {
                try {
                    CFI cfi = new CFI(attributeValue);
                    OPFManifestItem item = this.searchItem.getOPF().getManifestItem(cfi);
                    contains = item != null && item.getId().equals(this.searchItem.getId());
                }
                catch (CFISyntaxException e) {}
            } else {
                if (this.decode) {
                    attributeValue = FileUtilities.decodeURIPath(attributeValue);
                }
                contains = attributeValue.contains(this.searchValue);
            }
            this.isSearchValuePresent |= contains;
        }
    }
}

