/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.XHTMLAnalyzerSAXHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

class XHTMLFileEndCutterSAXHandler
extends XHTMLAnalyzerSAXHandler {
    protected static final Pattern ENTITY_PATTERN = Pattern.compile("([a-zA-Z]+)|([#][a-fA-F0-9]+)");
    private static Set<String> DEFAULT_XML_ENTITIES = new HashSet<String>();
    private Map<String, String> prefixMap = new HashMap<String, String>();
    private StringBuilder outputBuffer = new StringBuilder();
    private Locator locator = null;
    private String xmlVersion = null;
    private String encoding = null;
    private boolean isInCDATA = false;
    private List<String> endAnchors;
    private List<String> entities = new ArrayList<String>();

    public XHTMLFileEndCutterSAXHandler(List<String> endAnchors) {
        this.endAnchors = endAnchors;
    }

    public String getOutput() {
        return this.outputBuffer.toString();
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        return this.encoding;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
        if (locator instanceof Locator2) {
            Locator2 loc = (Locator2)locator;
            this.xmlVersion = loc.getXMLVersion();
            this.encoding = loc.getEncoding();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.prefixMap.put(uri, prefix);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.xmlVersion != null && this.encoding != null) {
            Locator2 loc = (Locator2)this.locator;
            this.outputBuffer.append("<?xml version=\"");
            this.outputBuffer.append(this.xmlVersion);
            this.outputBuffer.append("\" encoding=\"");
            this.outputBuffer.append(this.encoding);
            this.outputBuffer.append("\"?>\n");
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.entities = new ArrayList<String>();
        this.outputBuffer.append("<!DOCTYPE ");
        this.outputBuffer.append(name);
        boolean hasPublic = false;
        if (publicId != null && !publicId.equalsIgnoreCase("null")) {
            this.outputBuffer.append(" PUBLIC \"").append(publicId).append("\"");
            hasPublic = true;
        }
        if (systemId != null && !systemId.equalsIgnoreCase("null")) {
            if (!hasPublic) {
                this.outputBuffer.append(" SYSTEM ");
            }
            this.outputBuffer.append(" \"").append(systemId).append("\"");
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (value != null && value.equals("&")) {
            value = "&#38;";
        }
        this.entities.add("<!ENTITY " + name + " \"" + value + "\">");
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.entities.size() > 0) {
            this.outputBuffer.append(" [ ");
            for (String entity : this.entities) {
                this.outputBuffer.append(entity + " ");
            }
            this.outputBuffer.append("]");
        }
        this.outputBuffer.append(">\n");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.outputBuffer.append("<");
        this.outputBuffer.append(qName);
        this.appendElementAttributes(this.outputBuffer, uri, localName, qName, attributes);
        this.outputBuffer.append(">");
    }

    protected void appendElementAttributes(StringBuilder builder, String uri, String localName, String qName, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            builder.append(" ");
            builder.append(attributeName);
            builder.append("=\"");
            builder.append(this.escapeAttributeEntities(attributeValue));
            builder.append("\"");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        boolean isBody = this.isBodyContainer(localName, qName);
        if (isBody && this.endAnchors != null) {
            this.outputBuffer.append("<p>");
            for (String anchor : this.endAnchors) {
                this.outputBuffer.append("<a id=\"");
                this.outputBuffer.append(this.escapeAttributeEntities(anchor));
                this.outputBuffer.append("\"/>");
            }
            this.outputBuffer.append("</p>");
        }
        this.emitEndElement(qName);
    }

    private boolean isBodyContainer(String localName, String qName) {
        boolean isBody = XHTMLFileEndCutterSAXHandler.isTag(localName, qName, "body");
        return isBody;
    }

    private void emitEndElement(String qName) {
        this.outputBuffer.append("</");
        this.outputBuffer.append(qName);
        this.outputBuffer.append(">");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        String value = new String(ch, start, length);
        if (this.isInCDATA) {
            this.outputBuffer.append(value);
        } else {
            this.outputBuffer.append(this.escapeElementEntities(value));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        this.outputBuffer.append(value);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isInCDATA = true;
        this.outputBuffer.append("<![CDATA[");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.isInCDATA = false;
        this.outputBuffer.append("]]>");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!ENTITY_PATTERN.matcher(name).matches()) {
            return;
        }
        if (DEFAULT_XML_ENTITIES.contains(name.toLowerCase())) {
            return;
        }
        this.outputBuffer.append("&");
        this.outputBuffer.append(name);
        this.outputBuffer.append(";");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.outputBuffer.append("&");
        this.outputBuffer.append(name);
        this.outputBuffer.append(";");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        this.outputBuffer.append("<!--");
        this.outputBuffer.append(this.escapeElementEntities(value));
        this.outputBuffer.append("-->");
    }

    static {
        DEFAULT_XML_ENTITIES.add("amp");
        DEFAULT_XML_ENTITIES.add("apos");
        DEFAULT_XML_ENTITIES.add("gt");
        DEFAULT_XML_ENTITIES.add("lt");
        DEFAULT_XML_ENTITIES.add("quot");
    }
}

