/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.XHTMLAnalyzerSAXHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

class XHTMLCutterSAXHandler
extends XHTMLAnalyzerSAXHandler {
    protected static final Pattern ENTITY_PATTERN = Pattern.compile("([a-zA-Z]+)|([#][a-fA-F0-9]+)");
    private static Set<String> DEFAULT_XML_ENTITIES = new HashSet<String>();
    private Map<String, String> prefixMap = new HashMap<String, String>();
    private List<String> elementStack = new ArrayList<String>();
    private List<String> deletedAnchorNames = new ArrayList<String>();
    private StringBuilder outputBuffer = new StringBuilder();
    private boolean isOutputEnabled = true;
    private Locator locator = null;
    private long charLimit = 0L;
    private String xmlVersion = null;
    private String encoding = null;
    private boolean isInCDATA = false;
    private List<String> endAnchors;
    private List<String> entities = new ArrayList<String>();
    private boolean currentlyParsingDTD = false;

    public XHTMLCutterSAXHandler(long charLimit, List<String> endAnchors) {
        this.charLimit = charLimit;
        this.endAnchors = endAnchors;
    }

    protected boolean hasReachedCharLimit() {
        long charCount = this.getCharacterCount();
        return charCount >= this.charLimit;
    }

    public String getOutput() {
        return this.outputBuffer.toString();
    }

    public List<String> getDeletedAnchorNames() {
        return new ArrayList<String>(this.deletedAnchorNames);
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        return this.encoding;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
        if (locator instanceof Locator2) {
            Locator2 loc = (Locator2)locator;
            this.xmlVersion = loc.getXMLVersion();
            this.encoding = loc.getEncoding();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.prefixMap.put(uri, prefix);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.xmlVersion != null && this.encoding != null) {
            Locator2 loc = (Locator2)this.locator;
            this.outputBuffer.append("<?xml version=\"");
            this.outputBuffer.append(this.xmlVersion);
            this.outputBuffer.append("\" encoding=\"");
            this.outputBuffer.append(this.encoding);
            this.outputBuffer.append("\"?>\n");
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.currentlyParsingDTD = true;
        this.entities = new ArrayList<String>();
        this.outputBuffer.append("<!DOCTYPE ");
        this.outputBuffer.append(name);
        boolean hasPublic = false;
        if (publicId != null && !publicId.equalsIgnoreCase("null")) {
            this.outputBuffer.append(" PUBLIC \"").append(publicId).append("\"");
            hasPublic = true;
        }
        if (systemId != null && !systemId.equalsIgnoreCase("null")) {
            if (!hasPublic) {
                this.outputBuffer.append(" SYSTEM ");
            }
            this.outputBuffer.append(" \"").append(systemId).append("\"");
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (value != null && value.equals("&")) {
            value = "&#38;";
        }
        this.entities.add("<!ENTITY " + name + " \"" + value + "\">");
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.entities.size() > 0) {
            this.outputBuffer.append(" [ ");
            for (String entity : this.entities) {
                this.outputBuffer.append(entity + " ");
            }
            this.outputBuffer.append("]");
        }
        this.outputBuffer.append(">\n");
        this.currentlyParsingDTD = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (!this.isOutputEnabled) {
            this.appendDeletedAnchors(this.outputBuffer, uri, localName, qName, attributes);
            return;
        }
        this.pushElement(qName);
        this.outputBuffer.append("<");
        this.outputBuffer.append(qName);
        this.appendElementAttributes(this.outputBuffer, uri, localName, qName, attributes);
        this.outputBuffer.append(">");
    }

    protected void appendDeletedAnchors(StringBuilder builder, String uri, String localName, String qName, Attributes attributes) {
        boolean isAnchor = XHTMLCutterSAXHandler.isAnchor(localName, qName);
        if (!isAnchor) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            if (!"name".equalsIgnoreCase(attributeName) && !"id".equalsIgnoreCase(attributeName)) continue;
            String attributeValue = attributes.getValue(i);
            this.deletedAnchorNames.add(attributeValue);
        }
    }

    protected void appendElementAttributes(StringBuilder builder, String uri, String localName, String qName, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            builder.append(" ");
            builder.append(attributeName);
            builder.append("=\"");
            builder.append(this.escapeAttributeEntities(attributeValue));
            builder.append("\"");
        }
    }

    private boolean canCutHere(String localName, String qName) {
        boolean isWordContainer = this.isWordContainer(localName, qName);
        boolean isBody = this.isBodyContainer(localName, qName);
        if (!isWordContainer && !isBody) {
            return false;
        }
        if (!this.bodyExistsInStack()) {
            return false;
        }
        return !this.elementStack.contains("table");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (!this.isOutputEnabled) {
            return;
        }
        if (!this.canCutHere(localName, qName)) {
            this.emitEndElement(qName);
        } else {
            boolean hasReachedCharLimit = this.hasReachedCharLimit();
            if (!hasReachedCharLimit) {
                this.emitEndElement(qName);
            } else {
                if (this.endAnchors != null) {
                    boolean shouldCloseElement;
                    boolean bl = shouldCloseElement = this.isWordContainer(localName, qName) || this.anchorExistsInStack();
                    while (shouldCloseElement) {
                        String elementName = this.popElement();
                        this.outputBuffer.append("</");
                        this.outputBuffer.append(elementName);
                        this.outputBuffer.append(">");
                        shouldCloseElement = this.anchorExistsInStack();
                    }
                    this.outputBuffer.append("<p>");
                    for (String anchor : this.endAnchors) {
                        this.outputBuffer.append("<a id=\"");
                        this.outputBuffer.append(this.escapeAttributeEntities(anchor));
                        this.outputBuffer.append("\"/>");
                    }
                    this.outputBuffer.append("</p>");
                }
                String elementName = this.popElement();
                while (elementName != null) {
                    this.outputBuffer.append("</");
                    this.outputBuffer.append(elementName);
                    this.outputBuffer.append(">");
                    elementName = this.popElement();
                }
            }
            this.isOutputEnabled = !hasReachedCharLimit;
        }
    }

    private boolean isWordContainer(String localName, String qName) {
        boolean isParagraph = XHTMLCutterSAXHandler.isTag(localName, qName, "p");
        boolean isDiv = XHTMLCutterSAXHandler.isTag(localName, qName, "div");
        return isParagraph || isDiv;
    }

    private boolean isBodyContainer(String localName, String qName) {
        boolean isBody = XHTMLCutterSAXHandler.isTag(localName, qName, "body");
        return isBody;
    }

    private void emitEndElement(String qName) {
        this.outputBuffer.append("</");
        this.outputBuffer.append(qName);
        this.outputBuffer.append(">");
        this.popElement();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (!this.isOutputEnabled) {
            return;
        }
        String value = new String(ch, start, length);
        if (this.isInCDATA) {
            this.outputBuffer.append(value);
        } else {
            this.outputBuffer.append(this.escapeElementEntities(value));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.isOutputEnabled) {
            return;
        }
        String value = new String(ch, start, length);
        this.outputBuffer.append(value);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isInCDATA = true;
        if (!this.isOutputEnabled) {
            return;
        }
        this.outputBuffer.append("<![CDATA[");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.isInCDATA = false;
        if (!this.isOutputEnabled) {
            return;
        }
        this.outputBuffer.append("]]>");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.isOutputEnabled) {
            return;
        }
        if (!ENTITY_PATTERN.matcher(name).matches()) {
            return;
        }
        if (DEFAULT_XML_ENTITIES.contains(name.toLowerCase())) {
            return;
        }
        this.outputBuffer.append("&");
        this.outputBuffer.append(name);
        this.outputBuffer.append(";");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.isOutputEnabled) {
            return;
        }
        this.outputBuffer.append("&");
        this.outputBuffer.append(name);
        this.outputBuffer.append(";");
    }

    private void pushElement(String name) {
        this.elementStack.add(name);
    }

    private String peekElement() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        return this.elementStack.get(this.elementStack.size() - 1);
    }

    private String popElement() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        int index = this.elementStack.size() - 1;
        String result = this.elementStack.get(index);
        this.elementStack.remove(index);
        return result;
    }

    private boolean anchorExistsInStack() {
        return this.elementStack.contains("a");
    }

    private boolean bodyExistsInStack() {
        return this.elementStack.contains("body");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.currentlyParsingDTD) {
            return;
        }
        String value = new String(ch, start, length);
        this.outputBuffer.append("<!--");
        this.outputBuffer.append(this.escapeElementEntities(value));
        this.outputBuffer.append("-->");
    }

    static {
        DEFAULT_XML_ENTITIES.add("amp");
        DEFAULT_XML_ENTITIES.add("apos");
        DEFAULT_XML_ENTITIES.add("gt");
        DEFAULT_XML_ENTITIES.add("lt");
        DEFAULT_XML_ENTITIES.add("quot");
    }
}

