/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.XHTMLCutterSAXHandler;
import com.apple.itunes.epubtoolkit.XHTMLFileEndCutterSAXHandler;
import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import com.apple.itunes.epubtoolkit.util.DocumentInputSource;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

final class XHTMLCutter {
    private long charLimit = -1L;
    private File spineItemFile;
    private List<String> endAnchors;

    XHTMLCutter(long charLimit, File spineItemFile, List<String> endAnchors) {
        this.charLimit = charLimit;
        this.spineItemFile = spineItemFile;
        this.endAnchors = endAnchors;
    }

    XHTMLCutter(File spineItemFile, List<String> endAnchors) {
        this.spineItemFile = spineItemFile;
        this.endAnchors = endAnchors;
    }

    public List<String> cut() throws EPUBException {
        XHTMLCutterSAXHandler handler = new XHTMLCutterSAXHandler(this.charLimit, this.endAnchors);
        this.cutContent(handler);
        String output = handler.getOutput();
        try {
            FileUtilities.write(this.spineItemFile, output, handler.getEncoding());
        }
        catch (IOException e) {
            throw new EPUBException("Unable to write cut " + this.spineItemFile.getName() + " to disk:\n" + output, e);
        }
        return handler.getDeletedAnchorNames();
    }

    public void cutAtEnd() throws EPUBException {
        XHTMLFileEndCutterSAXHandler handler = new XHTMLFileEndCutterSAXHandler(this.endAnchors);
        this.cutContent(handler);
        String output = handler.getOutput();
        try {
            FileUtilities.write(this.spineItemFile, output, handler.getEncoding());
        }
        catch (IOException e) {
            throw new EPUBException("Unable to write cut " + this.spineItemFile.getName() + " to disk:\n" + output, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutContent(XHTMLSAXHandler handler) throws EPUBException, RuntimeException {
        SAXParser parser;
        try {
            parser = handler.createParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error while trying to create parser to cut: " + this.spineItemFile.getName(), e);
        }
        try {
            DocumentInputSource inputSource = new DocumentInputSource(this.spineItemFile);
            try {
                parser.parse((InputSource)inputSource, (DefaultHandler)handler);
            }
            finally {
                if (inputSource != null) {
                    inputSource.cleanup();
                }
            }
        }
        catch (Exception e) {
            throw new EPUBException("Unable to cut: " + this.spineItemFile.getName(), e);
        }
    }
}

