/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import com.apple.itunes.epubtoolkit.model.XHTMLAnchorMemento;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XHTMLAnalyzerSAXHandler
extends XHTMLSAXHandler {
    private int saxParseExceptionLine = -1;
    private int saxParseExceptionColumn = -1;
    private static final Logger logger = Logger.getLogger(XHTMLAnalyzerSAXHandler.class);
    private static final Set<Character> PUNCTUATION_CHARSET = new HashSet<Character>();
    private int wordCount;
    private long characterCount;
    private boolean inWord;
    private int excludeElement = 0;
    private boolean hasITunesArtworkHrefAtRoot = false;
    private boolean inBody = false;
    private File xhtmlFile = null;
    private File iTunesArtworkAtRoot = null;
    private Map<String, XHTMLAnchorMemento> anchorMementos = new HashMap<String, XHTMLAnchorMemento>();
    private List<String> missingReferencedFiles = new ArrayList<String>();

    public XHTMLAnalyzerSAXHandler() {
    }

    public XHTMLAnalyzerSAXHandler(File xhtmlFile, File iTunesArtworkAtRoot) {
        this.xhtmlFile = xhtmlFile;
        this.iTunesArtworkAtRoot = iTunesArtworkAtRoot;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.inWord = false;
        if (this.isExcludeElement(localName, qName)) {
            ++this.excludeElement;
        }
        if (XHTMLAnalyzerSAXHandler.isAnchor(localName, qName)) {
            String id;
            String href = attributes.getValue(XHTMLAnalyzerSAXHandler.getReferenceAttributeName(localName, qName));
            if (href != null && this.xhtmlFile != null && this.iTunesArtworkAtRoot != null && href.indexOf(":") < 0) {
                try {
                    URI hrefURI = new URI(href);
                    if (hrefURI.getScheme() == null) {
                        File referencedFile = new File(this.xhtmlFile.getParentFile(), FileUtilities.decodeURIPath(href));
                        if (!referencedFile.exists() && XHTMLAnalyzerSAXHandler.isAudioOrVideo(localName, qName)) {
                            this.missingReferencedFiles.add(referencedFile.getName());
                        } else {
                            String referencedFileCanonicalPath;
                            String iTunesArtworkAtRootCanonicalPath = this.iTunesArtworkAtRoot.getCanonicalPath();
                            if (iTunesArtworkAtRootCanonicalPath.equals(referencedFileCanonicalPath = referencedFile.getCanonicalPath())) {
                                this.hasITunesArtworkHrefAtRoot = true;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"CANNOT_GET_CANONICAL_PATH", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    logger.warn((Object)"CANNOT_GET_CANONICAL_PATH", (Throwable)e);
                }
            }
            if ((id = attributes.getValue("id")) == null) {
                id = attributes.getValue("name");
            }
            if (id != null && id.length() > 0) {
                XHTMLAnchorMemento anchorMemento = new XHTMLAnchorMemento(id, this.getWordCount());
                this.addAnchorMemento(anchorMemento);
            }
        }
        if (!this.inBody && XHTMLAnalyzerSAXHandler.isTag(localName, qName, "body")) {
            this.inBody = true;
        }
    }

    private boolean isExcludeElement(String localName, String qName) {
        if (qName != null && qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        return XHTMLAnalyzerSAXHandler.isTag(localName, qName, "style");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.inWord = false;
        if (this.isExcludeElement(localName, qName)) {
            --this.excludeElement;
        }
        if (this.inBody && XHTMLAnalyzerSAXHandler.isTag(localName, qName, "body")) {
            this.inBody = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inBody || this.excludeElement > 0) {
            return;
        }
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char c = ch[i];
            boolean isWhitespace = Character.isWhitespace(c);
            if (isWhitespace) {
                this.inWord = false;
                continue;
            }
            this.incrementCharacterCount();
            boolean isPunctuation = this.isPunctuation(c);
            if (isPunctuation) {
                this.inWord = false;
                continue;
            }
            if (this.inWord) continue;
            this.incrementWordCount();
            this.inWord = true;
        }
    }

    protected void incrementCharacterCount(long amount) {
        this.characterCount += amount;
    }

    protected void incrementCharacterCount() {
        ++this.characterCount;
    }

    protected void incrementWordCount() {
        ++this.wordCount;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    protected void addAnchorMemento(XHTMLAnchorMemento anchorMemento) {
        if (!this.anchorMementos.containsKey(anchorMemento.getId())) {
            this.anchorMementos.put(anchorMemento.getId(), anchorMemento);
        }
    }

    public Map<String, XHTMLAnchorMemento> getAnchorMementos() {
        return this.anchorMementos;
    }

    private boolean isPunctuation(char c) {
        Character character = Character.valueOf(c);
        return XHTMLAnalyzerSAXHandler.getPunctuationCharset().contains(character);
    }

    private static Set<Character> getPunctuationCharset() {
        if (PUNCTUATION_CHARSET.isEmpty()) {
            PUNCTUATION_CHARSET.add(Character.valueOf('`'));
            PUNCTUATION_CHARSET.add(Character.valueOf('~'));
            PUNCTUATION_CHARSET.add(Character.valueOf('!'));
            PUNCTUATION_CHARSET.add(Character.valueOf('#'));
            PUNCTUATION_CHARSET.add(Character.valueOf('$'));
            PUNCTUATION_CHARSET.add(Character.valueOf('%'));
            PUNCTUATION_CHARSET.add(Character.valueOf('^'));
            PUNCTUATION_CHARSET.add(Character.valueOf('&'));
            PUNCTUATION_CHARSET.add(Character.valueOf('*'));
            PUNCTUATION_CHARSET.add(Character.valueOf('('));
            PUNCTUATION_CHARSET.add(Character.valueOf(')'));
            PUNCTUATION_CHARSET.add(Character.valueOf('-'));
            PUNCTUATION_CHARSET.add(Character.valueOf('_'));
            PUNCTUATION_CHARSET.add(Character.valueOf('='));
            PUNCTUATION_CHARSET.add(Character.valueOf('+'));
            PUNCTUATION_CHARSET.add(Character.valueOf('{'));
            PUNCTUATION_CHARSET.add(Character.valueOf('}'));
            PUNCTUATION_CHARSET.add(Character.valueOf('\\'));
            PUNCTUATION_CHARSET.add(Character.valueOf('|'));
            PUNCTUATION_CHARSET.add(Character.valueOf(';'));
            PUNCTUATION_CHARSET.add(Character.valueOf(':'));
            PUNCTUATION_CHARSET.add(Character.valueOf('\''));
            PUNCTUATION_CHARSET.add(Character.valueOf('\"'));
            PUNCTUATION_CHARSET.add(Character.valueOf(','));
            PUNCTUATION_CHARSET.add(Character.valueOf('<'));
            PUNCTUATION_CHARSET.add(Character.valueOf('.'));
            PUNCTUATION_CHARSET.add(Character.valueOf('>'));
            PUNCTUATION_CHARSET.add(Character.valueOf('/'));
            PUNCTUATION_CHARSET.add(Character.valueOf('?'));
            PUNCTUATION_CHARSET.add(Character.valueOf('?'));
        }
        return PUNCTUATION_CHARSET;
    }

    public long getCharacterCount() {
        return this.characterCount;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.saxParseExceptionLine = e.getLineNumber();
        this.saxParseExceptionColumn = e.getColumnNumber();
        super.fatalError(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.saxParseExceptionLine = e.getLineNumber();
        this.saxParseExceptionColumn = e.getColumnNumber();
        super.error(e);
    }

    public int getSaxParseExceptionLine() {
        return this.saxParseExceptionLine;
    }

    public int getSaxParseExceptionColumn() {
        return this.saxParseExceptionColumn;
    }

    public boolean hasITunesArtworkHrefAtRoot() {
        return this.hasITunesArtworkHrefAtRoot;
    }

    public File getXhtmlFile() {
        return this.xhtmlFile;
    }

    public File getiTunesArtWorkAtRoot() {
        return this.iTunesArtworkAtRoot;
    }

    public List<String> getMissingReferencedFiles() {
        return this.missingReferencedFiles;
    }

    static {
        XHTMLAnalyzerSAXHandler.getPunctuationCharset();
    }
}

