/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.XHTMLAnalyzerSAXHandler;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.XHTMLAnalysis;
import com.apple.itunes.epubtoolkit.model.XHTMLAnchorMemento;
import com.apple.itunes.epubtoolkit.util.DocumentInputSource;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class XHTMLAnalyzer {
    private static final Logger logger = Logger.getLogger(XHTMLAnalyzer.class);

    XHTMLAnalyzer() {
    }

    public XHTMLAnalysis analyze(EPUBModel model, String id) throws EPUBException {
        OPFDocument document = model.getOPF();
        OPFManifestItem manifestItem = document.getManifestItem(id);
        String relativePath = FileUtilities.decodeURIPath(manifestItem.getHref());
        File rootFile = model.getOPFFile();
        File baseDir = rootFile.getParentFile();
        File manifestItemFile = new File(baseDir, relativePath);
        XHTMLAnalysis analysis = this.analyze(manifestItemFile, id, relativePath, model.getDirectory());
        return analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XHTMLAnalysis analyze(File file, String id, String relativePath, File ePubFolder) throws EPUBException {
        long startTime = System.currentTimeMillis();
        DocumentInputSource inputSource = null;
        XHTMLAnalyzerSAXHandler handler = new XHTMLAnalyzerSAXHandler(file, new File(ePubFolder, "iTunesArtwork"));
        try {
            SAXParser parser;
            try {
                inputSource = new DocumentInputSource(file);
            }
            catch (FileNotFoundException e) {
                throw new EPUBException("Unable to find file: " + file.getName(), e);
            }
            try {
                parser = handler.createParser();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected parser exception.", e);
            }
            try {
                parser.parse((InputSource)inputSource, (DefaultHandler)handler);
            }
            catch (Exception e) {
                int exceptionLine = handler.getSaxParseExceptionLine();
                int exceptionColumn = handler.getSaxParseExceptionColumn();
                if (exceptionLine > 0 && exceptionColumn >= 0) {
                    if (inputSource != null) {
                        inputSource.cleanup();
                        inputSource = null;
                    }
                    String errorMessage = XMLUtilities.XMLUtilitiesErrorHandler.getBadCharacterErrorMessage(file, exceptionLine, exceptionColumn);
                    throw new EPUBException(1, errorMessage, exceptionLine, relativePath, e);
                }
                throw new EPUBException("Unable to analyse: " + file.getName(), e);
            }
        }
        finally {
            if (inputSource != null) {
                inputSource.cleanup();
            }
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("XHTMLANALYZER_ANALYZE: TimeInSecs:[" + (double)(endTime - startTime) / 1000.0 + "], FileSizeInBytes:[" + file.length() + "], FileName:[" + relativePath + "]"));
        return new AnalysisBean(file, id, handler.getWordCount(), handler.getCharacterCount(), endTime - startTime, handler.getAnchorMementos(), handler.hasITunesArtworkHrefAtRoot(), handler.getMissingReferencedFiles());
    }

    private static class AnalysisBean
    implements XHTMLAnalysis {
        private File spineItemFile;
        private String id;
        private int wordCount;
        private long characterCount;
        private long analysisTimeInMillis;
        private Map<String, XHTMLAnchorMemento> anchorMementos;
        private boolean hasITunesArtworkHrefAtRoot;
        private List<String> missingReferencedFiles;

        private AnalysisBean(File file, String id, int wordCount, long characterCount, long analysisTimeInMillis, Map<String, XHTMLAnchorMemento> anchorMementos, boolean hasITunesArtworkHrefAtRoot, List<String> missingReferencedFiles) {
            this.spineItemFile = file;
            this.wordCount = wordCount;
            this.anchorMementos = anchorMementos;
            this.characterCount = characterCount;
            this.analysisTimeInMillis = analysisTimeInMillis;
            this.id = id;
            this.hasITunesArtworkHrefAtRoot = hasITunesArtworkHrefAtRoot;
            this.missingReferencedFiles = missingReferencedFiles;
        }

        @Override
        public File getFile() {
            return this.spineItemFile;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getWordCount() {
            return this.wordCount;
        }

        @Override
        public Map<String, XHTMLAnchorMemento> getAnchorMementos() {
            return this.anchorMementos;
        }

        @Override
        public List<String> getMissingReferencedFiles() {
            return this.missingReferencedFiles;
        }

        public String toString() {
            return "AnalysisBean{id='" + this.id + '\'' + ", wordCount=" + this.wordCount + ", characterCount=" + this.characterCount + '}';
        }

        @Override
        public long getCharacterCount() {
            return this.characterCount;
        }

        @Override
        public long getAnalysisTimeInMillis() {
            return this.analysisTimeInMillis;
        }

        @Override
        public boolean hasITunesArtworkHrefAtRoot() {
            return this.hasITunesArtworkHrefAtRoot;
        }
    }
}

